/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.ldap.support;

import com.unboundid.ldap.sdk.Attribute;
import com.unboundid.ldap.sdk.LDAPConnection;
import com.unboundid.ldap.sdk.LDAPInterface;
import java.util.Collection;
import java.util.List;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.common.lease.Releasable;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.log4j.Logger;

public class LdapSession
implements Releasable {
    protected final Logger logger;
    protected final LDAPInterface ldap;
    protected final String userDn;
    protected final GroupsResolver groupsResolver;
    protected final TimeValue timeout;
    protected final Collection<Attribute> attributes;

    public LdapSession(Logger logger, LDAPInterface connection, String userDn, GroupsResolver groupsResolver, TimeValue timeout, Collection<Attribute> attributes) {
        this.logger = logger;
        this.ldap = connection;
        this.userDn = userDn;
        this.groupsResolver = groupsResolver;
        this.timeout = timeout;
        this.attributes = attributes;
    }

    @Override
    public void close() {
        if (this.ldap instanceof LDAPConnection) {
            ((LDAPConnection)this.ldap).close();
        }
    }

    public String userDn() {
        return this.userDn;
    }

    public void groups(ActionListener<List<String>> listener) {
        this.groupsResolver.resolve(this.ldap, this.userDn, this.timeout, this.logger, this.attributes, listener);
    }

    public static interface GroupsResolver {
        public void resolve(LDAPInterface var1, String var2, TimeValue var3, Logger var4, Collection<Attribute> var5, ActionListener<List<String>> var6);

        public String[] attributes();
    }
}

