/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc.file;

import java.io.IOException;
import java.io.PrintWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.common.inject.internal.Nullable;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.env.Environment;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.watcher.FileChangesListener;
import org.elasticsearch.watcher.FileWatcher;
import org.elasticsearch.watcher.ResourceWatcherService;
import org.elasticsearch.xpack.XPackPlugin;
import org.elasticsearch.xpack.XPackSettings;
import org.elasticsearch.xpack.security.authc.RealmConfig;
import org.elasticsearch.xpack.security.authc.support.Hasher;
import org.elasticsearch.xpack.security.authc.support.SecuredString;
import org.elasticsearch.xpack.security.support.NoOpLogger;
import org.elasticsearch.xpack.security.support.SecurityFiles;
import org.elasticsearch.xpack.security.support.Validation;

public class FileUserPasswdStore {
    private final Logger logger;
    private final Path file;
    private final Hasher hasher = Hasher.BCRYPT;
    private final Settings settings;
    private final CopyOnWriteArrayList<Runnable> listeners;
    private volatile Map<String, char[]> users;

    public FileUserPasswdStore(RealmConfig config, ResourceWatcherService watcherService) {
        this(config, watcherService, () -> {});
    }

    FileUserPasswdStore(RealmConfig config, ResourceWatcherService watcherService, Runnable listener) {
        this.logger = config.logger(FileUserPasswdStore.class);
        this.file = FileUserPasswdStore.resolveFile(config.env());
        this.settings = config.globalSettings();
        this.users = FileUserPasswdStore.parseFileLenient(this.file, this.logger, this.settings);
        this.listeners = new CopyOnWriteArrayList<Runnable>(Collections.singletonList(listener));
        FileWatcher watcher = new FileWatcher(this.file.getParent());
        watcher.addListener(new FileListener());
        try {
            watcherService.add(watcher, ResourceWatcherService.Frequency.HIGH);
        }
        catch (IOException e) {
            throw new ElasticsearchException("failed to start watching users file [{}]", (Throwable)e, this.file.toAbsolutePath());
        }
    }

    public void addListener(Runnable listener) {
        this.listeners.add(listener);
    }

    public int usersCount() {
        return this.users.size();
    }

    public boolean verifyPassword(String username, SecuredString password) {
        char[] hash = this.users.get(username);
        return hash != null && this.hasher.verify(password, hash);
    }

    public boolean userExists(String username) {
        return this.users != null && this.users.containsKey(username);
    }

    public static Path resolveFile(Environment env) {
        return XPackPlugin.resolveConfigFile(env, "users");
    }

    static Map<String, char[]> parseFileLenient(Path path, Logger logger, Settings settings) {
        try {
            return FileUserPasswdStore.parseFile(path, logger, settings);
        }
        catch (Exception e) {
            logger.error(() -> new ParameterizedMessage("failed to parse users file [{}]. skipping/removing all users...", (Object)path.toAbsolutePath()), (Throwable)e);
            return Collections.emptyMap();
        }
    }

    public static Map<String, char[]> parseFile(Path path, @Nullable Logger logger, Settings settings) {
        List<String> lines;
        if (logger == null) {
            logger = NoOpLogger.INSTANCE;
        }
        logger.trace("reading users file [{}]...", (Object)path.toAbsolutePath());
        if (!Files.exists(path, new LinkOption[0])) {
            return Collections.emptyMap();
        }
        try {
            lines = Files.readAllLines(path, StandardCharsets.UTF_8);
        }
        catch (IOException ioe) {
            throw new IllegalStateException("could not read users file [" + path.toAbsolutePath() + "]", ioe);
        }
        HashMap<String, char[]> users = new HashMap<String, char[]>();
        boolean allowReserved = XPackSettings.RESERVED_REALM_ENABLED_SETTING.get(settings) == false;
        int lineNr = 0;
        for (String line : lines) {
            ++lineNr;
            if (line.startsWith("#")) continue;
            int i = (line = line.trim()).indexOf(":");
            if (i <= 0 || i == line.length() - 1) {
                logger.error("invalid entry in users file [{}], line [{}]. skipping...", (Object)path.toAbsolutePath(), (Object)lineNr);
                continue;
            }
            String username = line.substring(0, i);
            Validation.Error validationError = Validation.Users.validateUsername(username, allowReserved, settings);
            if (validationError != null) {
                logger.error("invalid username [{}] in users file [{}], skipping... ({})", (Object)username, (Object)path.toAbsolutePath(), (Object)validationError);
                continue;
            }
            String hash = line.substring(i + 1);
            users.put(username, hash.toCharArray());
        }
        logger.debug("parsed [{}] users from file [{}]", (Object)users.size(), (Object)path.toAbsolutePath());
        return Collections.unmodifiableMap(users);
    }

    public static void writeFile(Map<String, char[]> users, Path path) {
        try (PrintWriter writer = new PrintWriter(SecurityFiles.openAtomicMoveWriter(path));){
            for (Map.Entry<String, char[]> entry : users.entrySet()) {
                writer.printf(Locale.ROOT, "%s:%s%s", entry.getKey(), new String(entry.getValue()), System.lineSeparator());
            }
        }
        catch (IOException ioe) {
            throw new ElasticsearchException("could not write file [{}], please check file permissions", (Throwable)ioe, path.toAbsolutePath());
        }
    }

    void notifyRefresh() {
        this.listeners.forEach(Runnable::run);
    }

    private class FileListener
    implements FileChangesListener {
        private FileListener() {
        }

        @Override
        public void onFileCreated(Path file) {
            this.onFileChanged(file);
        }

        @Override
        public void onFileDeleted(Path file) {
            this.onFileChanged(file);
        }

        @Override
        public void onFileChanged(Path file) {
            if (file.equals(FileUserPasswdStore.this.file)) {
                FileUserPasswdStore.this.logger.info("users file [{}] changed. updating users... )", (Object)file.toAbsolutePath());
                FileUserPasswdStore.this.users = FileUserPasswdStore.parseFileLenient(file, FileUserPasswdStore.this.logger, FileUserPasswdStore.this.settings);
                FileUserPasswdStore.this.notifyRefresh();
            }
        }
    }
}

