/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.authc;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Consumer;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.settings.AbstractScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.xpack.extensions.XPackExtension;
import org.elasticsearch.xpack.security.Security;
import org.elasticsearch.xpack.security.authc.InternalRealms;
import org.elasticsearch.xpack.security.authc.RealmConfig;

public class RealmSettings {
    public static final String PREFIX = Security.setting("authc.realms.");
    static final Setting<String> TYPE_SETTING = Setting.simpleString("type", Setting.Property.NodeScope);
    static final Setting<Boolean> ENABLED_SETTING = Setting.boolSetting("enabled", true, Setting.Property.NodeScope);
    static final Setting<Integer> ORDER_SETTING = Setting.intSetting("order", Integer.MAX_VALUE, Setting.Property.NodeScope);

    public static void addSettings(List<Setting<?>> settingsList, List<XPackExtension> extensions) {
        settingsList.add(RealmSettings.getGroupSetting(extensions));
    }

    public static Settings get(Settings settings) {
        return settings.getByPrefix(PREFIX);
    }

    public static String getFullSettingKey(RealmConfig realm, Setting<?> setting) {
        return RealmSettings.getFullSettingKey(realm.name(), setting);
    }

    public static String getFullSettingKey(RealmConfig realm, String subKey) {
        return RealmSettings.getFullSettingKey(realm.name(), subKey);
    }

    private static String getFullSettingKey(String name, Setting<?> setting) {
        return RealmSettings.getFullSettingKey(name, setting.getKey());
    }

    private static String getFullSettingKey(String name, String subKey) {
        return PREFIX + name + "." + subKey;
    }

    private static Setting<Settings> getGroupSetting(List<XPackExtension> extensions) {
        return Setting.groupSetting(PREFIX, RealmSettings.getSettingsValidator(extensions), Setting.Property.NodeScope);
    }

    private static Consumer<Settings> getSettingsValidator(List<XPackExtension> extensions) {
        HashMap childSettings = new HashMap(InternalRealms.getSettings());
        if (extensions != null) {
            extensions.forEach(ext -> {
                Map<String, Set<Setting<?>>> extSettings = ext.getRealmSettings();
                extSettings.keySet().stream().filter(childSettings::containsKey).forEach(type -> {
                    throw new IllegalArgumentException("duplicate realm type " + type);
                });
                childSettings.putAll(extSettings);
            });
        }
        childSettings.forEach(RealmSettings::verify);
        return RealmSettings.validator(childSettings);
    }

    private static void verify(String type, Set<Setting<?>> settings) {
        HashSet keys = new HashSet();
        settings.forEach(setting -> {
            String key = setting.getKey();
            if (keys.contains(key)) {
                throw new IllegalArgumentException("duplicate setting for key " + key + " in realm type " + type);
            }
            keys.add(key);
            if (!setting.getProperties().contains((Object)Setting.Property.NodeScope)) {
                throw new IllegalArgumentException("setting " + key + " in realm type " + type + " does not have NodeScope");
            }
        });
    }

    private static Consumer<Settings> validator(Map<String, Set<Setting<?>>> validSettings) {
        return settings -> settings.names().forEach(n -> RealmSettings.validateRealm(n, settings.getAsSettings((String)n), validSettings));
    }

    private static void validateRealm(String name, Settings settings, Map<String, Set<Setting<?>>> validSettings) {
        String type = TYPE_SETTING.get(settings);
        if (Strings.isNullOrEmpty(type)) {
            throw new IllegalArgumentException("missing realm type [" + RealmSettings.getFullSettingKey(name, TYPE_SETTING) + "] for realm");
        }
        RealmSettings.validateRealm(name, type, settings, validSettings.get(type));
    }

    private static void validateRealm(String name, String type, Settings settings, Set<Setting<?>> validSettings) {
        if (validSettings == null) {
            return;
        }
        HashSet settingSet = new HashSet(validSettings);
        settingSet.add(TYPE_SETTING);
        settingSet.add(ENABLED_SETTING);
        settingSet.add(ORDER_SETTING);
        AbstractScopedSettings validator = new AbstractScopedSettings(settings, (Set)settingSet, Setting.Property.NodeScope){};
        try {
            validator.validate(settings);
        }
        catch (RuntimeException e) {
            throw new IllegalArgumentException("incorrect configuration for realm [" + RealmSettings.getFullSettingKey(name, "") + "] of type " + type, e);
        }
    }

    private RealmSettings() {
    }
}

