/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security.action.role;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.HandledTransportAction;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportService;
import org.elasticsearch.xpack.security.action.role.PutRoleRequest;
import org.elasticsearch.xpack.security.action.role.PutRoleResponse;
import org.elasticsearch.xpack.security.authz.store.NativeRolesStore;
import org.elasticsearch.xpack.security.authz.store.ReservedRolesStore;

public class TransportPutRoleAction
extends HandledTransportAction<PutRoleRequest, PutRoleResponse> {
    private final NativeRolesStore rolesStore;

    @Inject
    public TransportPutRoleAction(Settings settings, ThreadPool threadPool, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver, NativeRolesStore rolesStore, TransportService transportService) {
        super(settings, "cluster:admin/xpack/security/role/put", threadPool, transportService, actionFilters, indexNameExpressionResolver, PutRoleRequest::new);
        this.rolesStore = rolesStore;
    }

    @Override
    protected void doExecute(final PutRoleRequest request, final ActionListener<PutRoleResponse> listener) {
        String name = request.roleDescriptor().getName();
        if (ReservedRolesStore.isReserved(name)) {
            listener.onFailure(new IllegalArgumentException("role [" + name + "] is reserved and cannot be modified."));
            return;
        }
        this.rolesStore.putRole(request, request.roleDescriptor(), new ActionListener<Boolean>(){

            @Override
            public void onResponse(Boolean created) {
                if (created.booleanValue()) {
                    TransportPutRoleAction.this.logger.info("added role [{}]", (Object)request.name());
                } else {
                    TransportPutRoleAction.this.logger.info("updated role [{}]", (Object)request.name());
                }
                listener.onResponse(new PutRoleResponse(created));
            }

            @Override
            public void onFailure(Exception t) {
                listener.onFailure(t);
            }
        });
    }
}

