/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.security;

import java.io.IOException;
import java.util.Objects;
import java.util.function.Consumer;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.node.Node;
import org.elasticsearch.xpack.security.authc.Authentication;
import org.elasticsearch.xpack.security.authc.AuthenticationService;
import org.elasticsearch.xpack.security.crypto.CryptoService;
import org.elasticsearch.xpack.security.user.User;

public class SecurityContext {
    private final Logger logger;
    private final ThreadContext threadContext;
    private final CryptoService cryptoService;
    private final boolean signUserHeader;
    private final String nodeName;

    public SecurityContext(Settings settings, ThreadContext threadContext, CryptoService cryptoService) {
        this.logger = Loggers.getLogger(this.getClass(), settings, new String[0]);
        this.threadContext = threadContext;
        this.cryptoService = cryptoService;
        this.signUserHeader = AuthenticationService.SIGN_USER_HEADER.get(settings);
        this.nodeName = Node.NODE_NAME_SETTING.get(settings);
    }

    public User getUser() {
        Authentication authentication = this.getAuthentication();
        return authentication == null ? null : authentication.getUser();
    }

    public Authentication getAuthentication() {
        try {
            return Authentication.readFromContext(this.threadContext, this.cryptoService, this.signUserHeader);
        }
        catch (IOException e) {
            this.logger.error("failed to read authentication", (Throwable)e);
            return null;
        }
    }

    void setUser(User user) {
        Objects.requireNonNull(user);
        Authentication.RealmRef lookedUpBy = user.runAs() == null ? null : new Authentication.RealmRef("__attach", "__attach", this.nodeName);
        try {
            Authentication authentication = new Authentication(user, new Authentication.RealmRef("__attach", "__attach", this.nodeName), lookedUpBy);
            authentication.writeToContext(this.threadContext, this.cryptoService, this.signUserHeader);
        }
        catch (IOException e) {
            throw new AssertionError("how can we have a IOException with a user we set", e);
        }
    }

    public void executeAsUser(User user, Consumer<ThreadContext.StoredContext> consumer) {
        ThreadContext.StoredContext original = this.threadContext.newStoredContext(true);
        try (ThreadContext.StoredContext ctx = this.threadContext.stashContext();){
            this.setUser(user);
            consumer.accept(original);
        }
    }
}

