/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification.pagerduty;

import java.io.IOException;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.xpack.common.http.HttpClient;
import org.elasticsearch.xpack.common.http.HttpRequest;
import org.elasticsearch.xpack.common.http.HttpResponse;
import org.elasticsearch.xpack.notification.pagerduty.IncidentEvent;
import org.elasticsearch.xpack.notification.pagerduty.IncidentEventDefaults;
import org.elasticsearch.xpack.notification.pagerduty.SentEvent;
import org.elasticsearch.xpack.watcher.watch.Payload;

public class PagerDutyAccount {
    public static final String SERVICE_KEY_SETTING = "service_api_key";
    public static final String TRIGGER_DEFAULTS_SETTING = "event_defaults";
    final String name;
    final String serviceKey;
    final HttpClient httpClient;
    final IncidentEventDefaults eventDefaults;
    final Logger logger;

    public PagerDutyAccount(String name, Settings accountSettings, Settings serviceSettings, HttpClient httpClient, Logger logger) {
        this.name = name;
        this.serviceKey = accountSettings.get(SERVICE_KEY_SETTING, serviceSettings.get(SERVICE_KEY_SETTING, null));
        if (this.serviceKey == null) {
            throw new SettingsException("invalid pagerduty account [" + name + "]. missing required [" + SERVICE_KEY_SETTING + "] setting");
        }
        this.httpClient = httpClient;
        this.eventDefaults = new IncidentEventDefaults(accountSettings.getAsSettings(TRIGGER_DEFAULTS_SETTING));
        this.logger = logger;
    }

    public String getName() {
        return this.name;
    }

    public IncidentEventDefaults getDefaults() {
        return this.eventDefaults;
    }

    public SentEvent send(IncidentEvent event, Payload payload) throws IOException {
        HttpRequest request = event.createRequest(this.serviceKey, payload);
        HttpResponse response = this.httpClient.execute(request);
        return SentEvent.responded(event, request, response);
    }
}

