/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.notification;

import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.function.BiFunction;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsException;

public abstract class NotificationService<Account>
extends AbstractComponent {
    private Map<String, Account> accounts;
    protected Account defaultAccount;

    public NotificationService(Settings settings) {
        super(settings);
    }

    protected synchronized void setAccountSetting(Settings settings) {
        Tuple<Map<String, Object>, Object> accounts = this.buildAccounts(settings, this::createAccount);
        this.accounts = Collections.unmodifiableMap(accounts.v1());
        this.defaultAccount = accounts.v2();
    }

    protected abstract Account createAccount(String var1, Settings var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Account getAccount(String name) {
        Account defaultAccount;
        Map<String, Account> accounts;
        NotificationService notificationService = this;
        synchronized (notificationService) {
            accounts = this.accounts;
            defaultAccount = this.defaultAccount;
        }
        Account theAccount = accounts.getOrDefault(name, defaultAccount);
        if (theAccount == null) {
            throw new IllegalArgumentException("no account found for name: [" + name + "]");
        }
        return theAccount;
    }

    private <A> Tuple<Map<String, A>, A> buildAccounts(Settings settings, BiFunction<String, Settings, A> accountFactory) {
        Object defaultAccount;
        Settings accountsSettings = settings.getAsSettings("account");
        HashMap<String, A> accounts = new HashMap<String, A>();
        for (String name : accountsSettings.names()) {
            Settings accountSettings = accountsSettings.getAsSettings(name);
            A account = accountFactory.apply(name, accountSettings);
            accounts.put(name, account);
        }
        String defaultAccountName = settings.get("default_account");
        if (defaultAccountName == null) {
            if (accounts.isEmpty()) {
                defaultAccount = null;
            } else {
                Object account = accounts.values().iterator().next();
                defaultAccount = account;
            }
        } else {
            defaultAccount = accounts.get(defaultAccountName);
            if (defaultAccount == null) {
                throw new SettingsException("could not find default account [" + defaultAccountName + "]");
            }
        }
        return new Tuple(accounts, defaultAccount);
    }
}

