/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.local;

import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesAction;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesRequest;
import org.elasticsearch.action.admin.indices.alias.IndicesAliasesResponse;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexRequest;
import org.elasticsearch.action.admin.indices.delete.DeleteIndexResponse;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingRequest;
import org.elasticsearch.action.admin.indices.mapping.put.PutMappingResponse;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.action.ingest.PutPipelineRequest;
import org.elasticsearch.action.ingest.WritePipelineResponse;
import org.elasticsearch.action.support.master.AcknowledgedResponse;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateListener;
import org.elasticsearch.cluster.block.ClusterBlockLevel;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.regex.Regex;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.gateway.GatewayService;
import org.elasticsearch.ingest.IngestMetadata;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.xpack.monitoring.cleaner.CleanerService;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.Exporter;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringTemplateUtils;
import org.elasticsearch.xpack.monitoring.exporter.local.LocalBulk;
import org.elasticsearch.xpack.monitoring.resolver.MonitoringIndexNameResolver;
import org.elasticsearch.xpack.monitoring.resolver.ResolversRegistry;
import org.elasticsearch.xpack.security.InternalClient;
import org.joda.time.DateTime;
import org.joda.time.DateTimeZone;

public class LocalExporter
extends Exporter
implements ClusterStateListener,
CleanerService.Listener {
    private static final Logger logger = Loggers.getLogger(LocalExporter.class);
    public static final String TYPE = "local";
    private final InternalClient client;
    private final ClusterService clusterService;
    private final ResolversRegistry resolvers;
    private final CleanerService cleanerService;
    private final AtomicReference<State> state = new AtomicReference<State>(State.INITIALIZED);
    private final AtomicBoolean installingSomething = new AtomicBoolean(false);
    private final AtomicBoolean waitedForSetup = new AtomicBoolean(false);

    public LocalExporter(Exporter.Config config, InternalClient client, ClusterService clusterService, CleanerService cleanerService) {
        super(config);
        this.client = client;
        this.clusterService = clusterService;
        this.cleanerService = cleanerService;
        this.resolvers = new ResolversRegistry(config.settings());
        for (MonitoringIndexNameResolver resolver : this.resolvers) {
            if (resolver.template() != null) continue;
            throw new IllegalStateException("unable to find built-in template " + resolver.templateName());
        }
        clusterService.addListener(this);
        cleanerService.add(this);
    }

    ResolversRegistry getResolvers() {
        return this.resolvers;
    }

    @Override
    public void clusterChanged(ClusterChangedEvent event) {
        if (this.state.get() == State.INITIALIZED) {
            this.resolveBulk(event.state());
        }
    }

    @Override
    public ExportBulk openBulk() {
        if (this.state.get() != State.RUNNING) {
            return null;
        }
        return this.resolveBulk(this.clusterService.state());
    }

    @Override
    public void doClose() {
        if (this.state.getAndSet(State.TERMINATED) != State.TERMINATED) {
            logger.trace("stopped");
            this.clusterService.removeListener(this);
            this.cleanerService.remove(this);
        }
    }

    LocalBulk resolveBulk(ClusterState clusterState) {
        if (this.clusterService.localNode() == null || clusterState == null) {
            return null;
        }
        if (clusterState.blocks().hasGlobalBlock(GatewayService.STATE_NOT_RECOVERED_BLOCK)) {
            logger.debug("waiting until gateway has recovered from disk");
            return null;
        }
        Map<String, String> templates = StreamSupport.stream(new ResolversRegistry(Settings.EMPTY).spliterator(), false).collect(Collectors.toMap(MonitoringIndexNameResolver::templateName, MonitoringIndexNameResolver::template, (a, b) -> a));
        boolean setup = true;
        if (this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            setup = this.setupIfElectedMaster(clusterState, templates);
        } else if (!this.setupIfNotElectedMaster(clusterState, templates.keySet())) {
            if (this.waitedForSetup.getAndSet(true)) {
                logger.info("waiting for elected master node [{}] to setup local exporter [{}] (does it have x-pack installed?)", (Object)this.clusterService.state().nodes().getMasterNode(), (Object)this.config.name());
            }
            setup = false;
        }
        if (!setup) {
            return null;
        }
        if (this.state.compareAndSet(State.INITIALIZED, State.RUNNING)) {
            logger.debug("started");
            this.clusterService.removeListener(this);
        }
        return new LocalBulk(this.name(), logger, this.client, this.resolvers, this.config.settings().getAsBoolean("use_ingest", true));
    }

    private boolean setupIfNotElectedMaster(ClusterState clusterState, Set<String> templates) {
        for (String type : MonitoringTemplateUtils.NEW_DATA_TYPES) {
            if (this.hasMappingType(type, clusterState)) continue;
            logger.debug("monitoring index mapping [{}] does not exist in [{}], so service cannot start", (Object)type, (Object)".monitoring-data-2");
            return false;
        }
        for (String template : templates) {
            if (this.hasTemplate(template, clusterState)) continue;
            logger.debug("monitoring index template [{}] does not exist, so service cannot start", (Object)template);
            return false;
        }
        if (!this.hasIngestPipelines(clusterState)) {
            logger.debug("monitoring ingest pipeline [{}] does not exist, so service cannot start", (Object)"xpack_monitoring_2");
            return false;
        }
        if (null != this.prepareAddAliasesTo2xIndices(clusterState)) {
            logger.debug("old monitoring indexes exist without aliases, waiting for them to get new aliases");
            return false;
        }
        logger.trace("monitoring index templates and pipelines are installed, service can start");
        return true;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean setupIfElectedMaster(ClusterState clusterState, Map<String, String> templates) {
        if (clusterState.blocks().hasGlobalBlock(ClusterBlockLevel.METADATA_WRITE)) {
            logger.debug("waiting until metadata writes are unblocked");
            return false;
        }
        if (this.installingSomething.get()) {
            logger.trace("already installing something, waiting for install to complete");
            return false;
        }
        ArrayList<Runnable> asyncActions = new ArrayList<Runnable>();
        final AtomicInteger pendingResponses = new AtomicInteger(0);
        List missingMappingTypes = Arrays.stream(MonitoringTemplateUtils.NEW_DATA_TYPES).filter(type -> !this.hasMappingType((String)type, clusterState)).collect(Collectors.toList());
        List missingTemplates = templates.entrySet().stream().filter(e -> !this.hasTemplate((String)e.getKey(), clusterState)).collect(Collectors.toList());
        if (!missingMappingTypes.isEmpty()) {
            logger.debug(() -> new ParameterizedMessage("type {} not found", (Object)missingMappingTypes.stream().collect(Collectors.toList())));
            for (String type2 : missingMappingTypes) {
                asyncActions.add(() -> this.putMappingType(type2, new ResponseActionListener<PutMappingResponse>("type", type2, pendingResponses)));
            }
        }
        if (!missingTemplates.isEmpty()) {
            logger.debug(() -> new ParameterizedMessage("template {} not found", (Object)missingTemplates.stream().map(Map.Entry::getKey).collect(Collectors.toList())));
            for (Map.Entry template : missingTemplates) {
                asyncActions.add(() -> this.putTemplate((String)template.getKey(), (String)template.getValue(), new ResponseActionListener<PutIndexTemplateResponse>("template", (String)template.getKey(), pendingResponses)));
            }
        }
        if (!this.hasIngestPipelines(clusterState)) {
            logger.debug("pipeline [{}] not found", (Object)"xpack_monitoring_2");
            asyncActions.add(() -> this.putIngestPipeline(new ResponseActionListener<WritePipelineResponse>("pipeline", "xpack_monitoring_2", pendingResponses)));
        } else {
            logger.trace("pipeline [{}] found", (Object)"xpack_monitoring_2");
        }
        IndicesAliasesRequest addAliasesTo2xIndices = this.prepareAddAliasesTo2xIndices(clusterState);
        if (addAliasesTo2xIndices == null) {
            logger.trace("there are no 2.x monitoring indices or they have all the aliases they need");
        } else {
            final List monitoringIndices2x = addAliasesTo2xIndices.getAliasActions().stream().flatMap(a -> Arrays.stream(a.indices())).collect(Collectors.toList());
            logger.debug("there are 2.x monitoring indices {} and they are missing some aliases to make them compatible with 5.x", (Object)monitoringIndices2x);
            asyncActions.add(() -> this.client.execute(IndicesAliasesAction.INSTANCE, addAliasesTo2xIndices, new ActionListener<IndicesAliasesResponse>(){

                @Override
                public void onResponse(IndicesAliasesResponse response) {
                    this.responseReceived();
                    if (response.isAcknowledged()) {
                        logger.info("Added modern aliases to 2.x monitoring indices {}", (Object)monitoringIndices2x);
                    } else {
                        logger.info("Unable to add modern aliases to 2.x monitoring indices {}, response not acknowledged.", (Object)monitoringIndices2x);
                    }
                }

                @Override
                public void onFailure(Exception e) {
                    this.responseReceived();
                    logger.error(() -> new ParameterizedMessage("Unable to add modern aliases to 2.x monitoring indices {}", (Object)monitoringIndices2x), (Throwable)e);
                }

                private void responseReceived() {
                    if (pendingResponses.decrementAndGet() <= 0) {
                        logger.trace("all installation requests returned a response");
                        if (!LocalExporter.this.installingSomething.compareAndSet(true, false)) {
                            throw new IllegalStateException("could not reset installing flag to false");
                        }
                    }
                }
            }));
        }
        if (asyncActions.size() > 0) {
            if (!this.installingSomething.compareAndSet(false, true)) return false;
            pendingResponses.set(asyncActions.size());
            asyncActions.forEach(Runnable::run);
            return true;
        } else {
            logger.debug("monitoring index templates and pipelines are installed on master node, service can start");
        }
        return true;
    }

    private boolean hasMappingType(String type, ClusterState clusterState) {
        IndexMetaData dataIndex = clusterState.getMetaData().getIndices().get(".monitoring-data-2");
        return dataIndex == null || dataIndex.getMappings().containsKey(type);
    }

    private void putMappingType(String type, ActionListener<PutMappingResponse> listener) {
        logger.debug("adding mapping type [{}] to [{}]", (Object)type, (Object)".monitoring-data-2");
        PutMappingRequest putMapping = new PutMappingRequest(".monitoring-data-2");
        putMapping.type(type);
        putMapping.source("{\"enabled\":false}", XContentType.JSON);
        this.client.admin().indices().putMapping(putMapping, listener);
    }

    private boolean hasIngestPipelines(ClusterState clusterState) {
        IngestMetadata ingestMetadata = (IngestMetadata)clusterState.getMetaData().custom("ingest");
        return ingestMetadata != null && ingestMetadata.getPipelines().containsKey("xpack_monitoring_2");
    }

    private void putIngestPipeline(ActionListener<WritePipelineResponse> listener) {
        logger.debug("installing ingest pipeline [{}]", (Object)"xpack_monitoring_2");
        BytesReference emptyPipeline = LocalExporter.emptyPipeline(XContentType.JSON).bytes();
        PutPipelineRequest request = new PutPipelineRequest("xpack_monitoring_2", emptyPipeline, XContentType.JSON);
        this.client.admin().cluster().putPipeline(request, listener);
    }

    private ImmutableOpenMap<String, Integer> findTemplates(String templatePattern, ClusterState state) {
        if (state == null || state.getMetaData() == null || state.getMetaData().getTemplates().isEmpty()) {
            return ImmutableOpenMap.of();
        }
        ImmutableOpenMap.Builder templates = ImmutableOpenMap.builder();
        for (ObjectCursor template : state.metaData().templates().keys()) {
            if (!Regex.simpleMatch(templatePattern, (String)template.value)) continue;
            try {
                Integer version = Integer.parseInt(((String)template.value).substring(templatePattern.length() - 1));
                templates.put(template.value, version);
                logger.debug("found index template [{}] in version [{}]", template.value, (Object)version);
            }
            catch (NumberFormatException e) {
                logger.warn("cannot extract version number for template [{}]", template.value);
            }
        }
        return templates.build();
    }

    private boolean hasTemplate(String templateName, ClusterState state) {
        ImmutableOpenMap<String, Integer> templates = this.findTemplates(templateName, state);
        return templates.size() > 0;
    }

    private void putTemplate(String template, String source, ActionListener<PutIndexTemplateResponse> listener) {
        logger.debug("installing template [{}]", (Object)template);
        PutIndexTemplateRequest request = new PutIndexTemplateRequest(template).source(source, XContentType.JSON);
        assert (!Thread.currentThread().isInterrupted()) : "current thread has been interrupted before putting index template!!!";
        this.client.admin().indices().putTemplate(request, listener);
    }

    @Override
    public void onCleanUpIndices(TimeValue retention) {
        if (this.state.get() != State.RUNNING) {
            logger.debug("exporter not ready");
            return;
        }
        if (this.clusterService.state().nodes().isLocalNodeElectedMaster()) {
            DateTime expiration = new DateTime(DateTimeZone.UTC).minus(retention.millis());
            logger.debug("cleaning indices [expiration={}, retention={}]", (Object)expiration, (Object)retention);
            ClusterState clusterState = this.clusterService.state();
            if (clusterState != null) {
                long expirationTime = expiration.getMillis();
                String[] patterns = (String[])StreamSupport.stream(this.getResolvers().spliterator(), false).map(MonitoringIndexNameResolver::indexPattern).distinct().toArray(String[]::new);
                MonitoringDoc monitoringDoc = new MonitoringDoc(null, null);
                monitoringDoc.setTimestamp(System.currentTimeMillis());
                Set currents = StreamSupport.stream(this.getResolvers().spliterator(), false).map(r -> r.index(monitoringDoc)).collect(Collectors.toSet());
                HashSet<String> indices = new HashSet<String>();
                for (ObjectObjectCursor<String, IndexMetaData> objectObjectCursor : clusterState.getMetaData().indices()) {
                    long creationDate;
                    String indexName = (String)objectObjectCursor.key;
                    if (!Regex.simpleMatch(patterns, indexName) || currents.contains(indexName) || (creationDate = ((IndexMetaData)objectObjectCursor.value).getCreationDate()) > expirationTime) continue;
                    if (logger.isDebugEnabled()) {
                        logger.debug("detected expired index [name={}, created={}, expired={}]", (Object)indexName, (Object)new DateTime(creationDate, DateTimeZone.UTC), (Object)expiration);
                    }
                    indices.add(indexName);
                }
                if (!indices.isEmpty()) {
                    logger.info("cleaning up [{}] old indices", (Object)indices.size());
                    this.deleteIndices(indices);
                } else {
                    logger.debug("no old indices found for clean up");
                }
            }
        }
    }

    private void deleteIndices(final Set<String> indices) {
        logger.trace("deleting {} indices: [{}]", (Object)indices.size(), (Object)Strings.collectionToCommaDelimitedString(indices));
        this.client.admin().indices().delete(new DeleteIndexRequest(indices.toArray(new String[indices.size()])), new ActionListener<DeleteIndexResponse>(){

            @Override
            public void onResponse(DeleteIndexResponse response) {
                if (response.isAcknowledged()) {
                    logger.debug("{} indices deleted", (Object)indices.size());
                } else {
                    logger.warn("deletion of {} indices wasn't acknowledged", (Object)indices.size());
                }
            }

            @Override
            public void onFailure(Exception e) {
                logger.error("failed to delete indices", (Throwable)e);
            }
        });
    }

    private IndicesAliasesRequest prepareAddAliasesTo2xIndices(ClusterState clusterState) {
        IndicesAliasesRequest request = null;
        for (IndexMetaData index : clusterState.metaData()) {
            String name = index.getIndex().getName();
            if (!name.startsWith(".marvel-es-1-")) continue;
            String alias = ".monitoring-es-2-" + name.substring(".marvel-es-1-".length()) + "-alias";
            if (index.getAliases().containsKey(alias)) continue;
            if (request == null) {
                request = new IndicesAliasesRequest();
            }
            request.addAliasAction(IndicesAliasesRequest.AliasActions.add().index(name).alias(alias));
        }
        return request;
    }

    private class ResponseActionListener<Response extends AcknowledgedResponse>
    implements ActionListener<Response> {
        private final String type;
        private final String name;
        private final AtomicInteger countDown;

        private ResponseActionListener(String type, String name, AtomicInteger countDown) {
            this.type = Objects.requireNonNull(type);
            this.name = Objects.requireNonNull(name);
            this.countDown = Objects.requireNonNull(countDown);
        }

        @Override
        public void onResponse(Response response) {
            this.responseReceived();
            if (((AcknowledgedResponse)response).isAcknowledged()) {
                logger.trace("successfully set monitoring {} [{}]", (Object)this.type, (Object)this.name);
            } else {
                logger.error("failed to set monitoring index {} [{}]", (Object)this.type, (Object)this.name);
            }
        }

        @Override
        public void onFailure(Exception e) {
            this.responseReceived();
            logger.error(() -> new ParameterizedMessage("failed to set monitoring index {} [{}]", (Object)this.type, (Object)this.name), (Throwable)e);
        }

        private void responseReceived() {
            if (this.countDown.decrementAndGet() <= 0) {
                logger.trace("all installation requests returned a response");
                if (!LocalExporter.this.installingSomething.compareAndSet(true, false)) {
                    throw new IllegalStateException("could not reset installing flag to false");
                }
            }
        }
    }

    static enum State {
        INITIALIZED,
        RUNNING,
        TERMINATED;

    }
}

