/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.monitoring.exporter.http;

import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import org.apache.http.Header;
import org.apache.http.HttpEntity;
import org.apache.http.entity.ByteArrayEntity;
import org.apache.http.entity.ContentType;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.client.RestClient;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.util.concurrent.ThreadContext;
import org.elasticsearch.common.xcontent.XContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.xpack.monitoring.exporter.ExportBulk;
import org.elasticsearch.xpack.monitoring.exporter.ExportException;
import org.elasticsearch.xpack.monitoring.exporter.MonitoringDoc;
import org.elasticsearch.xpack.monitoring.exporter.http.HttpExportBulkResponseListener;
import org.elasticsearch.xpack.monitoring.resolver.MonitoringIndexNameResolver;
import org.elasticsearch.xpack.monitoring.resolver.ResolversRegistry;

class HttpExportBulk
extends ExportBulk {
    private static final Logger logger = Loggers.getLogger(HttpExportBulk.class);
    private final RestClient client;
    private final Map<String, String> params;
    private final ResolversRegistry registry;
    private byte[] payload = null;

    HttpExportBulk(String name, RestClient client, Map<String, String> parameters, ResolversRegistry registry, ThreadContext threadContext) {
        super(name, threadContext);
        this.client = client;
        this.params = parameters;
        this.registry = registry;
    }

    @Override
    public void doAdd(Collection<MonitoringDoc> docs) throws ExportException {
        block15: {
            try {
                if (docs == null || docs.isEmpty()) break block15;
                try (BytesStreamOutput payload = new BytesStreamOutput();){
                    for (MonitoringDoc monitoringDoc : docs) {
                        payload.write(this.toBulkBytes(monitoringDoc));
                    }
                    this.payload = BytesReference.toBytes(payload.bytes());
                }
            }
            catch (Exception e) {
                throw new ExportException("failed to add documents to export bulk [{}]", (Throwable)e, this.name);
            }
        }
    }

    @Override
    public void doFlush(ActionListener<Void> listener) throws ExportException {
        if (this.payload == null) {
            listener.onFailure(new ExportException("unable to send documents because none were loaded for export bulk [{}]", this.name));
        } else if (this.payload.length != 0) {
            ByteArrayEntity body = new ByteArrayEntity(this.payload, ContentType.APPLICATION_JSON);
            this.client.performRequestAsync("POST", "/_bulk", this.params, (HttpEntity)body, HttpExportBulkResponseListener.INSTANCE, new Header[0]);
            this.payload = null;
            listener.onResponse(null);
        }
    }

    @Override
    protected void doClose(ActionListener<Void> listener) {
        assert (this.payload == null);
        listener.onResponse(null);
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] toBulkBytes(MonitoringDoc doc) throws IOException {
        XContentType xContentType = XContentType.JSON;
        XContent xContent = xContentType.xContent();
        try (BytesStreamOutput out = new BytesStreamOutput();){
            MonitoringIndexNameResolver resolver = this.registry.getResolver(doc);
            if (resolver != null) {
                String index = resolver.index(doc);
                String type = resolver.type(doc);
                String id = resolver.id(doc);
                try (XContentBuilder builder = new XContentBuilder(xContent, out);){
                    builder.startObject();
                    builder.startObject("index");
                    builder.field("_index", index);
                    builder.field("_type", type);
                    if (id != null) {
                        builder.field("_id", id);
                    }
                    builder.endObject();
                    builder.endObject();
                }
                out.write(xContent.streamSeparator());
                BytesRef bytesRef = resolver.source(doc, xContentType).toBytesRef();
                out.write(bytesRef.bytes, bytesRef.offset, bytesRef.length);
                out.write(xContent.streamSeparator());
                logger.trace("added index request [index={}, type={}, id={}]", (Object)index, (Object)type, (Object)id);
            } else {
                logger.error("no resolver found for monitoring document [class={}, id={}, version={}]", (Object)doc.getClass().getName(), (Object)doc.getMonitoringId(), (Object)doc.getMonitoringVersion());
            }
            byte[] byArray = BytesReference.toBytes(out.bytes());
            return byArray;
        }
        catch (Exception e) {
            logger.warn(() -> new ParameterizedMessage("failed to render document [{}], skipping it [{}]", (Object)doc, (Object)this.name), (Throwable)e);
            return BytesRef.EMPTY_BYTES;
        }
    }
}

