/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.http;

import java.util.ArrayList;
import java.util.List;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.xpack.ssl.SSLConfigurationSettings;

public class HttpSettings {
    private static final TimeValue DEFAULT_READ_TIMEOUT;
    private static final TimeValue DEFAULT_CONNECTION_TIMEOUT;
    static final Setting<TimeValue> READ_TIMEOUT;
    static final Setting<TimeValue> CONNECTION_TIMEOUT;
    static final String PROXY_HOST_KEY = "xpack.http.proxy.host";
    static final String PROXY_PORT_KEY = "xpack.http.proxy.port";
    static final String SSL_KEY_PREFIX = "xpack.http.ssl.";
    static final Setting<String> PROXY_HOST;
    static final Setting<Integer> PROXY_PORT;
    private static final SSLConfigurationSettings SSL;

    public static List<? extends Setting<?>> getSettings() {
        ArrayList settings = new ArrayList();
        settings.addAll(SSL.getAllSettings());
        settings.add(READ_TIMEOUT);
        settings.add(CONNECTION_TIMEOUT);
        settings.add(PROXY_HOST);
        settings.add(PROXY_PORT);
        return settings;
    }

    private HttpSettings() {
    }

    static {
        DEFAULT_CONNECTION_TIMEOUT = DEFAULT_READ_TIMEOUT = TimeValue.timeValueSeconds(10L);
        READ_TIMEOUT = Setting.timeSetting("xpack.http.default_read_timeout", DEFAULT_READ_TIMEOUT, Setting.Property.NodeScope);
        CONNECTION_TIMEOUT = Setting.timeSetting("xpack.http.default_connection_timeout", DEFAULT_CONNECTION_TIMEOUT, Setting.Property.NodeScope);
        PROXY_HOST = Setting.simpleString(PROXY_HOST_KEY, Setting.Property.NodeScope);
        PROXY_PORT = Setting.intSetting(PROXY_PORT_KEY, 0, 0, 65535, Setting.Property.NodeScope);
        SSL = SSLConfigurationSettings.withPrefix(SSL_KEY_PREFIX);
    }
}

