/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.xpack.common.http;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.elasticsearch.ElasticsearchParseException;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.bytes.BytesArray;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.MapBuilder;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.ToXContentObject;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.XContentParser;
import org.elasticsearch.common.xcontent.XContentType;

public class HttpResponse
implements ToXContentObject {
    private final int status;
    private final Map<String, String[]> headers;
    private final BytesReference body;

    public HttpResponse(int status) {
        this(status, Collections.emptyMap());
    }

    public HttpResponse(int status, Map<String, String[]> headers) {
        this(status, (BytesReference)null, headers);
    }

    public HttpResponse(int status, @Nullable String body) {
        this(status, body != null ? new BytesArray(body) : null, Collections.emptyMap());
    }

    public HttpResponse(int status, @Nullable String body, Map<String, String[]> headers) {
        this(status, body != null ? new BytesArray(body) : null, headers);
    }

    public HttpResponse(int status, @Nullable byte[] body) {
        this(status, body != null && body.length > 0 ? new BytesArray(body) : null, Collections.emptyMap());
    }

    public HttpResponse(int status, @Nullable byte[] body, Map<String, String[]> headers) {
        this(status, body != null && body.length > 0 ? new BytesArray(body) : null, headers);
    }

    public HttpResponse(int status, @Nullable BytesReference body, Map<String, String[]> headers) {
        this.status = status;
        this.body = body;
        MapBuilder<String, String[]> mapBuilder = MapBuilder.newMapBuilder();
        for (Map.Entry<String, String[]> entry : headers.entrySet()) {
            mapBuilder.put(entry.getKey().toLowerCase(Locale.ROOT), entry.getValue());
        }
        this.headers = mapBuilder.immutableMap();
    }

    public int status() {
        return this.status;
    }

    public boolean hasContent() {
        return this.body != null;
    }

    public BytesReference body() {
        return this.body;
    }

    public Map<String, List<String>> headers() {
        MapBuilder<String, List<Object>> builder = MapBuilder.newMapBuilder();
        for (Map.Entry<String, String[]> entry : this.headers.entrySet()) {
            builder.put(entry.getKey().toLowerCase(Locale.ROOT), Arrays.asList((Object[])entry.getValue()));
        }
        return builder.immutableMap();
    }

    public String[] header(String header) {
        return this.headers.get(header.toLowerCase(Locale.ROOT));
    }

    public String contentType() {
        String[] values = this.header("Content-Type");
        if (values == null || values.length == 0) {
            return null;
        }
        return values[0];
    }

    public XContentType xContentType() {
        String[] values = this.header("Content-Type");
        if (values == null || values.length == 0) {
            return null;
        }
        return XContentType.fromMediaTypeOrFormat(values[0]);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        HttpResponse that = (HttpResponse)o;
        if (this.status != that.status) {
            return false;
        }
        if (!this.headers.equals(that.headers)) {
            return false;
        }
        return !(this.body == null ? that.body != null : !this.body.equals(that.body));
    }

    public int hashCode() {
        int result = this.status;
        result = 31 * result + this.headers.hashCode();
        result = 31 * result + (this.body != null ? this.body.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("status=[").append(this.status).append("]");
        if (!this.headers.isEmpty()) {
            sb.append(", headers=[");
            boolean first = true;
            for (Map.Entry<String, String[]> header : this.headers.entrySet()) {
                if (!first) {
                    sb.append(", ");
                }
                sb.append("[").append(header.getKey()).append(": ").append(Arrays.toString(header.getValue())).append("]");
                first = false;
            }
            sb.append("]");
        }
        if (this.hasContent()) {
            sb.append(", body=[").append(this.body.utf8ToString()).append("]");
        }
        return sb.toString();
    }

    @Override
    public XContentBuilder toXContent(XContentBuilder builder, ToXContent.Params params) throws IOException {
        builder = builder.startObject().field(Field.STATUS.getPreferredName(), this.status);
        if (!this.headers.isEmpty()) {
            builder.startObject(Field.HEADERS.getPreferredName());
            for (Map.Entry<String, String[]> header : this.headers.entrySet()) {
                builder.array(header.getKey().replaceAll("\\.", "_"), header.getValue());
            }
            builder.endObject();
        }
        if (this.hasContent()) {
            builder = builder.field(Field.BODY.getPreferredName(), this.body.utf8ToString());
        }
        builder.endObject();
        return builder;
    }

    public static HttpResponse parse(XContentParser parser) throws IOException {
        XContentParser.Token token;
        assert (parser.currentToken() == XContentParser.Token.START_OBJECT);
        int status = -1;
        String body = null;
        HashMap<String, String[]> headers = new HashMap<String, String[]>();
        String currentFieldName = null;
        while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
            if (token == XContentParser.Token.FIELD_NAME) {
                currentFieldName = parser.currentName();
                continue;
            }
            if (currentFieldName == null) {
                throw new ElasticsearchParseException("could not parse http response. expected a field name but found [{}] instead", new Object[]{token});
            }
            if (token == XContentParser.Token.VALUE_NUMBER) {
                if (Field.STATUS.match(currentFieldName)) {
                    status = parser.intValue();
                    continue;
                }
                throw new ElasticsearchParseException("could not parse http response. unknown numeric field [{}]", currentFieldName);
            }
            if (token == XContentParser.Token.VALUE_STRING) {
                if (Field.BODY.match(currentFieldName)) {
                    body = parser.text();
                    continue;
                }
                throw new ElasticsearchParseException("could not parse http response. unknown string field [{}]", currentFieldName);
            }
            if (token == XContentParser.Token.START_OBJECT) {
                String headerName = null;
                while ((token = parser.nextToken()) != XContentParser.Token.END_OBJECT) {
                    if (token == XContentParser.Token.FIELD_NAME) {
                        headerName = parser.currentName();
                        continue;
                    }
                    if (headerName == null) {
                        throw new ElasticsearchParseException("could not parse http response. expected a header name but found [{}] instead", new Object[]{token});
                    }
                    if (token.isValue()) {
                        headers.put(headerName, new String[]{String.valueOf(parser.objectText())});
                        continue;
                    }
                    if (token != XContentParser.Token.START_ARRAY) continue;
                    ArrayList<String> values = new ArrayList<String>();
                    while ((token = parser.nextToken()) != XContentParser.Token.END_ARRAY) {
                        if (!token.isValue()) {
                            throw new ElasticsearchParseException("could not parse http response. expected a header value for header [{}] but found [{}] instead", new Object[]{headerName, token});
                        }
                        values.add(String.valueOf(parser.objectText()));
                    }
                    headers.put(headerName, values.toArray(new String[values.size()]));
                }
                continue;
            }
            throw new ElasticsearchParseException("could not parse http response. unexpected token [{}]", new Object[]{token});
        }
        if (status < 0) {
            throw new ElasticsearchParseException("could not parse http response. missing required numeric [{}] field holding the response's http status code", Field.STATUS.getPreferredName());
        }
        return new HttpResponse(status, body, Collections.unmodifiableMap(headers));
    }

    static interface Field {
        public static final ParseField STATUS = new ParseField("status", new String[0]);
        public static final ParseField HEADERS = new ParseField("headers", new String[0]);
        public static final ParseField BODY = new ParseField("body", new String[0]);
    }
}

