/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.transport.netty4;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.stream.Collectors;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefIterator;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.logging.ESLoggerFactory;
import org.elasticsearch.io.netty.buffer.ByteBuf;
import org.elasticsearch.io.netty.buffer.CompositeByteBuf;
import org.elasticsearch.io.netty.buffer.Unpooled;
import org.elasticsearch.io.netty.channel.Channel;
import org.elasticsearch.io.netty.channel.ChannelFuture;
import org.elasticsearch.io.netty.util.internal.logging.InternalLogger;
import org.elasticsearch.io.netty.util.internal.logging.InternalLoggerFactory;
import org.elasticsearch.transport.netty4.ByteBufBytesReference;
import org.elasticsearch.transport.netty4.Netty4InternalESLogger;

public class Netty4Utils {
    public static void setup() {
    }

    public static ByteBuf toByteBuf(BytesReference reference) {
        if (reference.length() == 0) {
            return Unpooled.EMPTY_BUFFER;
        }
        if (reference instanceof ByteBufBytesReference) {
            return ((ByteBufBytesReference)reference).toByteBuf();
        }
        BytesRefIterator iterator = reference.iterator();
        ArrayList<ByteBuf> buffers = new ArrayList<ByteBuf>(3);
        try {
            BytesRef slice;
            while ((slice = iterator.next()) != null) {
                buffers.add(Unpooled.wrappedBuffer(slice.bytes, slice.offset, slice.length));
            }
            CompositeByteBuf composite = Unpooled.compositeBuffer(buffers.size());
            composite.addComponents(true, buffers);
            return composite;
        }
        catch (IOException ex) {
            throw new AssertionError("no IO happens here", ex);
        }
    }

    public static BytesReference toBytesReference(ByteBuf buffer) {
        return Netty4Utils.toBytesReference(buffer, buffer.readableBytes());
    }

    static BytesReference toBytesReference(ByteBuf buffer, int size) {
        return new ByteBufBytesReference(buffer, size);
    }

    public static void closeChannels(Collection<Channel> channels) throws IOException {
        Throwable closingExceptions = null;
        ArrayList<ChannelFuture> futures = new ArrayList<ChannelFuture>();
        for (Channel channel : channels) {
            try {
                if (channel == null || !channel.isOpen()) continue;
                futures.add(channel.close());
            }
            catch (Exception e) {
                if (closingExceptions == null) {
                    closingExceptions = new IOException("failed to close channels");
                }
                closingExceptions.addSuppressed(e);
            }
        }
        for (ChannelFuture future : futures) {
            future.awaitUninterruptibly();
        }
        if (closingExceptions != null) {
            throw closingExceptions;
        }
    }

    public static void maybeDie(Throwable cause) {
        if (cause instanceof Error) {
            try {
                StackTraceElement[] stackTrace = Thread.currentThread().getStackTrace();
                String formatted = Arrays.stream(stackTrace).skip(1L).map(e -> "\tat " + e).collect(Collectors.joining("\n"));
                ESLoggerFactory.getLogger(Netty4Utils.class).error("fatal error on the network layer\n{}", (Object)formatted);
            }
            finally {
                new Thread(() -> {
                    throw (Error)cause;
                }).start();
            }
        }
    }

    static {
        InternalLoggerFactory.setDefaultFactory(new InternalLoggerFactory(){

            @Override
            public InternalLogger newInstance(String name) {
                return new Netty4InternalESLogger(name);
            }
        });
    }
}

