/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.search.aggregations.support.values;

import java.lang.reflect.Array;
import java.util.Collection;
import java.util.Iterator;
import org.apache.lucene.search.Scorer;
import org.elasticsearch.common.lucene.ScorerAware;
import org.elasticsearch.index.fielddata.SortingNumericDocValues;
import org.elasticsearch.script.LeafSearchScript;
import org.elasticsearch.search.aggregations.AggregationExecutionException;

public class ScriptLongValues
extends SortingNumericDocValues
implements ScorerAware {
    final LeafSearchScript script;

    public ScriptLongValues(LeafSearchScript script) {
        this.script = script;
    }

    @Override
    public void setDocument(int docId) {
        this.script.setDocument(docId);
        Object value = this.script.run();
        if (value == null) {
            this.resize(0);
        } else if (value.getClass().isArray()) {
            this.resize(Array.getLength(value));
            for (int i = 0; i < this.count(); ++i) {
                this.values[i] = ScriptLongValues.toLongValue(Array.get(value, i));
            }
        } else if (value instanceof Collection) {
            this.resize(((Collection)value).size());
            int i = 0;
            Iterator it = ((Collection)value).iterator();
            while (it.hasNext()) {
                this.values[i] = ScriptLongValues.toLongValue(it.next());
                ++i;
            }
            assert (i == this.count());
        } else {
            this.resize(1);
            this.values[0] = ScriptLongValues.toLongValue(value);
        }
        this.sort();
    }

    private static long toLongValue(Object o) {
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof Boolean) {
            return (Boolean)o != false ? 1L : 0L;
        }
        throw new AggregationExecutionException("Unsupported script value [" + o + "], expected a number");
    }

    @Override
    public void setScorer(Scorer scorer) {
        this.script.setScorer(scorer);
    }
}

