/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.log4j.core.config.yaml;

import java.io.IOException;
import org.elasticsearch.jackson.core.JsonFactory;
import org.elasticsearch.jackson.core.JsonParser;
import org.elasticsearch.jackson.databind.ObjectMapper;
import org.elasticsearch.jackson.dataformat.yaml.YAMLFactory;
import org.elasticsearch.log4j.core.LoggerContext;
import org.elasticsearch.log4j.core.config.Configuration;
import org.elasticsearch.log4j.core.config.ConfigurationSource;
import org.elasticsearch.log4j.core.config.json.JsonConfiguration;

public class YamlConfiguration
extends JsonConfiguration {
    public YamlConfiguration(LoggerContext loggerContext, ConfigurationSource configSource) {
        super(loggerContext, configSource);
    }

    @Override
    protected ObjectMapper getObjectMapper() {
        return new ObjectMapper((JsonFactory)new YAMLFactory()).configure(JsonParser.Feature.ALLOW_COMMENTS, true);
    }

    @Override
    public Configuration reconfigure() {
        try {
            ConfigurationSource source = this.getConfigurationSource().resetInputStream();
            if (source == null) {
                return null;
            }
            return new YamlConfiguration(this.getLoggerContext(), source);
        }
        catch (IOException ex) {
            LOGGER.error("Cannot locate file {}", (Object)this.getConfigurationSource(), (Object)ex);
            return null;
        }
    }
}

