/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.license;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.function.Supplier;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.ActionResponse;
import org.elasticsearch.cluster.NamedDiff;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.common.ParseField;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.IndexScopedSettings;
import org.elasticsearch.common.settings.Setting;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.settings.SettingsFilter;
import org.elasticsearch.common.xcontent.NamedXContentRegistry;
import org.elasticsearch.license.DeleteLicenseAction;
import org.elasticsearch.license.DeleteLicenseRequest;
import org.elasticsearch.license.DeleteLicenseResponse;
import org.elasticsearch.license.GetLicenseAction;
import org.elasticsearch.license.GetLicenseRequest;
import org.elasticsearch.license.GetLicenseResponse;
import org.elasticsearch.license.LicensesMetaData;
import org.elasticsearch.license.PutLicenseAction;
import org.elasticsearch.license.PutLicenseRequest;
import org.elasticsearch.license.PutLicenseResponse;
import org.elasticsearch.license.RestDeleteLicenseAction;
import org.elasticsearch.license.RestGetLicenseAction;
import org.elasticsearch.license.RestPutLicenseAction;
import org.elasticsearch.license.TransportDeleteLicenseAction;
import org.elasticsearch.license.TransportGetLicenseAction;
import org.elasticsearch.license.TransportPutLicenseAction;
import org.elasticsearch.plugins.ActionPlugin;
import org.elasticsearch.rest.RestController;
import org.elasticsearch.rest.RestHandler;
import org.elasticsearch.xpack.XPackPlugin;

public class Licensing
implements ActionPlugin {
    public static final String NAME = "license";
    protected final Settings settings;
    protected final boolean isTransportClient;
    private final boolean isTribeNode;

    public List<NamedWriteableRegistry.Entry> getNamedWriteables() {
        ArrayList<NamedWriteableRegistry.Entry> entries = new ArrayList<NamedWriteableRegistry.Entry>();
        entries.add(new NamedWriteableRegistry.Entry(MetaData.Custom.class, "licenses", LicensesMetaData::new));
        entries.add(new NamedWriteableRegistry.Entry(NamedDiff.class, "licenses", LicensesMetaData::readDiffFrom));
        return entries;
    }

    public List<NamedXContentRegistry.Entry> getNamedXContent() {
        ArrayList<NamedXContentRegistry.Entry> entries = new ArrayList<NamedXContentRegistry.Entry>();
        entries.add(new NamedXContentRegistry.Entry(MetaData.Custom.class, new ParseField("licenses", new String[0]), LicensesMetaData::fromXContent));
        return entries;
    }

    public Licensing(Settings settings) {
        this.settings = settings;
        this.isTransportClient = XPackPlugin.transportClientMode(settings);
        this.isTribeNode = XPackPlugin.isTribeNode(settings);
    }

    @Override
    public List<ActionPlugin.ActionHandler<? extends ActionRequest, ? extends ActionResponse>> getActions() {
        if (this.isTribeNode) {
            return Collections.singletonList(new ActionPlugin.ActionHandler<GetLicenseRequest, GetLicenseResponse>(GetLicenseAction.INSTANCE, TransportGetLicenseAction.class, new Class[0]));
        }
        return Arrays.asList(new ActionPlugin.ActionHandler<PutLicenseRequest, PutLicenseResponse>(PutLicenseAction.INSTANCE, TransportPutLicenseAction.class, new Class[0]), new ActionPlugin.ActionHandler<GetLicenseRequest, GetLicenseResponse>(GetLicenseAction.INSTANCE, TransportGetLicenseAction.class, new Class[0]), new ActionPlugin.ActionHandler<DeleteLicenseRequest, DeleteLicenseResponse>(DeleteLicenseAction.INSTANCE, TransportDeleteLicenseAction.class, new Class[0]));
    }

    @Override
    public List<RestHandler> getRestHandlers(Settings settings, RestController restController, ClusterSettings clusterSettings, IndexScopedSettings indexScopedSettings, SettingsFilter settingsFilter, IndexNameExpressionResolver indexNameExpressionResolver, Supplier<DiscoveryNodes> nodesInCluster) {
        ArrayList<RestHandler> handlers = new ArrayList<RestHandler>();
        handlers.add(new RestGetLicenseAction(settings, restController));
        if (!this.isTribeNode) {
            handlers.add(new RestPutLicenseAction(settings, restController));
            handlers.add(new RestDeleteLicenseAction(settings, restController));
        }
        return handlers;
    }

    public List<Setting<?>> getSettings() {
        return Collections.singletonList(Setting.groupSetting("license.", Setting.Property.NodeScope));
    }
}

