/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jboss.netty.handler.ssl;

import java.io.File;
import java.util.List;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLException;
import javax.net.ssl.TrustManagerFactory;
import org.elasticsearch.jboss.netty.handler.ssl.JdkSslClientContext;
import org.elasticsearch.jboss.netty.handler.ssl.JdkSslServerContext;
import org.elasticsearch.jboss.netty.handler.ssl.OpenSsl;
import org.elasticsearch.jboss.netty.handler.ssl.OpenSslServerContext;
import org.elasticsearch.jboss.netty.handler.ssl.SslBufferPool;
import org.elasticsearch.jboss.netty.handler.ssl.SslHandler;
import org.elasticsearch.jboss.netty.handler.ssl.SslProvider;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class SslContext {
    private final SslBufferPool bufferPool;

    public static SslProvider defaultServerProvider() {
        if (OpenSsl.isAvailable()) {
            return SslProvider.OPENSSL;
        }
        return SslProvider.JDK;
    }

    public static SslProvider defaultClientProvider() {
        return SslProvider.JDK;
    }

    public static SslContext newServerContext(File certChainFile, File keyFile) throws SSLException {
        return SslContext.newServerContext(null, null, certChainFile, keyFile, null, null, null, 0L, 0L);
    }

    public static SslContext newServerContext(File certChainFile, File keyFile, String keyPassword) throws SSLException {
        return SslContext.newServerContext(null, null, certChainFile, keyFile, keyPassword, null, null, 0L, 0L);
    }

    public static SslContext newServerContext(SslBufferPool bufPool, File certChainFile, File keyFile, String keyPassword, Iterable<String> ciphers, Iterable<String> nextProtocols, long sessionCacheSize, long sessionTimeout) throws SSLException {
        return SslContext.newServerContext(null, bufPool, certChainFile, keyFile, keyPassword, ciphers, nextProtocols, sessionCacheSize, sessionTimeout);
    }

    public static SslContext newServerContext(SslProvider provider, File certChainFile, File keyFile) throws SSLException {
        return SslContext.newServerContext(provider, null, certChainFile, keyFile, null, null, null, 0L, 0L);
    }

    public static SslContext newServerContext(SslProvider provider, File certChainFile, File keyFile, String keyPassword) throws SSLException {
        return SslContext.newServerContext(provider, null, certChainFile, keyFile, keyPassword, null, null, 0L, 0L);
    }

    public static SslContext newServerContext(SslProvider provider, SslBufferPool bufPool, File certChainFile, File keyFile, String keyPassword, Iterable<String> ciphers, Iterable<String> nextProtocols, long sessionCacheSize, long sessionTimeout) throws SSLException {
        if (provider == null) {
            provider = OpenSsl.isAvailable() ? SslProvider.OPENSSL : SslProvider.JDK;
        }
        switch (provider) {
            case JDK: {
                return new JdkSslServerContext(bufPool, certChainFile, keyFile, keyPassword, ciphers, nextProtocols, sessionCacheSize, sessionTimeout);
            }
            case OPENSSL: {
                return new OpenSslServerContext(bufPool, certChainFile, keyFile, keyPassword, ciphers, nextProtocols, sessionCacheSize, sessionTimeout);
            }
        }
        throw new Error(provider.toString());
    }

    public static SslContext newClientContext() throws SSLException {
        return SslContext.newClientContext(null, null, null, null, null, null, 0L, 0L);
    }

    public static SslContext newClientContext(File certChainFile) throws SSLException {
        return SslContext.newClientContext(null, null, certChainFile, null, null, null, 0L, 0L);
    }

    public static SslContext newClientContext(TrustManagerFactory trustManagerFactory) throws SSLException {
        return SslContext.newClientContext(null, null, null, trustManagerFactory, null, null, 0L, 0L);
    }

    public static SslContext newClientContext(File certChainFile, TrustManagerFactory trustManagerFactory) throws SSLException {
        return SslContext.newClientContext(null, null, certChainFile, trustManagerFactory, null, null, 0L, 0L);
    }

    public static SslContext newClientContext(SslBufferPool bufPool, File certChainFile, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, Iterable<String> nextProtocols, long sessionCacheSize, long sessionTimeout) throws SSLException {
        return SslContext.newClientContext(null, bufPool, certChainFile, trustManagerFactory, ciphers, nextProtocols, sessionCacheSize, sessionTimeout);
    }

    public static SslContext newClientContext(SslProvider provider) throws SSLException {
        return SslContext.newClientContext(provider, null, null, null, null, null, 0L, 0L);
    }

    public static SslContext newClientContext(SslProvider provider, File certChainFile) throws SSLException {
        return SslContext.newClientContext(provider, null, certChainFile, null, null, null, 0L, 0L);
    }

    public static SslContext newClientContext(SslProvider provider, TrustManagerFactory trustManagerFactory) throws SSLException {
        return SslContext.newClientContext(provider, null, null, trustManagerFactory, null, null, 0L, 0L);
    }

    public static SslContext newClientContext(SslProvider provider, File certChainFile, TrustManagerFactory trustManagerFactory) throws SSLException {
        return SslContext.newClientContext(provider, null, certChainFile, trustManagerFactory, null, null, 0L, 0L);
    }

    public static SslContext newClientContext(SslProvider provider, SslBufferPool bufPool, File certChainFile, TrustManagerFactory trustManagerFactory, Iterable<String> ciphers, Iterable<String> nextProtocols, long sessionCacheSize, long sessionTimeout) throws SSLException {
        if (provider != null && provider != SslProvider.JDK) {
            throw new SSLException("client context unsupported for: " + (Object)((Object)provider));
        }
        return new JdkSslClientContext(bufPool, certChainFile, trustManagerFactory, ciphers, nextProtocols, sessionCacheSize, sessionTimeout);
    }

    SslContext(SslBufferPool bufferPool) {
        this.bufferPool = bufferPool == null ? this.newBufferPool() : bufferPool;
    }

    SslBufferPool newBufferPool() {
        return new SslBufferPool(false, false);
    }

    public final boolean isServer() {
        return !this.isClient();
    }

    public final SslBufferPool bufferPool() {
        return this.bufferPool;
    }

    public abstract boolean isClient();

    public abstract List<String> cipherSuites();

    public abstract long sessionCacheSize();

    public abstract long sessionTimeout();

    public abstract List<String> nextProtocols();

    public abstract SSLEngine newEngine();

    public abstract SSLEngine newEngine(String var1, int var2);

    public final SslHandler newHandler() {
        return this.newHandler(this.newEngine());
    }

    public final SslHandler newHandler(String peerHost, int peerPort) {
        return this.newHandler(this.newEngine(peerHost, peerPort));
    }

    private SslHandler newHandler(SSLEngine engine) {
        SslHandler handler = new SslHandler(engine, this.bufferPool());
        if (this.isClient()) {
            handler.setIssueHandshake(true);
        }
        handler.setCloseOnSSLException(true);
        return handler;
    }
}

