/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.jboss.netty.handler.codec.http;

import java.util.Map;
import org.elasticsearch.jboss.netty.buffer.ChannelBuffer;
import org.elasticsearch.jboss.netty.buffer.ChannelBuffers;
import org.elasticsearch.jboss.netty.handler.codec.http.DefaultHttpHeaders;
import org.elasticsearch.jboss.netty.handler.codec.http.HttpChunkTrailer;
import org.elasticsearch.jboss.netty.handler.codec.http.HttpHeaders;
import org.elasticsearch.jboss.netty.util.internal.StringUtil;

public class DefaultHttpChunkTrailer
implements HttpChunkTrailer {
    private final HttpHeaders trailingHeaders = new TrailingHeaders(true);

    public boolean isLast() {
        return true;
    }

    public ChannelBuffer getContent() {
        return ChannelBuffers.EMPTY_BUFFER;
    }

    public void setContent(ChannelBuffer content) {
        throw new IllegalStateException("read-only");
    }

    public HttpHeaders trailingHeaders() {
        return this.trailingHeaders;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder(super.toString());
        buf.append(StringUtil.NEWLINE);
        this.appendHeaders(buf);
        buf.setLength(buf.length() - StringUtil.NEWLINE.length());
        return buf.toString();
    }

    private void appendHeaders(StringBuilder buf) {
        for (Map.Entry e : this.trailingHeaders()) {
            buf.append((String)e.getKey());
            buf.append(": ");
            buf.append((String)e.getValue());
            buf.append(StringUtil.NEWLINE);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class TrailingHeaders
    extends DefaultHttpHeaders {
        TrailingHeaders(boolean validateHeaders) {
            super(validateHeaders);
        }

        @Override
        public HttpHeaders add(String name, Object value) {
            if (this.validate) {
                TrailingHeaders.validateName(name);
            }
            return super.add(name, value);
        }

        @Override
        public HttpHeaders add(String name, Iterable<?> values) {
            if (this.validate) {
                TrailingHeaders.validateName(name);
            }
            return super.add(name, values);
        }

        @Override
        public HttpHeaders set(String name, Iterable<?> values) {
            if (this.validate) {
                TrailingHeaders.validateName(name);
            }
            return super.set(name, values);
        }

        @Override
        public HttpHeaders set(String name, Object value) {
            if (this.validate) {
                TrailingHeaders.validateName(name);
            }
            return super.set(name, value);
        }

        private static void validateName(String name) {
            if (name.equalsIgnoreCase("Content-Length") || name.equalsIgnoreCase("Transfer-Encoding") || name.equalsIgnoreCase("Trailer")) {
                throw new IllegalArgumentException("prohibited trailing header: " + name);
            }
        }
    }
}

