/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.Closeable;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.function.Consumer;
import java.util.function.IntSupplier;
import org.apache.lucene.search.ReferenceManager;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.log4j.Logger;

public final class RefreshListeners
implements ReferenceManager.RefreshListener,
Closeable {
    private final IntSupplier getMaxRefreshListeners;
    private final Runnable forceRefresh;
    private final Executor listenerExecutor;
    private final Logger logger;
    private volatile boolean closed = false;
    private volatile List<Tuple<Translog.Location, Consumer<Boolean>>> refreshListeners = null;
    private volatile Translog.Location lastRefreshedLocation;
    private Translog translog;
    private Translog.Location currentRefreshLocation;

    public RefreshListeners(IntSupplier getMaxRefreshListeners, Runnable forceRefresh, Executor listenerExecutor, Logger logger) {
        this.getMaxRefreshListeners = getMaxRefreshListeners;
        this.forceRefresh = forceRefresh;
        this.listenerExecutor = listenerExecutor;
        this.logger = logger;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean addOrNotify(Translog.Location location, Consumer<Boolean> listener) {
        Objects.requireNonNull(listener, "listener cannot be null");
        Objects.requireNonNull(location, "location cannot be null");
        if (this.lastRefreshedLocation != null && this.lastRefreshedLocation.compareTo(location) >= 0) {
            listener.accept(false);
            return true;
        }
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            List<Tuple<Translog.Location, Consumer<Boolean>>> listeners = this.refreshListeners;
            if (listeners == null) {
                if (this.closed) {
                    throw new IllegalStateException("can't wait for refresh on a closed index");
                }
                this.refreshListeners = listeners = new ArrayList<Tuple<Translog.Location, Consumer<Boolean>>>();
            }
            if (listeners.size() < this.getMaxRefreshListeners.getAsInt()) {
                listeners.add(new Tuple<Translog.Location, Consumer<Boolean>>(location, listener));
                return false;
            }
        }
        this.forceRefresh.run();
        listener.accept(true);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        List<Tuple<Translog.Location, Consumer<Boolean>>> oldListeners;
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            oldListeners = this.refreshListeners;
            this.refreshListeners = null;
            this.closed = true;
        }
        this.fireListeners(oldListeners);
    }

    public boolean refreshNeeded() {
        return this.refreshListeners != null && false == this.closed;
    }

    public int pendingCount() {
        List<Tuple<Translog.Location, Consumer<Boolean>>> listeners = this.refreshListeners;
        return listeners == null ? 0 : listeners.size();
    }

    public void setTranslog(Translog translog) {
        this.translog = translog;
    }

    @Override
    public void beforeRefresh() throws IOException {
        this.currentRefreshLocation = this.translog.getLastWriteLocation();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void afterRefresh(boolean didRefresh) throws IOException {
        List<Tuple<Translog.Location, Consumer<Boolean>>> candidates;
        if (null == this.currentRefreshLocation) {
            return;
        }
        this.lastRefreshedLocation = this.currentRefreshLocation;
        RefreshListeners refreshListeners = this;
        synchronized (refreshListeners) {
            candidates = this.refreshListeners;
            if (candidates == null) {
                return;
            }
            this.refreshListeners = null;
        }
        ArrayList<Tuple<Translog.Location, Consumer<Boolean>>> listenersToFire = null;
        ArrayList<Tuple<Translog.Location, Consumer<Boolean>>> preservedListeners = null;
        for (Tuple<Translog.Location, Consumer<Boolean>> tuple : candidates) {
            Translog.Location location = tuple.v1();
            if (location.compareTo(this.currentRefreshLocation) <= 0) {
                if (listenersToFire == null) {
                    listenersToFire = new ArrayList<Tuple<Translog.Location, Consumer<Boolean>>>();
                }
                listenersToFire.add(tuple);
                continue;
            }
            if (preservedListeners == null) {
                preservedListeners = new ArrayList<Tuple<Translog.Location, Consumer<Boolean>>>();
            }
            preservedListeners.add(tuple);
        }
        if (preservedListeners != null) {
            RefreshListeners refreshListeners2 = this;
            synchronized (refreshListeners2) {
                if (this.refreshListeners == null) {
                    if (this.closed) {
                        listenersToFire.addAll(preservedListeners);
                    } else {
                        this.refreshListeners = preservedListeners;
                    }
                } else {
                    assert (!this.closed) : "Can't be closed and have non-null refreshListeners";
                    this.refreshListeners.addAll(preservedListeners);
                }
            }
        }
        this.fireListeners(listenersToFire);
    }

    private void fireListeners(List<Tuple<Translog.Location, Consumer<Boolean>>> listenersToFire) {
        if (listenersToFire != null) {
            this.listenerExecutor.execute(() -> {
                for (Tuple listener : listenersToFire) {
                    try {
                        ((Consumer)listener.v2()).accept(false);
                    }
                    catch (Exception e) {
                        this.logger.warn("Error firing refresh listener", (Throwable)e);
                    }
                }
            });
        }
    }
}

