/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.shard;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import org.apache.lucene.index.IndexWriter;
import org.apache.lucene.index.MergePolicy;
import org.apache.lucene.index.MergeTrigger;
import org.apache.lucene.index.SegmentCommitInfo;
import org.apache.lucene.index.SegmentInfos;
import org.elasticsearch.Version;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.log4j.Logger;

public final class ElasticsearchMergePolicy
extends MergePolicy {
    private static Logger logger = Loggers.getLogger(ElasticsearchMergePolicy.class);
    private final MergePolicy delegate;
    private volatile boolean upgradeInProgress;
    private volatile boolean upgradeOnlyAncientSegments;
    private static final int MAX_CONCURRENT_UPGRADE_MERGES = 5;

    public ElasticsearchMergePolicy(MergePolicy delegate) {
        this.delegate = delegate;
    }

    @Override
    public MergePolicy.MergeSpecification findMerges(MergeTrigger mergeTrigger, SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return this.delegate.findMerges(mergeTrigger, segmentInfos, writer);
    }

    private boolean shouldUpgrade(SegmentCommitInfo info) {
        org.apache.lucene.util.Version old = info.info.getVersion();
        org.apache.lucene.util.Version cur = Version.CURRENT.luceneVersion;
        assert (old.major <= cur.major);
        if (cur.major > old.major) {
            return true;
        }
        return !this.upgradeOnlyAncientSegments && cur.minor > old.minor;
    }

    @Override
    public MergePolicy.MergeSpecification findForcedMerges(SegmentInfos segmentInfos, int maxSegmentCount, Map<SegmentCommitInfo, Boolean> segmentsToMerge, IndexWriter writer) throws IOException {
        if (this.upgradeInProgress) {
            MergePolicy.MergeSpecification spec = new MergePolicy.MergeSpecification();
            for (SegmentCommitInfo info : segmentInfos) {
                if (this.shouldUpgrade(info)) {
                    logger.debug("Adding segment {} to be upgraded", (Object)info.info.name);
                    spec.add(new MergePolicy.OneMerge(Collections.singletonList(info)));
                }
                if (spec.merges.size() != 5) continue;
                logger.debug("Returning {} merges for upgrade", (Object)spec.merges.size());
                return spec;
            }
            if (!spec.merges.isEmpty()) {
                logger.debug("Returning {} merges for end of upgrade", (Object)spec.merges.size());
                return spec;
            }
            this.upgradeInProgress = false;
        }
        return this.delegate.findForcedMerges(segmentInfos, maxSegmentCount, segmentsToMerge, writer);
    }

    @Override
    public MergePolicy.MergeSpecification findForcedDeletesMerges(SegmentInfos segmentInfos, IndexWriter writer) throws IOException {
        return this.delegate.findForcedDeletesMerges(segmentInfos, writer);
    }

    @Override
    public boolean useCompoundFile(SegmentInfos segments, SegmentCommitInfo newSegment, IndexWriter writer) throws IOException {
        return this.delegate.useCompoundFile(segments, newSegment, writer);
    }

    public void setUpgradeInProgress(boolean upgrade, boolean onlyAncientSegments) {
        this.upgradeInProgress = upgrade;
        this.upgradeOnlyAncientSegments = onlyAncientSegments;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "(" + this.delegate + ")";
    }
}

