/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.mapper;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.lucene.document.Field;
import org.apache.lucene.document.FieldType;
import org.apache.lucene.index.IndexOptions;
import org.apache.lucene.index.IndexableField;
import org.apache.lucene.search.Query;
import org.elasticsearch.Version;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.ToXContent;
import org.elasticsearch.common.xcontent.XContentBuilder;
import org.elasticsearch.common.xcontent.support.XContentMapValues;
import org.elasticsearch.index.analysis.NamedAnalyzer;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.plain.PagedBytesIndexFieldData;
import org.elasticsearch.index.mapper.DocumentMapperParser;
import org.elasticsearch.index.mapper.FieldMapper;
import org.elasticsearch.index.mapper.MappedFieldType;
import org.elasticsearch.index.mapper.Mapper;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.ParseContext;
import org.elasticsearch.index.mapper.StringFieldMapper;
import org.elasticsearch.index.mapper.StringFieldType;
import org.elasticsearch.index.mapper.TypeParsers;

public class TextFieldMapper
extends FieldMapper {
    public static final String CONTENT_TYPE = "text";
    private static final int POSITION_INCREMENT_GAP_USE_ANALYZER = -1;
    private static final List<String> SUPPORTED_PARAMETERS_FOR_AUTO_DOWNGRADE_TO_STRING = Collections.unmodifiableList(Arrays.asList("type", "index", "store", "doc_values", "omit_norms", "norms", "boost", "fields", "copy_to", "fielddata", "eager_global_ordinals", "fielddata_frequency_filter", "include_in_all", "analyzer", "search_analyzer", "search_quote_analyzer", "index_options", "position_increment_gap", "similarity"));
    private Boolean includeInAll;
    private int positionIncrementGap;

    protected TextFieldMapper(String simpleName, MappedFieldType fieldType, MappedFieldType defaultFieldType, int positionIncrementGap, Boolean includeInAll, Settings indexSettings, FieldMapper.MultiFields multiFields, FieldMapper.CopyTo copyTo) {
        super(simpleName, fieldType, defaultFieldType, indexSettings, multiFields, copyTo);
        assert (fieldType.tokenized());
        assert (!fieldType.hasDocValues());
        if (this.fieldType().indexOptions() == IndexOptions.NONE && this.fieldType().fielddata()) {
            throw new IllegalArgumentException("Cannot enable fielddata on a [text] field that is not indexed: [" + this.name() + "]");
        }
        this.positionIncrementGap = positionIncrementGap;
        this.includeInAll = includeInAll;
    }

    @Override
    protected TextFieldMapper clone() {
        return (TextFieldMapper)super.clone();
    }

    Boolean includeInAll() {
        return this.includeInAll;
    }

    public int getPositionIncrementGap() {
        return this.positionIncrementGap;
    }

    @Override
    protected void parseCreateField(ParseContext context, List<IndexableField> fields) throws IOException {
        String value = context.externalValueSet() ? context.externalValue().toString() : context.parser().textOrNull();
        if (value == null) {
            return;
        }
        if (context.includeInAll(this.includeInAll, this)) {
            context.allEntries().addText(this.fieldType().name(), value, this.fieldType().boost());
        }
        if (this.fieldType().indexOptions() != IndexOptions.NONE || this.fieldType().stored()) {
            Field field = new Field(this.fieldType().name(), value, (FieldType)this.fieldType());
            fields.add(field);
        }
    }

    @Override
    protected String contentType() {
        return CONTENT_TYPE;
    }

    @Override
    protected void doMerge(Mapper mergeWith, boolean updateAllTypes) {
        super.doMerge(mergeWith, updateAllTypes);
        this.includeInAll = ((TextFieldMapper)mergeWith).includeInAll;
    }

    @Override
    public TextFieldType fieldType() {
        return (TextFieldType)super.fieldType();
    }

    @Override
    protected void doXContentBody(XContentBuilder builder, boolean includeDefaults, ToXContent.Params params) throws IOException {
        super.doXContentBody(builder, includeDefaults, params);
        this.doXContentAnalyzers(builder, includeDefaults);
        if (this.includeInAll != null) {
            builder.field("include_in_all", this.includeInAll);
        } else if (includeDefaults) {
            builder.field("include_in_all", true);
        }
        if (includeDefaults || this.positionIncrementGap != -1) {
            builder.field("position_increment_gap", this.positionIncrementGap);
        }
        if (includeDefaults || this.fieldType().fielddata() != ((TextFieldType)this.defaultFieldType).fielddata()) {
            builder.field("fielddata", this.fieldType().fielddata());
        }
        if (this.fieldType().fielddata() && (includeDefaults || this.fieldType().fielddataMinFrequency() != Defaults.FIELDDATA_MIN_FREQUENCY || this.fieldType().fielddataMaxFrequency() != Defaults.FIELDDATA_MAX_FREQUENCY || this.fieldType().fielddataMinSegmentSize() != Defaults.FIELDDATA_MIN_SEGMENT_SIZE)) {
            builder.startObject("fielddata_frequency_filter");
            if (includeDefaults || this.fieldType().fielddataMinFrequency() != Defaults.FIELDDATA_MIN_FREQUENCY) {
                builder.field("min", this.fieldType().fielddataMinFrequency());
            }
            if (includeDefaults || this.fieldType().fielddataMaxFrequency() != Defaults.FIELDDATA_MAX_FREQUENCY) {
                builder.field("max", this.fieldType().fielddataMaxFrequency());
            }
            if (includeDefaults || this.fieldType().fielddataMinSegmentSize() != Defaults.FIELDDATA_MIN_SEGMENT_SIZE) {
                builder.field("min_segment_size", this.fieldType().fielddataMinSegmentSize());
            }
            builder.endObject();
        }
    }

    public static final class TextFieldType
    extends StringFieldType {
        private boolean fielddata;
        private double fielddataMinFrequency;
        private double fielddataMaxFrequency;
        private int fielddataMinSegmentSize;

        public TextFieldType() {
            this.setTokenized(true);
            this.fielddata = false;
            this.fielddataMinFrequency = Defaults.FIELDDATA_MIN_FREQUENCY;
            this.fielddataMaxFrequency = Defaults.FIELDDATA_MAX_FREQUENCY;
            this.fielddataMinSegmentSize = Defaults.FIELDDATA_MIN_SEGMENT_SIZE;
        }

        protected TextFieldType(TextFieldType ref) {
            super(ref);
            this.fielddata = ref.fielddata;
            this.fielddataMinFrequency = ref.fielddataMinFrequency;
            this.fielddataMaxFrequency = ref.fielddataMaxFrequency;
            this.fielddataMinSegmentSize = ref.fielddataMinSegmentSize;
        }

        @Override
        public TextFieldType clone() {
            return new TextFieldType(this);
        }

        @Override
        public boolean equals(Object o) {
            if (!super.equals(o)) {
                return false;
            }
            TextFieldType that = (TextFieldType)o;
            return this.fielddata == that.fielddata && this.fielddataMinFrequency == that.fielddataMinFrequency && this.fielddataMaxFrequency == that.fielddataMaxFrequency && this.fielddataMinSegmentSize == that.fielddataMinSegmentSize;
        }

        @Override
        public int hashCode() {
            return Objects.hash(super.hashCode(), this.fielddata, this.fielddataMinFrequency, this.fielddataMaxFrequency, this.fielddataMinSegmentSize);
        }

        @Override
        public void checkCompatibility(MappedFieldType other, List<String> conflicts, boolean strict) {
            super.checkCompatibility(other, conflicts, strict);
            TextFieldType otherType = (TextFieldType)other;
            if (strict) {
                if (this.fielddata() != otherType.fielddata()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata] across all types.");
                }
                if (this.fielddataMinFrequency() != otherType.fielddataMinFrequency()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata_frequency_filter.min] across all types.");
                }
                if (this.fielddataMaxFrequency() != otherType.fielddataMaxFrequency()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata_frequency_filter.max] across all types.");
                }
                if (this.fielddataMinSegmentSize() != otherType.fielddataMinSegmentSize()) {
                    conflicts.add("mapper [" + this.name() + "] is used by multiple types. Set update_all_types to true to update [fielddata_frequency_filter.min_segment_size] across all types.");
                }
            }
        }

        public boolean fielddata() {
            return this.fielddata;
        }

        public void setFielddata(boolean fielddata) {
            this.checkIfFrozen();
            this.fielddata = fielddata;
        }

        public double fielddataMinFrequency() {
            return this.fielddataMinFrequency;
        }

        public void setFielddataMinFrequency(double fielddataMinFrequency) {
            this.checkIfFrozen();
            this.fielddataMinFrequency = fielddataMinFrequency;
        }

        public double fielddataMaxFrequency() {
            return this.fielddataMaxFrequency;
        }

        public void setFielddataMaxFrequency(double fielddataMaxFrequency) {
            this.checkIfFrozen();
            this.fielddataMaxFrequency = fielddataMaxFrequency;
        }

        public int fielddataMinSegmentSize() {
            return this.fielddataMinSegmentSize;
        }

        public void setFielddataMinSegmentSize(int fielddataMinSegmentSize) {
            this.checkIfFrozen();
            this.fielddataMinSegmentSize = fielddataMinSegmentSize;
        }

        @Override
        public String typeName() {
            return TextFieldMapper.CONTENT_TYPE;
        }

        @Override
        public Query nullValueQuery() {
            if (this.nullValue() == null) {
                return null;
            }
            return this.termQuery(this.nullValue(), null);
        }

        @Override
        public IndexFieldData.Builder fielddataBuilder() {
            if (!this.fielddata) {
                throw new IllegalArgumentException("Fielddata is disabled on text fields by default. Set fielddata=true on [" + this.name() + "] in order to load fielddata in memory by uninverting the inverted index. Note that this can however use significant memory.");
            }
            return new PagedBytesIndexFieldData.Builder(this.fielddataMinFrequency, this.fielddataMaxFrequency, this.fielddataMinSegmentSize);
        }
    }

    public static class TypeParser
    implements Mapper.TypeParser {
        public Mapper.Builder parse(String fieldName, Map<String, Object> node, Mapper.TypeParser.ParserContext parserContext) throws MapperParsingException {
            if (parserContext.indexVersionCreated().before(Version.V_5_0_0_alpha1)) {
                HashSet<String> unsupportedParameters = new HashSet<String>(node.keySet());
                unsupportedParameters.removeAll(SUPPORTED_PARAMETERS_FOR_AUTO_DOWNGRADE_TO_STRING);
                if (!SUPPORTED_PARAMETERS_FOR_AUTO_DOWNGRADE_TO_STRING.containsAll(node.keySet())) {
                    throw new IllegalArgumentException("Automatic downgrade from [text] to [string] failed because parameters " + unsupportedParameters + " are not supported for automatic downgrades.");
                }
                Object index = node.get("index");
                if (index == null || Boolean.TRUE.equals(index)) {
                    index = "analyzed";
                } else if (Boolean.FALSE.equals(index)) {
                    index = "no";
                } else {
                    throw new IllegalArgumentException("Can't parse [index] value [" + index + "] for field [" + fieldName + "], expected [true] or [false]");
                }
                node.put("index", index);
                Object fielddata = node.get("fielddata");
                if (fielddata == null || Boolean.FALSE.equals(fielddata)) {
                    fielddata = false;
                } else if (Boolean.TRUE.equals(fielddata)) {
                    fielddata = true;
                } else {
                    throw new IllegalArgumentException("can't parse [fielddata] value for [" + fielddata + "] for field [" + fieldName + "], expected [true] or [false]");
                }
                node.put("fielddata", fielddata);
                return new StringFieldMapper.TypeParser().parse(fieldName, node, parserContext);
            }
            Builder builder = new Builder(fieldName);
            builder.fieldType().setIndexAnalyzer(parserContext.getIndexAnalyzers().getDefaultIndexAnalyzer());
            builder.fieldType().setSearchAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchAnalyzer());
            builder.fieldType().setSearchQuoteAnalyzer(parserContext.getIndexAnalyzers().getDefaultSearchQuoteAnalyzer());
            TypeParsers.parseTextField(builder, fieldName, node, parserContext);
            Iterator<Map.Entry<String, Object>> iterator = node.entrySet().iterator();
            while (iterator.hasNext()) {
                Map.Entry<String, Object> entry = iterator.next();
                String propName = entry.getKey();
                Object propNode = entry.getValue();
                if (propName.equals("position_increment_gap")) {
                    int newPositionIncrementGap = XContentMapValues.nodeIntegerValue(propNode, -1);
                    builder.positionIncrementGap(newPositionIncrementGap);
                    iterator.remove();
                    continue;
                }
                if (propName.equals("fielddata")) {
                    builder.fielddata(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (propName.equals("eager_global_ordinals")) {
                    builder.eagerGlobalOrdinals(XContentMapValues.nodeBooleanValue(propNode));
                    iterator.remove();
                    continue;
                }
                if (!propName.equals("fielddata_frequency_filter")) continue;
                Map frequencyFilter = (Map)propNode;
                double minFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("min"), 0.0);
                double maxFrequency = XContentMapValues.nodeDoubleValue(frequencyFilter.remove("max"), 2.147483647E9);
                int minSegmentSize = XContentMapValues.nodeIntegerValue(frequencyFilter.remove("min_segment_size"), 0);
                builder.fielddataFrequencyFilter(minFrequency, maxFrequency, minSegmentSize);
                DocumentMapperParser.checkNoRemainingFields(propName, frequencyFilter, parserContext.indexVersionCreated());
                iterator.remove();
            }
            return builder;
        }
    }

    public static class Builder
    extends FieldMapper.Builder<Builder, TextFieldMapper> {
        private int positionIncrementGap = -1;

        public Builder(String name) {
            super(name, Defaults.FIELD_TYPE, Defaults.FIELD_TYPE);
            this.builder = this;
        }

        @Override
        public TextFieldType fieldType() {
            return (TextFieldType)super.fieldType();
        }

        public Builder positionIncrementGap(int positionIncrementGap) {
            if (positionIncrementGap < 0) {
                throw new MapperParsingException("[positions_increment_gap] must be positive, got " + positionIncrementGap);
            }
            this.positionIncrementGap = positionIncrementGap;
            return this;
        }

        public Builder fielddata(boolean fielddata) {
            this.fieldType().setFielddata(fielddata);
            return (Builder)this.builder;
        }

        @Override
        public Builder docValues(boolean docValues) {
            if (docValues) {
                throw new IllegalArgumentException("[text] fields do not support doc values");
            }
            return (Builder)super.docValues(docValues);
        }

        public Builder eagerGlobalOrdinals(boolean eagerGlobalOrdinals) {
            this.fieldType().setEagerGlobalOrdinals(eagerGlobalOrdinals);
            return (Builder)this.builder;
        }

        public Builder fielddataFrequencyFilter(double minFreq, double maxFreq, int minSegmentSize) {
            this.fieldType().setFielddataMinFrequency(minFreq);
            this.fieldType().setFielddataMaxFrequency(maxFreq);
            this.fieldType().setFielddataMinSegmentSize(minSegmentSize);
            return (Builder)this.builder;
        }

        @Override
        public TextFieldMapper build(Mapper.BuilderContext context) {
            if (this.positionIncrementGap != -1) {
                if (this.fieldType.indexOptions().compareTo(IndexOptions.DOCS_AND_FREQS_AND_POSITIONS) < 0) {
                    throw new IllegalArgumentException("Cannot set position_increment_gap on field [" + this.name + "] without positions enabled");
                }
                this.fieldType.setIndexAnalyzer(new NamedAnalyzer(this.fieldType.indexAnalyzer(), this.positionIncrementGap));
                this.fieldType.setSearchAnalyzer(new NamedAnalyzer(this.fieldType.searchAnalyzer(), this.positionIncrementGap));
                this.fieldType.setSearchQuoteAnalyzer(new NamedAnalyzer(this.fieldType.searchQuoteAnalyzer(), this.positionIncrementGap));
            }
            this.setupFieldType(context);
            return new TextFieldMapper(this.name, this.fieldType, this.defaultFieldType, this.positionIncrementGap, this.includeInAll, context.indexSettings(), this.multiFieldsBuilder.build(this, context), this.copyTo);
        }
    }

    public static class Defaults {
        public static double FIELDDATA_MIN_FREQUENCY = 0.0;
        public static double FIELDDATA_MAX_FREQUENCY = 2.147483647E9;
        public static int FIELDDATA_MIN_SEGMENT_SIZE = 0;
        public static final MappedFieldType FIELD_TYPE = new TextFieldType();
        public static final int POSITION_INCREMENT_GAP = 100;

        static {
            FIELD_TYPE.freeze();
        }
    }
}

