/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata.fieldcomparator;

import java.io.IOException;
import org.apache.lucene.index.BinaryDocValues;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.RandomAccessOrds;
import org.apache.lucene.index.SortedDocValues;
import org.apache.lucene.search.DocIdSetIterator;
import org.apache.lucene.search.FieldComparator;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.SortField;
import org.apache.lucene.util.BitSet;
import org.apache.lucene.util.Bits;
import org.apache.lucene.util.BytesRef;
import org.elasticsearch.index.fielddata.AtomicOrdinalsFieldData;
import org.elasticsearch.index.fielddata.IndexFieldData;
import org.elasticsearch.index.fielddata.IndexOrdinalsFieldData;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;
import org.elasticsearch.search.MultiValueMode;

public class BytesRefFieldComparatorSource
extends IndexFieldData.XFieldComparatorSource {
    private final IndexFieldData<?> indexFieldData;
    private final MultiValueMode sortMode;
    private final Object missingValue;
    private final IndexFieldData.XFieldComparatorSource.Nested nested;

    public BytesRefFieldComparatorSource(IndexFieldData<?> indexFieldData, Object missingValue, MultiValueMode sortMode, IndexFieldData.XFieldComparatorSource.Nested nested) {
        this.indexFieldData = indexFieldData;
        this.sortMode = sortMode;
        this.missingValue = missingValue;
        this.nested = nested;
    }

    @Override
    public SortField.Type reducedType() {
        return SortField.Type.STRING;
    }

    @Override
    public Object missingValue(boolean reversed) {
        if (this.sortMissingFirst(this.missingValue) || this.sortMissingLast(this.missingValue)) {
            if (this.sortMissingLast(this.missingValue) ^ reversed) {
                return SortField.STRING_LAST;
            }
            return SortField.STRING_FIRST;
        }
        return null;
    }

    protected SortedBinaryDocValues getValues(LeafReaderContext context) throws IOException {
        return this.indexFieldData.load(context).getBytesValues();
    }

    protected void setScorer(Scorer scorer) {
    }

    @Override
    public FieldComparator<?> newComparator(String fieldname, int numHits, int sortPos, boolean reversed) throws IOException {
        assert (this.indexFieldData == null || fieldname.equals(this.indexFieldData.getFieldName()));
        boolean sortMissingLast = this.sortMissingLast(this.missingValue) ^ reversed;
        final BytesRef missingBytes = (BytesRef)this.missingObject(this.missingValue, reversed);
        if (this.indexFieldData instanceof IndexOrdinalsFieldData) {
            return new FieldComparator.TermOrdValComparator(numHits, null, sortMissingLast){

                @Override
                protected SortedDocValues getSortedDocValues(LeafReaderContext context, String field) throws IOException {
                    SortedDocValues selectedValues;
                    RandomAccessOrds values = ((AtomicOrdinalsFieldData)((IndexOrdinalsFieldData)BytesRefFieldComparatorSource.this.indexFieldData).load(context)).getOrdinalsValues();
                    if (BytesRefFieldComparatorSource.this.nested == null) {
                        selectedValues = BytesRefFieldComparatorSource.this.sortMode.select(values);
                    } else {
                        BitSet rootDocs = BytesRefFieldComparatorSource.this.nested.rootDocs(context);
                        DocIdSetIterator innerDocs = BytesRefFieldComparatorSource.this.nested.innerDocs(context);
                        selectedValues = BytesRefFieldComparatorSource.this.sortMode.select(values, rootDocs, innerDocs);
                    }
                    if (BytesRefFieldComparatorSource.this.sortMissingFirst(BytesRefFieldComparatorSource.this.missingValue) || BytesRefFieldComparatorSource.this.sortMissingLast(BytesRefFieldComparatorSource.this.missingValue)) {
                        return selectedValues;
                    }
                    return new ReplaceMissing(selectedValues, missingBytes);
                }

                @Override
                public void setScorer(Scorer scorer) {
                    BytesRefFieldComparatorSource.this.setScorer(scorer);
                }
            };
        }
        final BytesRef nullPlaceHolder = new BytesRef();
        final BytesRef nonNullMissingBytes = missingBytes == null ? nullPlaceHolder : missingBytes;
        return new FieldComparator.TermValComparator(numHits, null, sortMissingLast){

            @Override
            protected BinaryDocValues getBinaryDocValues(LeafReaderContext context, String field) throws IOException {
                BinaryDocValues selectedValues;
                SortedBinaryDocValues values = BytesRefFieldComparatorSource.this.getValues(context);
                if (BytesRefFieldComparatorSource.this.nested == null) {
                    selectedValues = BytesRefFieldComparatorSource.this.sortMode.select(values, nonNullMissingBytes);
                } else {
                    BitSet rootDocs = BytesRefFieldComparatorSource.this.nested.rootDocs(context);
                    DocIdSetIterator innerDocs = BytesRefFieldComparatorSource.this.nested.innerDocs(context);
                    selectedValues = BytesRefFieldComparatorSource.this.sortMode.select(values, nonNullMissingBytes, rootDocs, innerDocs, context.reader().maxDoc());
                }
                return selectedValues;
            }

            @Override
            protected Bits getDocsWithField(LeafReaderContext context, String field) throws IOException {
                return new Bits.MatchAllBits(context.reader().maxDoc());
            }

            @Override
            protected boolean isNull(int doc, BytesRef term) {
                return term == nullPlaceHolder;
            }

            @Override
            public void setScorer(Scorer scorer) {
                BytesRefFieldComparatorSource.this.setScorer(scorer);
            }
        };
    }

    static class ReplaceMissing
    extends SortedDocValues {
        final SortedDocValues in;
        final int substituteOrd;
        final BytesRef substituteTerm;
        final boolean exists;

        ReplaceMissing(SortedDocValues in, BytesRef term) {
            this.in = in;
            this.substituteTerm = term;
            int sub = in.lookupTerm(term);
            if (sub < 0) {
                this.substituteOrd = -sub - 1;
                this.exists = false;
            } else {
                this.substituteOrd = sub;
                this.exists = true;
            }
        }

        @Override
        public int getOrd(int docID) {
            int ord = this.in.getOrd(docID);
            if (ord < 0) {
                return this.substituteOrd;
            }
            if (!this.exists && ord >= this.substituteOrd) {
                return ord + 1;
            }
            return ord;
        }

        @Override
        public int getValueCount() {
            if (this.exists) {
                return this.in.getValueCount();
            }
            return this.in.getValueCount() + 1;
        }

        @Override
        public BytesRef lookupOrd(int ord) {
            if (ord == this.substituteOrd) {
                return this.substituteTerm;
            }
            if (!this.exists && ord > this.substituteOrd) {
                return this.in.lookupOrd(ord - 1);
            }
            return this.in.lookupOrd(ord);
        }
    }
}

