/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.index.fielddata;

import java.util.Arrays;
import org.apache.lucene.util.ArrayUtil;
import org.apache.lucene.util.BytesRef;
import org.apache.lucene.util.BytesRefBuilder;
import org.apache.lucene.util.InPlaceMergeSorter;
import org.apache.lucene.util.RamUsageEstimator;
import org.apache.lucene.util.Sorter;
import org.elasticsearch.index.fielddata.SortedBinaryDocValues;

public abstract class SortingBinaryDocValues
extends SortedBinaryDocValues {
    protected int count;
    protected BytesRefBuilder[] values = new BytesRefBuilder[]{new BytesRefBuilder()};
    private final Sorter sorter = new InPlaceMergeSorter(){

        @Override
        protected void swap(int i, int j) {
            ArrayUtil.swap(SortingBinaryDocValues.this.values, i, j);
        }

        @Override
        protected int compare(int i, int j) {
            return SortingBinaryDocValues.this.values[i].get().compareTo(SortingBinaryDocValues.this.values[j].get());
        }
    };

    protected SortingBinaryDocValues() {
    }

    protected final void grow() {
        if (this.values.length < this.count) {
            int oldLen = this.values.length;
            int newLen = ArrayUtil.oversize(this.count, RamUsageEstimator.NUM_BYTES_OBJECT_REF);
            this.values = Arrays.copyOf(this.values, newLen);
            for (int i = oldLen; i < newLen; ++i) {
                this.values[i] = new BytesRefBuilder();
            }
        }
    }

    protected final void sort() {
        this.sorter.sort(0, this.count);
    }

    @Override
    public final int count() {
        return this.count;
    }

    @Override
    public final BytesRef valueAt(int index) {
        return this.values[index].get();
    }
}

