/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.gateway;

import com.carrotsearch.hppc.ObjectLongHashMap;
import com.carrotsearch.hppc.ObjectLongMap;
import com.carrotsearch.hppc.cursors.ObjectCursor;
import com.carrotsearch.hppc.cursors.ObjectLongCursor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.MetaData;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.routing.RoutingNode;
import org.elasticsearch.cluster.routing.RoutingNodes;
import org.elasticsearch.cluster.routing.ShardRouting;
import org.elasticsearch.cluster.routing.UnassignedInfo;
import org.elasticsearch.cluster.routing.allocation.AllocateUnassignedDecision;
import org.elasticsearch.cluster.routing.allocation.NodeAllocationResult;
import org.elasticsearch.cluster.routing.allocation.RoutingAllocation;
import org.elasticsearch.cluster.routing.allocation.decider.Decision;
import org.elasticsearch.common.Nullable;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.ByteSizeValue;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.gateway.AsyncShardFetch;
import org.elasticsearch.gateway.BaseGatewayShardAllocator;
import org.elasticsearch.index.store.StoreFileMetaData;
import org.elasticsearch.indices.store.TransportNodesListShardStoreMetaData;
import org.elasticsearch.log4j.Logger;

public abstract class ReplicaShardAllocator
extends BaseGatewayShardAllocator {
    public ReplicaShardAllocator(Settings settings) {
        super(settings);
    }

    public void processExistingRecoveries(RoutingAllocation allocation) {
        MetaData metaData = allocation.metaData();
        RoutingNodes routingNodes = allocation.routingNodes();
        ArrayList<Runnable> shardCancellationActions = new ArrayList<Runnable>();
        for (RoutingNode routingNode : routingNodes) {
            for (ShardRouting shard : routingNode) {
                if (shard.primary() || !shard.initializing() || shard.relocatingNodeId() != null || shard.unassignedInfo() != null && shard.unassignedInfo().getReason() == UnassignedInfo.Reason.INDEX_CREATED) continue;
                AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> shardStores = this.fetchData(shard, allocation);
                if (!shardStores.hasData()) {
                    this.logger.trace("{}: fetching new stores for initializing shard", (Object)shard);
                    continue;
                }
                ShardRouting primaryShard = allocation.routingNodes().activePrimary(shard.shardId());
                assert (primaryShard != null) : "the replica shard can be allocated on at least one node, so there must be an active primary";
                TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryStore = this.findStore(primaryShard, allocation, shardStores);
                if (primaryStore == null) {
                    this.logger.trace("{}: no primary shard store found or allocated, letting actual allocation figure it out", (Object)shard);
                    continue;
                }
                MatchingNodes matchingNodes = this.findMatchingNodes(shard, allocation, primaryStore, shardStores, false);
                if (matchingNodes.getNodeWithHighestMatch() == null) continue;
                DiscoveryNode currentNode = allocation.nodes().get(shard.currentNodeId());
                DiscoveryNode nodeWithHighestMatch = matchingNodes.getNodeWithHighestMatch();
                String currentSyncId = shardStores.getData().containsKey(currentNode) ? shardStores.getData().get(currentNode).storeFilesMetaData().syncId() : null;
                if (currentNode.equals(nodeWithHighestMatch) || Objects.equals(currentSyncId, primaryStore.syncId()) || !matchingNodes.isNodeMatchBySyncID(nodeWithHighestMatch)) continue;
                this.logger.debug("cancelling allocation of replica on [{}], sync id match found on node [{}]", (Object)currentNode, (Object)nodeWithHighestMatch);
                UnassignedInfo unassignedInfo = new UnassignedInfo(UnassignedInfo.Reason.REALLOCATED_REPLICA, "existing allocation of replica to [" + currentNode + "] cancelled, sync id match found on node [" + nodeWithHighestMatch + "]", null, 0, allocation.getCurrentNanoTime(), System.currentTimeMillis(), false, UnassignedInfo.AllocationStatus.NO_ATTEMPT);
                shardCancellationActions.add(() -> routingNodes.failShard(this.logger, shard, unassignedInfo, metaData.getIndexSafe(shard.index()), allocation.changes()));
            }
        }
        for (Runnable action : shardCancellationActions) {
            action.run();
        }
    }

    private static boolean isResponsibleFor(ShardRouting shard) {
        return !shard.primary() && shard.unassigned() && shard.unassignedInfo().getReason() != UnassignedInfo.Reason.INDEX_CREATED;
    }

    @Override
    public AllocateUnassignedDecision makeAllocationDecision(ShardRouting unassignedShard, RoutingAllocation allocation, Logger logger) {
        if (!ReplicaShardAllocator.isResponsibleFor(unassignedShard)) {
            return AllocateUnassignedDecision.NOT_TAKEN;
        }
        RoutingNodes routingNodes = allocation.routingNodes();
        boolean explain = allocation.debugDecision();
        Tuple<Decision, Map<String, NodeAllocationResult>> result = this.canBeAllocatedToAtLeastOneNode(unassignedShard, allocation);
        Decision allocateDecision = result.v1();
        if (!(allocateDecision.type() == Decision.Type.YES || explain && this.hasInitiatedFetching(unassignedShard))) {
            logger.trace("{}: ignoring allocation, can't be allocated on any node", (Object)unassignedShard);
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.fromDecision(allocateDecision.type()), (List<NodeAllocationResult>)(result.v2() != null ? new ArrayList<NodeAllocationResult>(result.v2().values()) : null));
        }
        AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> shardStores = this.fetchData(unassignedShard, allocation);
        if (!shardStores.hasData()) {
            logger.trace("{}: ignoring allocation, still fetching shard stores", (Object)unassignedShard);
            allocation.setHasPendingAsyncFetch();
            List<NodeAllocationResult> nodeDecisions = null;
            if (explain) {
                nodeDecisions = this.buildDecisionsForAllNodes(unassignedShard, allocation);
            }
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.FETCHING_SHARD_DATA, nodeDecisions);
        }
        ShardRouting primaryShard = routingNodes.activePrimary(unassignedShard.shardId());
        if (primaryShard == null) {
            assert (explain) : "primary should only be null here if we are in explain mode, so we didn't exit early when canBeAllocatedToAtLeastOneNode didn't return a YES decision";
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.fromDecision(allocateDecision.type()), new ArrayList<NodeAllocationResult>(result.v2().values()));
        }
        TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryStore = this.findStore(primaryShard, allocation, shardStores);
        if (primaryStore == null) {
            logger.trace("{}: no primary shard store found or allocated, letting actual allocation figure it out", (Object)unassignedShard);
            return AllocateUnassignedDecision.NOT_TAKEN;
        }
        MatchingNodes matchingNodes = this.findMatchingNodes(unassignedShard, allocation, primaryStore, shardStores, explain);
        assert (!explain || matchingNodes.nodeDecisions != null) : "in explain mode, we must have individual node decisions";
        List<NodeAllocationResult> nodeDecisions = this.augmentExplanationsWithStoreInfo(result.v2(), matchingNodes.nodeDecisions);
        if (allocateDecision.type() != Decision.Type.YES) {
            return AllocateUnassignedDecision.no(UnassignedInfo.AllocationStatus.fromDecision(allocateDecision.type()), nodeDecisions);
        }
        if (matchingNodes.getNodeWithHighestMatch() != null) {
            RoutingNode nodeWithHighestMatch = allocation.routingNodes().node(matchingNodes.getNodeWithHighestMatch().getId());
            Decision decision = allocation.deciders().canAllocate(unassignedShard, nodeWithHighestMatch, allocation);
            if (decision.type() == Decision.Type.THROTTLE) {
                logger.debug("[{}][{}]: throttling allocation [{}] to [{}] in order to reuse its unallocated persistent store", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)nodeWithHighestMatch.node());
                return AllocateUnassignedDecision.throttle(nodeDecisions);
            }
            logger.debug("[{}][{}]: allocating [{}] to [{}] in order to reuse its unallocated persistent store", (Object)unassignedShard.index(), (Object)unassignedShard.id(), (Object)unassignedShard, (Object)nodeWithHighestMatch.node());
            return AllocateUnassignedDecision.yes(nodeWithHighestMatch.node(), null, nodeDecisions, true);
        }
        if (!matchingNodes.hasAnyData() && unassignedShard.unassignedInfo().isDelayed()) {
            logger.debug("{}: allocation of [{}] is delayed", (Object)unassignedShard.shardId(), (Object)unassignedShard);
            long remainingDelayMillis = 0L;
            long totalDelayMillis = 0L;
            if (explain) {
                UnassignedInfo unassignedInfo = unassignedShard.unassignedInfo();
                MetaData metadata = allocation.metaData();
                IndexMetaData indexMetaData = metadata.index(unassignedShard.index());
                totalDelayMillis = UnassignedInfo.INDEX_DELAYED_NODE_LEFT_TIMEOUT_SETTING.get(indexMetaData.getSettings()).getMillis();
                long remainingDelayNanos = unassignedInfo.getRemainingDelay(System.nanoTime(), indexMetaData.getSettings());
                remainingDelayMillis = TimeValue.timeValueNanos(remainingDelayNanos).millis();
            }
            return AllocateUnassignedDecision.delayed(remainingDelayMillis, totalDelayMillis, nodeDecisions);
        }
        return AllocateUnassignedDecision.NOT_TAKEN;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Tuple<Decision, Map<String, NodeAllocationResult>> canBeAllocatedToAtLeastOneNode(ShardRouting shard, RoutingAllocation allocation) {
        Decision madeDecision = Decision.NO;
        boolean explain = allocation.debugDecision();
        HashMap<String, NodeAllocationResult> nodeDecisions = explain ? new HashMap<String, NodeAllocationResult>() : null;
        for (ObjectCursor<DiscoveryNode> objectCursor : allocation.nodes().getDataNodes().values()) {
            RoutingNode node = allocation.routingNodes().node(((DiscoveryNode)objectCursor.value).getId());
            if (node == null) continue;
            Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
            if (decision.type() == Decision.Type.YES && madeDecision.type() != Decision.Type.YES) {
                if (!explain) return Tuple.tuple(decision, nodeDecisions);
                madeDecision = decision;
            } else if (madeDecision.type() == Decision.Type.NO && decision.type() == Decision.Type.THROTTLE) {
                madeDecision = decision;
            }
            if (!explain) continue;
            nodeDecisions.put(node.nodeId(), new NodeAllocationResult(node.node(), null, decision));
        }
        return Tuple.tuple(madeDecision, nodeDecisions);
    }

    private List<NodeAllocationResult> augmentExplanationsWithStoreInfo(Map<String, NodeAllocationResult> nodeDecisions, Map<String, NodeAllocationResult> withShardStores) {
        if (nodeDecisions == null || withShardStores == null) {
            return null;
        }
        ArrayList<NodeAllocationResult> augmented = new ArrayList<NodeAllocationResult>();
        for (Map.Entry<String, NodeAllocationResult> entry : nodeDecisions.entrySet()) {
            if (withShardStores.containsKey(entry.getKey())) {
                augmented.add(withShardStores.get(entry.getKey()));
                continue;
            }
            augmented.add(entry.getValue());
        }
        return augmented;
    }

    private TransportNodesListShardStoreMetaData.StoreFilesMetaData findStore(ShardRouting shard, RoutingAllocation allocation, AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> data) {
        assert (shard.currentNodeId() != null);
        DiscoveryNode primaryNode = allocation.nodes().get(shard.currentNodeId());
        if (primaryNode == null) {
            return null;
        }
        TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData primaryNodeFilesStore = data.getData().get(primaryNode);
        if (primaryNodeFilesStore == null) {
            return null;
        }
        return primaryNodeFilesStore.storeFilesMetaData();
    }

    private MatchingNodes findMatchingNodes(ShardRouting shard, RoutingAllocation allocation, TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryStore, AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> data, boolean explain) {
        ObjectLongHashMap<DiscoveryNode> nodesToSize = new ObjectLongHashMap<DiscoveryNode>();
        HashMap<String, NodeAllocationResult> nodeDecisions = explain ? new HashMap<String, NodeAllocationResult>() : null;
        for (Map.Entry<DiscoveryNode, TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> nodeStoreEntry : data.getData().entrySet()) {
            RoutingNode node;
            DiscoveryNode discoNode = nodeStoreEntry.getKey();
            TransportNodesListShardStoreMetaData.StoreFilesMetaData storeFilesMetaData = nodeStoreEntry.getValue().storeFilesMetaData();
            if (storeFilesMetaData.isEmpty() || (node = allocation.routingNodes().node(discoNode.getId())) == null) continue;
            Decision decision = allocation.deciders().canAllocate(shard, node, allocation);
            long matchingBytes = -1L;
            if (explain) {
                matchingBytes = ReplicaShardAllocator.computeMatchingBytes(primaryStore, storeFilesMetaData);
                NodeAllocationResult.ShardStoreInfo shardStoreInfo = new NodeAllocationResult.ShardStoreInfo(matchingBytes);
                nodeDecisions.put(node.nodeId(), new NodeAllocationResult(discoNode, shardStoreInfo, decision));
            }
            if (decision.type() == Decision.Type.NO) continue;
            if (matchingBytes < 0L) {
                matchingBytes = ReplicaShardAllocator.computeMatchingBytes(primaryStore, storeFilesMetaData);
            }
            nodesToSize.put(discoNode, matchingBytes);
            if (!this.logger.isTraceEnabled()) continue;
            if (matchingBytes == Long.MAX_VALUE) {
                this.logger.trace("{}: node [{}] has same sync id {} as primary", (Object)shard, (Object)discoNode.getName(), (Object)storeFilesMetaData.syncId());
                continue;
            }
            this.logger.trace("{}: node [{}] has [{}/{}] bytes of re-usable data", (Object)shard, (Object)discoNode.getName(), (Object)new ByteSizeValue(matchingBytes), (Object)matchingBytes);
        }
        return new MatchingNodes(nodesToSize, nodeDecisions);
    }

    private static long computeMatchingBytes(TransportNodesListShardStoreMetaData.StoreFilesMetaData primaryStore, TransportNodesListShardStoreMetaData.StoreFilesMetaData storeFilesMetaData) {
        String primarySyncId = primaryStore.syncId();
        String replicaSyncId = storeFilesMetaData.syncId();
        if (replicaSyncId != null && replicaSyncId.equals(primarySyncId)) {
            return Long.MAX_VALUE;
        }
        long sizeMatched = 0L;
        for (StoreFileMetaData storeFileMetaData : storeFilesMetaData) {
            String metaDataFileName = storeFileMetaData.name();
            if (!primaryStore.fileExists(metaDataFileName) || !primaryStore.file(metaDataFileName).isSame(storeFileMetaData)) continue;
            sizeMatched += storeFileMetaData.length();
        }
        return sizeMatched;
    }

    protected abstract AsyncShardFetch.FetchResult<TransportNodesListShardStoreMetaData.NodeStoreFilesMetaData> fetchData(ShardRouting var1, RoutingAllocation var2);

    protected abstract boolean hasInitiatedFetching(ShardRouting var1);

    static class MatchingNodes {
        private final ObjectLongMap<DiscoveryNode> nodesToSize;
        private final DiscoveryNode nodeWithHighestMatch;
        @Nullable
        private final Map<String, NodeAllocationResult> nodeDecisions;

        MatchingNodes(ObjectLongMap<DiscoveryNode> nodesToSize, @Nullable Map<String, NodeAllocationResult> nodeDecisions) {
            this.nodesToSize = nodesToSize;
            this.nodeDecisions = nodeDecisions;
            long highestMatchSize = 0L;
            DiscoveryNode highestMatchNode = null;
            for (ObjectLongCursor cursor : nodesToSize) {
                if (cursor.value <= highestMatchSize) continue;
                highestMatchSize = cursor.value;
                highestMatchNode = (DiscoveryNode)cursor.key;
            }
            this.nodeWithHighestMatch = highestMatchNode;
        }

        @Nullable
        public DiscoveryNode getNodeWithHighestMatch() {
            return this.nodeWithHighestMatch;
        }

        public boolean isNodeMatchBySyncID(DiscoveryNode node) {
            return this.nodesToSize.get(node) == Long.MAX_VALUE;
        }

        public boolean hasAnyData() {
            return !this.nodesToSize.isEmpty();
        }
    }
}

