/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.fastjson.serializer;

import java.io.IOException;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import org.elasticsearch.fastjson.JSONException;
import org.elasticsearch.fastjson.parser.DefaultJSONParser;
import org.elasticsearch.fastjson.parser.JSONLexer;
import org.elasticsearch.fastjson.parser.deserializer.ObjectDeserializer;
import org.elasticsearch.fastjson.serializer.JSONSerializer;
import org.elasticsearch.fastjson.serializer.ObjectSerializer;
import org.elasticsearch.fastjson.serializer.SerializeWriter;
import org.elasticsearch.fastjson.serializer.SerializerFeature;
import org.elasticsearch.fastjson.util.TypeUtils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class BigDecimalCodec
implements ObjectSerializer,
ObjectDeserializer {
    public static final BigDecimalCodec instance = new BigDecimalCodec();

    @Override
    public void write(JSONSerializer serializer, Object object, Object fieldName, Type fieldType, int features) throws IOException {
        SerializeWriter out = serializer.out;
        if (object == null) {
            out.writeNull(SerializerFeature.WriteNullNumberAsZero);
        } else {
            BigDecimal val = (BigDecimal)object;
            String outText = out.isEnabled(SerializerFeature.WriteBigDecimalAsPlain) ? val.toPlainString() : val.toString();
            out.write(outText);
            if (out.isEnabled(SerializerFeature.WriteClassName) && fieldType != BigDecimal.class && val.scale() == 0) {
                out.write(46);
            }
        }
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        try {
            return BigDecimalCodec.deserialze(parser);
        }
        catch (Exception ex) {
            throw new JSONException("parseDecimal error, field : " + fieldName, ex);
        }
    }

    public static <T> T deserialze(DefaultJSONParser parser) {
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 2) {
            BigDecimal decimalValue = lexer.decimalValue();
            lexer.nextToken(16);
            return (T)decimalValue;
        }
        if (lexer.token() == 3) {
            BigDecimal val = lexer.decimalValue();
            lexer.nextToken(16);
            return (T)val;
        }
        Object value = parser.parse();
        return (T)(value == null ? null : TypeUtils.castToBigDecimal(value));
    }

    @Override
    public int getFastMatchToken() {
        return 2;
    }
}

