/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.fastjson.parser.deserializer;

import java.lang.reflect.Type;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import org.elasticsearch.fastjson.JSON;
import org.elasticsearch.fastjson.JSONException;
import org.elasticsearch.fastjson.parser.DefaultJSONParser;
import org.elasticsearch.fastjson.parser.Feature;
import org.elasticsearch.fastjson.parser.JSONLexer;
import org.elasticsearch.fastjson.parser.JSONScanner;
import org.elasticsearch.fastjson.parser.deserializer.ContextObjectDeserializer;
import org.elasticsearch.fastjson.parser.deserializer.ObjectDeserializer;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class AbstractDateDeserializer
extends ContextObjectDeserializer
implements ObjectDeserializer {
    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName) {
        return this.deserialze(parser, clazz, fieldName, null, 0);
    }

    @Override
    public <T> T deserialze(DefaultJSONParser parser, Type clazz, Object fieldName, String format, int features) {
        Object val;
        JSONLexer lexer = parser.lexer;
        if (lexer.token() == 2) {
            val = lexer.longValue();
            lexer.nextToken(16);
        } else if (lexer.token() == 4) {
            String strVal;
            block32: {
                strVal = lexer.stringVal();
                if (format != null) {
                    SimpleDateFormat simpleDateFormat;
                    block31: {
                        simpleDateFormat = null;
                        try {
                            simpleDateFormat = new SimpleDateFormat(format, JSON.defaultLocale);
                        }
                        catch (IllegalArgumentException ex) {
                            if (format.equals("yyyy-MM-ddTHH:mm:ss.SSS")) {
                                format = "yyyy-MM-dd'T'HH:mm:ss.SSS";
                                simpleDateFormat = new SimpleDateFormat(format);
                            }
                            if (!format.equals("yyyy-MM-ddTHH:mm:ss")) break block31;
                            format = "yyyy-MM-dd'T'HH:mm:ss";
                            simpleDateFormat = new SimpleDateFormat(format);
                        }
                    }
                    try {
                        val = simpleDateFormat.parse(strVal);
                    }
                    catch (ParseException ex) {
                        if (format.equals("yyyy-MM-dd'T'HH:mm:ss.SSS") && strVal.length() == 19) {
                            try {
                                val = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss").parse(strVal);
                            }
                            catch (ParseException ex2) {
                                val = null;
                            }
                            break block32;
                        }
                        val = null;
                    }
                } else {
                    val = null;
                }
            }
            if (val == null) {
                val = strVal;
                lexer.nextToken(16);
                if (lexer.isEnabled(Feature.AllowISO8601DateFormat)) {
                    JSONScanner iso8601Lexer = new JSONScanner(strVal);
                    if (iso8601Lexer.scanISO8601DateIfMatch()) {
                        val = iso8601Lexer.getCalendar().getTime();
                    }
                    iso8601Lexer.close();
                }
            }
        } else if (lexer.token() == 8) {
            lexer.nextToken();
            val = null;
        } else if (lexer.token() == 12) {
            lexer.nextToken();
            if (lexer.token() == 4) {
                String key = lexer.stringVal();
                if (JSON.DEFAULT_TYPE_KEY.equals(key)) {
                    lexer.nextToken();
                    parser.accept(17);
                    String typeName = lexer.stringVal();
                    Class<?> type = parser.getConfig().checkAutoType(typeName, null);
                    if (type != null) {
                        clazz = type;
                    }
                    parser.accept(4);
                    parser.accept(16);
                }
            } else {
                throw new JSONException("syntax error");
            }
            lexer.nextTokenWithColon(2);
            if (lexer.token() != 2) {
                throw new JSONException("syntax error : " + lexer.tokenName());
            }
            long timeMillis = lexer.longValue();
            lexer.nextToken();
            val = timeMillis;
            parser.accept(13);
        } else if (parser.getResolveStatus() == 2) {
            parser.setResolveStatus(0);
            parser.accept(16);
            if (lexer.token() == 4) {
                if (!"val".equals(lexer.stringVal())) {
                    throw new JSONException("syntax error");
                }
            } else {
                throw new JSONException("syntax error");
            }
            lexer.nextToken();
            parser.accept(17);
            val = parser.parse();
            parser.accept(13);
        } else {
            val = parser.parse();
        }
        return this.cast(parser, clazz, fieldName, val);
    }

    protected abstract <T> T cast(DefaultJSONParser var1, Type var2, Object var3, Object var4);
}

