/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.discovery.local;

import java.util.HashSet;
import java.util.Optional;
import java.util.Queue;
import java.util.concurrent.ConcurrentMap;
import org.elasticsearch.cluster.ClusterChangedEvent;
import org.elasticsearch.cluster.ClusterName;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.cluster.ClusterStateTaskExecutor;
import org.elasticsearch.cluster.Diff;
import org.elasticsearch.cluster.IncompatibleClusterStateVersionException;
import org.elasticsearch.cluster.LocalClusterUpdateTask;
import org.elasticsearch.cluster.node.DiscoveryNode;
import org.elasticsearch.cluster.node.DiscoveryNodes;
import org.elasticsearch.cluster.routing.allocation.AllocationService;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.component.AbstractLifecycleComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.io.stream.BytesStreamOutput;
import org.elasticsearch.common.io.stream.NamedWriteableRegistry;
import org.elasticsearch.common.io.stream.StreamInput;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.ConcurrentCollections;
import org.elasticsearch.discovery.AckClusterStatePublishResponseHandler;
import org.elasticsearch.discovery.BlockingClusterStatePublishResponseHandler;
import org.elasticsearch.discovery.Discovery;
import org.elasticsearch.discovery.DiscoverySettings;
import org.elasticsearch.discovery.DiscoveryStats;
import org.elasticsearch.discovery.zen.PendingClusterStateStats;
import org.elasticsearch.log4j.message.ParameterizedMessage;

public class LocalDiscovery
extends AbstractLifecycleComponent
implements Discovery {
    private static final LocalDiscovery[] NO_MEMBERS = new LocalDiscovery[0];
    private final ClusterService clusterService;
    private AllocationService allocationService;
    private final ClusterName clusterName;
    private final DiscoverySettings discoverySettings;
    private final NamedWriteableRegistry namedWriteableRegistry;
    private volatile boolean master = false;
    private static final ConcurrentMap<ClusterName, ClusterGroup> clusterGroups = ConcurrentCollections.newConcurrentMap();
    private volatile ClusterState lastProcessedClusterState;

    @Inject
    public LocalDiscovery(Settings settings, ClusterService clusterService, ClusterSettings clusterSettings, NamedWriteableRegistry namedWriteableRegistry) {
        super(settings);
        this.clusterName = clusterService.getClusterName();
        this.clusterService = clusterService;
        this.discoverySettings = new DiscoverySettings(settings, clusterSettings);
        this.namedWriteableRegistry = namedWriteableRegistry;
    }

    @Override
    public void setAllocationService(AllocationService allocationService) {
        this.allocationService = allocationService;
    }

    @Override
    protected void doStart() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void startInitialJoin() {
        ConcurrentMap<ClusterName, ClusterGroup> concurrentMap = clusterGroups;
        synchronized (concurrentMap) {
            Object master;
            ClusterGroup clusterGroup = (ClusterGroup)clusterGroups.get(this.clusterName);
            if (clusterGroup == null) {
                clusterGroup = new ClusterGroup();
                clusterGroups.put(this.clusterName, clusterGroup);
            }
            this.logger.debug("Connected to cluster [{}]", (Object)this.clusterName);
            Optional<LocalDiscovery> current = clusterGroup.members().stream().filter(other -> other.localNode().equals(this.localNode()) || other.localNode().getId().equals(this.localNode().getId())).findFirst();
            if (current.isPresent()) {
                throw new IllegalStateException("current cluster group already contains a node with the same id. current " + current.get().localNode() + ", this node " + this.localNode());
            }
            clusterGroup.members().add(this);
            Object firstMaster = null;
            for (LocalDiscovery localDiscovery : clusterGroup.members()) {
                if (!localDiscovery.localNode().isMasterNode()) continue;
                firstMaster = localDiscovery;
                break;
            }
            if (firstMaster != null && firstMaster.equals(this)) {
                this.master = true;
                master = firstMaster;
                this.clusterService.submitStateUpdateTask("local-disco-initial_connect(master)", new LocalClusterUpdateTask((LocalDiscovery)master){
                    final /* synthetic */ LocalDiscovery val$master;
                    {
                        this.val$master = localDiscovery;
                    }

                    @Override
                    public ClusterStateTaskExecutor.ClusterTasksResult<LocalClusterUpdateTask> execute(ClusterState currentState) {
                        DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder();
                        for (LocalDiscovery discovery : ((ClusterGroup)clusterGroups.get(LocalDiscovery.this.clusterName)).members()) {
                            nodesBuilder.add(discovery.localNode());
                        }
                        nodesBuilder.localNodeId(this.val$master.localNode().getId()).masterNodeId(this.val$master.localNode().getId());
                        return 1.newState(ClusterState.builder(currentState).nodes(nodesBuilder).build());
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        LocalDiscovery.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                    }
                });
            } else if (firstMaster != null) {
                master = firstMaster;
                ((LocalDiscovery)firstMaster).clusterService.submitStateUpdateTask("local-disco-receive(from node[" + this.localNode() + "])", new LocalClusterUpdateTask((LocalDiscovery)master){
                    final /* synthetic */ LocalDiscovery val$master;
                    {
                        this.val$master = localDiscovery;
                    }

                    @Override
                    public ClusterStateTaskExecutor.ClusterTasksResult<LocalClusterUpdateTask> execute(ClusterState currentState) {
                        DiscoveryNodes.Builder nodesBuilder = DiscoveryNodes.builder();
                        for (LocalDiscovery discovery : ((ClusterGroup)clusterGroups.get(LocalDiscovery.this.clusterName)).members()) {
                            nodesBuilder.add(discovery.localNode());
                        }
                        nodesBuilder.localNodeId(this.val$master.localNode().getId()).masterNodeId(this.val$master.localNode().getId());
                        currentState = ClusterState.builder(currentState).nodes(nodesBuilder).build();
                        return 2.newState(this.val$master.allocationService.reroute(currentState, "node_add"));
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        LocalDiscovery.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                    }
                });
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doStop() {
        ConcurrentMap<ClusterName, ClusterGroup> concurrentMap = clusterGroups;
        synchronized (concurrentMap) {
            ClusterGroup clusterGroup = (ClusterGroup)clusterGroups.get(this.clusterName);
            if (clusterGroup == null) {
                this.logger.warn("Illegal state, should not have an empty cluster group when stopping, I should be there at teh very least...");
                return;
            }
            clusterGroup.members().remove(this);
            if (clusterGroup.members().isEmpty()) {
                clusterGroups.remove(this.clusterName);
                return;
            }
            LocalDiscovery firstMaster = null;
            for (LocalDiscovery localDiscovery : clusterGroup.members()) {
                if (!localDiscovery.localNode().isMasterNode()) continue;
                firstMaster = localDiscovery;
                break;
            }
            if (firstMaster != null) {
                if (this.master) {
                    firstMaster.master = true;
                }
                final HashSet<String> newMembers = new HashSet<String>();
                for (LocalDiscovery discovery : clusterGroup.members()) {
                    newMembers.add(discovery.localNode().getId());
                }
                final LocalDiscovery localDiscovery = firstMaster;
                localDiscovery.clusterService.submitStateUpdateTask("local-disco-update", new LocalClusterUpdateTask(){

                    @Override
                    public ClusterStateTaskExecutor.ClusterTasksResult<LocalClusterUpdateTask> execute(ClusterState currentState) {
                        DiscoveryNodes newNodes = currentState.nodes().removeDeadMembers(newMembers, localDiscovery.localNode().getId());
                        DiscoveryNodes.Delta delta = newNodes.delta(currentState.nodes());
                        if (delta.added()) {
                            LocalDiscovery.this.logger.warn("No new nodes should be created when a new discovery view is accepted");
                        }
                        ClusterState updatedState = ClusterState.builder(currentState).nodes(newNodes).build();
                        return 3.newState(localDiscovery.allocationService.deassociateDeadNodes(updatedState, true, "node stopped"));
                    }

                    @Override
                    public void onFailure(String source, Exception e) {
                        LocalDiscovery.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                    }
                });
            }
        }
    }

    @Override
    protected void doClose() {
    }

    @Override
    public DiscoveryNode localNode() {
        return this.clusterService.localNode();
    }

    @Override
    public String nodeDescription() {
        return this.clusterName.value() + "/" + this.localNode().getId();
    }

    @Override
    public void publish(ClusterChangedEvent clusterChangedEvent, Discovery.AckListener ackListener) {
        if (!this.master) {
            throw new IllegalStateException("Shouldn't publish state when not master");
        }
        LocalDiscovery[] members = this.members();
        if (members.length > 0) {
            HashSet<DiscoveryNode> nodesToPublishTo = new HashSet<DiscoveryNode>(members.length);
            for (LocalDiscovery localDiscovery : members) {
                if (localDiscovery.master) continue;
                nodesToPublishTo.add(localDiscovery.localNode());
            }
            this.publish(members, clusterChangedEvent, new AckClusterStatePublishResponseHandler(nodesToPublishTo, ackListener));
        }
    }

    @Override
    public DiscoveryStats stats() {
        return new DiscoveryStats((PendingClusterStateStats)null);
    }

    @Override
    public DiscoverySettings getDiscoverySettings() {
        return this.discoverySettings;
    }

    @Override
    public int getMinimumMasterNodes() {
        return -1;
    }

    private LocalDiscovery[] members() {
        ClusterGroup clusterGroup = (ClusterGroup)clusterGroups.get(this.clusterName);
        if (clusterGroup == null) {
            return NO_MEMBERS;
        }
        Queue<LocalDiscovery> members = clusterGroup.members();
        return members.toArray(new LocalDiscovery[members.size()]);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void publish(LocalDiscovery[] members, ClusterChangedEvent clusterChangedEvent, final BlockingClusterStatePublishResponseHandler publishResponseHandler) {
        block18: {
            try {
                byte[] clusterStateBytes = null;
                byte[] clusterStateDiffBytes = null;
                ClusterState clusterState = clusterChangedEvent.state();
                for (final LocalDiscovery discovery : members) {
                    if (discovery.master) continue;
                    ClusterState newNodeSpecificClusterState = null;
                    LocalDiscovery localDiscovery = this;
                    synchronized (localDiscovery) {
                        if (discovery.lastProcessedClusterState != null && clusterChangedEvent.previousState().nodes().nodeExists(discovery.localNode())) {
                            if (clusterStateDiffBytes == null) {
                                Diff<ClusterState> diff = clusterState.diff(clusterChangedEvent.previousState());
                                BytesStreamOutput os = new BytesStreamOutput();
                                diff.writeTo(os);
                                clusterStateDiffBytes = BytesReference.toBytes(os.bytes());
                            }
                            try {
                                newNodeSpecificClusterState = ClusterState.readDiffFrom(StreamInput.wrap(clusterStateDiffBytes), discovery.localNode()).apply(discovery.lastProcessedClusterState);
                                this.logger.trace("sending diff cluster state version [{}] with size {} to [{}]", (Object)clusterState.version(), (Object)clusterStateDiffBytes.length, (Object)discovery.localNode().getName());
                            }
                            catch (IncompatibleClusterStateVersionException ex) {
                                this.logger.warn(() -> new ParameterizedMessage("incompatible cluster state version [{}] - resending complete cluster state", (Object)clusterState.version()), (Throwable)ex);
                            }
                        }
                        if (newNodeSpecificClusterState == null) {
                            if (clusterStateBytes == null) {
                                clusterStateBytes = ClusterState.Builder.toBytes(clusterState);
                            }
                            newNodeSpecificClusterState = ClusterState.Builder.fromBytes(clusterStateBytes, discovery.localNode(), this.namedWriteableRegistry);
                        }
                        discovery.lastProcessedClusterState = newNodeSpecificClusterState;
                    }
                    final ClusterState nodeSpecificClusterState = newNodeSpecificClusterState;
                    if (nodeSpecificClusterState.nodes().getLocalNode() != null) {
                        assert (nodeSpecificClusterState.nodes().getMasterNode() != null) : "received a cluster state without a master";
                        assert (!nodeSpecificClusterState.blocks().hasGlobalBlock(this.discoverySettings.getNoMasterBlock())) : "received a cluster state with a master block";
                        discovery.clusterService.submitStateUpdateTask("local-disco-receive(from master)", new LocalClusterUpdateTask(){

                            @Override
                            public ClusterStateTaskExecutor.ClusterTasksResult<LocalClusterUpdateTask> execute(ClusterState currentState) {
                                if (currentState.supersedes(nodeSpecificClusterState)) {
                                    return 4.unchanged();
                                }
                                if (currentState.blocks().hasGlobalBlock(LocalDiscovery.this.discoverySettings.getNoMasterBlock())) {
                                    LocalDiscovery.this.logger.debug("got first state from fresh master [{}]", (Object)nodeSpecificClusterState.nodes().getMasterNodeId());
                                    return 4.newState(nodeSpecificClusterState);
                                }
                                ClusterState.Builder builder = ClusterState.builder(nodeSpecificClusterState);
                                if (nodeSpecificClusterState.routingTable().version() == currentState.routingTable().version()) {
                                    builder.routingTable(currentState.routingTable());
                                }
                                if (nodeSpecificClusterState.metaData().version() == currentState.metaData().version()) {
                                    builder.metaData(currentState.metaData());
                                }
                                return 4.newState(builder.build());
                            }

                            @Override
                            public void onFailure(String source, Exception e) {
                                LocalDiscovery.this.logger.error(() -> new ParameterizedMessage("unexpected failure during [{}]", (Object)source), (Throwable)e);
                                publishResponseHandler.onFailure(discovery.localNode(), e);
                            }

                            @Override
                            public void clusterStateProcessed(String source, ClusterState oldState, ClusterState newState) {
                                publishResponseHandler.onResponse(discovery.localNode());
                            }
                        });
                        continue;
                    }
                    publishResponseHandler.onResponse(discovery.localNode());
                }
                TimeValue publishTimeout = this.discoverySettings.getPublishTimeout();
                if (publishTimeout.millis() <= 0L) break block18;
                try {
                    DiscoveryNode[] pendingNodes;
                    boolean awaited = publishResponseHandler.awaitAllNodes(publishTimeout);
                    if (!awaited && (pendingNodes = publishResponseHandler.pendingNodes()).length > 0) {
                        this.logger.warn("timed out waiting for all nodes to process published state [{}] (timeout [{}], pending nodes: {})", (Object)clusterState.version(), (Object)publishTimeout, (Object)pendingNodes);
                    }
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
            catch (Exception e) {
                throw new IllegalStateException("Cluster state failed to serialize", e);
            }
        }
    }

    private class ClusterGroup {
        private Queue<LocalDiscovery> members = ConcurrentCollections.newQueue();

        private ClusterGroup() {
        }

        Queue<LocalDiscovery> members() {
            return this.members;
        }
    }
}

