/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.common.lucene.search;

import java.io.IOException;
import java.util.Set;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.index.Term;
import org.apache.lucene.search.ConstantScoreWeight;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.search.Query;
import org.apache.lucene.search.Scorer;
import org.apache.lucene.search.Weight;

public class MatchNoDocsQuery
extends Query {
    private final String reason;

    public MatchNoDocsQuery(String reason) {
        this.reason = reason;
    }

    @Override
    public Weight createWeight(IndexSearcher searcher, boolean needsScores) throws IOException {
        return new ConstantScoreWeight(this){

            @Override
            public void extractTerms(Set<Term> terms) {
            }

            @Override
            public Explanation explain(LeafReaderContext context, int doc) throws IOException {
                return Explanation.noMatch(MatchNoDocsQuery.this.reason, new Explanation[0]);
            }

            @Override
            public Scorer scorer(LeafReaderContext context) throws IOException {
                return null;
            }
        };
    }

    @Override
    public String toString(String field) {
        return "MatchNoDocsQuery[\"" + this.reason + "\"]";
    }

    @Override
    public boolean equals(Object obj) {
        return this.sameClassAs(obj);
    }

    @Override
    public int hashCode() {
        return this.classHash();
    }
}

