/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.cluster.routing.allocation;

import com.carrotsearch.hppc.ObjectLookupContainer;
import com.carrotsearch.hppc.cursors.ObjectObjectCursor;
import java.util.Set;
import org.elasticsearch.client.Client;
import org.elasticsearch.cluster.ClusterInfo;
import org.elasticsearch.cluster.ClusterInfoService;
import org.elasticsearch.cluster.DiskUsage;
import org.elasticsearch.cluster.routing.allocation.DiskThresholdSettings;
import org.elasticsearch.common.Strings;
import org.elasticsearch.common.collect.ImmutableOpenMap;
import org.elasticsearch.common.component.AbstractComponent;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.ClusterSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.util.set.Sets;

public class DiskThresholdMonitor
extends AbstractComponent
implements ClusterInfoService.Listener {
    private final DiskThresholdSettings diskThresholdSettings;
    private final Client client;
    private final Set<String> nodeHasPassedWatermark = Sets.newConcurrentHashSet();
    private long lastRunNS;

    @Inject
    public DiskThresholdMonitor(Settings settings, ClusterSettings clusterSettings, ClusterInfoService infoService, Client client) {
        super(settings);
        this.diskThresholdSettings = new DiskThresholdSettings(settings, clusterSettings);
        this.client = client;
        infoService.addListener(this);
    }

    private void warnAboutDiskIfNeeded(DiskUsage usage) {
        if (usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdHigh().getBytes()) {
            this.logger.warn("high disk watermark [{}] exceeded on {}, shards will be relocated away from this node", (Object)this.diskThresholdSettings.getFreeBytesThresholdHigh(), (Object)usage);
        } else if (usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdLow().getBytes()) {
            this.logger.info("low disk watermark [{}] exceeded on {}, replicas will not be assigned to this node", (Object)this.diskThresholdSettings.getFreeBytesThresholdLow(), (Object)usage);
        }
        if (usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdHigh()) {
            this.logger.warn("high disk watermark [{}] exceeded on {}, shards will be relocated away from this node", (Object)Strings.format1Decimals(100.0 - this.diskThresholdSettings.getFreeDiskThresholdHigh(), "%"), (Object)usage);
        } else if (usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdLow()) {
            this.logger.info("low disk watermark [{}] exceeded on {}, replicas will not be assigned to this node", (Object)Strings.format1Decimals(100.0 - this.diskThresholdSettings.getFreeDiskThresholdLow(), "%"), (Object)usage);
        }
    }

    @Override
    public void onNewInfo(ClusterInfo info) {
        ImmutableOpenMap<String, DiskUsage> usages = info.getNodeLeastAvailableDiskUsages();
        if (usages != null) {
            boolean reroute = false;
            String explanation = "";
            ObjectLookupContainer<String> nodes = usages.keys();
            for (String string : this.nodeHasPassedWatermark) {
                if (nodes.contains(string)) continue;
                this.nodeHasPassedWatermark.remove(string);
            }
            for (ObjectObjectCursor objectObjectCursor : usages) {
                String node = (String)objectObjectCursor.key;
                DiskUsage usage = (DiskUsage)objectObjectCursor.value;
                this.warnAboutDiskIfNeeded(usage);
                if (usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdHigh().getBytes() || usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdHigh()) {
                    if (System.nanoTime() - this.lastRunNS > this.diskThresholdSettings.getRerouteInterval().nanos()) {
                        this.lastRunNS = System.nanoTime();
                        reroute = true;
                        explanation = "high disk watermark exceeded on one or more nodes";
                    } else {
                        this.logger.debug("high disk watermark exceeded on {} but an automatic reroute has occurred in the last [{}], skipping reroute", (Object)node, (Object)this.diskThresholdSettings.getRerouteInterval());
                    }
                    this.nodeHasPassedWatermark.add(node);
                    continue;
                }
                if (usage.getFreeBytes() < this.diskThresholdSettings.getFreeBytesThresholdLow().getBytes() || usage.getFreeDiskAsPercentage() < this.diskThresholdSettings.getFreeDiskThresholdLow()) {
                    this.nodeHasPassedWatermark.add(node);
                    continue;
                }
                if (!this.nodeHasPassedWatermark.contains(node)) continue;
                if (System.nanoTime() - this.lastRunNS > this.diskThresholdSettings.getRerouteInterval().nanos()) {
                    this.lastRunNS = System.nanoTime();
                    reroute = true;
                    explanation = "one or more nodes has gone under the high or low watermark";
                    this.nodeHasPassedWatermark.remove(node);
                    continue;
                }
                this.logger.debug("{} has gone below a disk threshold, but an automatic reroute has occurred in the last [{}], skipping reroute", (Object)node, (Object)this.diskThresholdSettings.getRerouteInterval());
            }
            if (reroute) {
                this.logger.info("rerouting shards: [{}]", (Object)explanation);
                this.client.admin().cluster().prepareReroute().execute();
            }
        }
    }
}

