/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk.byscroll;

import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.byscroll.AbstractAsyncBulkByScrollAction;
import org.elasticsearch.action.bulk.byscroll.BulkByScrollResponse;
import org.elasticsearch.action.bulk.byscroll.DeleteByQueryRequest;
import org.elasticsearch.action.bulk.byscroll.ScrollableHitSource;
import org.elasticsearch.action.bulk.byscroll.WorkingBulkByScrollTask;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.client.ParentTaskAssigningClient;
import org.elasticsearch.cluster.ClusterState;
import org.elasticsearch.log4j.Logger;
import org.elasticsearch.script.ScriptService;
import org.elasticsearch.threadpool.ThreadPool;

public class AsyncDeleteByQueryAction
extends AbstractAsyncBulkByScrollAction<DeleteByQueryRequest> {
    public AsyncDeleteByQueryAction(WorkingBulkByScrollTask task, Logger logger, ParentTaskAssigningClient client, ThreadPool threadPool, DeleteByQueryRequest request, ScriptService scriptService, ClusterState clusterState, ActionListener<BulkByScrollResponse> listener) {
        super(task, logger, client, threadPool, request, scriptService, clusterState, listener);
    }

    @Override
    protected boolean needsSourceDocumentVersions() {
        return true;
    }

    @Override
    protected boolean accept(ScrollableHitSource.Hit doc) {
        return true;
    }

    @Override
    protected AbstractAsyncBulkByScrollAction.RequestWrapper<DeleteRequest> buildRequest(ScrollableHitSource.Hit doc) {
        DeleteRequest delete = new DeleteRequest();
        delete.index(doc.getIndex());
        delete.type(doc.getType());
        delete.id(doc.getId());
        delete.version(doc.getVersion());
        return AsyncDeleteByQueryAction.wrap(delete);
    }

    @Override
    protected AbstractAsyncBulkByScrollAction.RequestWrapper<?> copyMetadata(AbstractAsyncBulkByScrollAction.RequestWrapper<?> request, ScrollableHitSource.Hit doc) {
        request.setParent(doc.getParent());
        request.setRouting(doc.getRouting());
        return request;
    }
}

