/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.io.IOException;
import java.util.Map;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.DocWriteRequest;
import org.elasticsearch.action.DocWriteResponse;
import org.elasticsearch.action.bulk.BulkAction;
import org.elasticsearch.action.bulk.BulkItemRequest;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkShardRequest;
import org.elasticsearch.action.bulk.BulkShardResponse;
import org.elasticsearch.action.delete.DeleteRequest;
import org.elasticsearch.action.delete.DeleteResponse;
import org.elasticsearch.action.index.IndexRequest;
import org.elasticsearch.action.index.IndexResponse;
import org.elasticsearch.action.support.ActionFilters;
import org.elasticsearch.action.support.TransportActions;
import org.elasticsearch.action.support.replication.ReplicationOperation;
import org.elasticsearch.action.support.replication.ReplicationResponse;
import org.elasticsearch.action.support.replication.TransportReplicationAction;
import org.elasticsearch.action.support.replication.TransportWriteAction;
import org.elasticsearch.action.update.UpdateHelper;
import org.elasticsearch.action.update.UpdateRequest;
import org.elasticsearch.action.update.UpdateResponse;
import org.elasticsearch.cluster.action.index.MappingUpdatedAction;
import org.elasticsearch.cluster.action.shard.ShardStateAction;
import org.elasticsearch.cluster.metadata.IndexMetaData;
import org.elasticsearch.cluster.metadata.IndexNameExpressionResolver;
import org.elasticsearch.cluster.metadata.MappingMetaData;
import org.elasticsearch.cluster.service.ClusterService;
import org.elasticsearch.common.bytes.BytesReference;
import org.elasticsearch.common.collect.Tuple;
import org.elasticsearch.common.inject.Inject;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.xcontent.XContentHelper;
import org.elasticsearch.common.xcontent.XContentType;
import org.elasticsearch.index.VersionType;
import org.elasticsearch.index.engine.Engine;
import org.elasticsearch.index.engine.VersionConflictEngineException;
import org.elasticsearch.index.mapper.MapperParsingException;
import org.elasticsearch.index.mapper.Mapping;
import org.elasticsearch.index.mapper.SourceToParse;
import org.elasticsearch.index.shard.IndexShard;
import org.elasticsearch.index.shard.ShardId;
import org.elasticsearch.index.translog.Translog;
import org.elasticsearch.indices.IndicesService;
import org.elasticsearch.log4j.message.ParameterizedMessage;
import org.elasticsearch.threadpool.ThreadPool;
import org.elasticsearch.transport.TransportRequestOptions;
import org.elasticsearch.transport.TransportService;

public class TransportShardBulkAction
extends TransportWriteAction<BulkShardRequest, BulkShardRequest, BulkShardResponse> {
    public static final String ACTION_NAME = "indices:data/write/bulk[s]";
    private final UpdateHelper updateHelper;
    private final boolean allowIdGeneration;
    private final MappingUpdatedAction mappingUpdatedAction;

    @Inject
    public TransportShardBulkAction(Settings settings, TransportService transportService, ClusterService clusterService, IndicesService indicesService, ThreadPool threadPool, ShardStateAction shardStateAction, MappingUpdatedAction mappingUpdatedAction, UpdateHelper updateHelper, ActionFilters actionFilters, IndexNameExpressionResolver indexNameExpressionResolver) {
        super(settings, ACTION_NAME, transportService, clusterService, indicesService, threadPool, shardStateAction, actionFilters, indexNameExpressionResolver, BulkShardRequest::new, BulkShardRequest::new, "bulk");
        this.updateHelper = updateHelper;
        this.allowIdGeneration = settings.getAsBoolean("action.allow_id_generation", true);
        this.mappingUpdatedAction = mappingUpdatedAction;
    }

    @Override
    protected TransportRequestOptions transportOptions() {
        return BulkAction.INSTANCE.transportOptions(this.settings);
    }

    @Override
    protected BulkShardResponse newResponseInstance() {
        return new BulkShardResponse();
    }

    @Override
    protected boolean resolveIndex() {
        return false;
    }

    @Override
    public TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse> shardOperationOnPrimary(BulkShardRequest request, IndexShard primary) throws Exception {
        IndexMetaData metaData = primary.indexSettings().getIndexMetaData();
        long[] preVersions = new long[request.items().length];
        VersionType[] preVersionTypes = new VersionType[request.items().length];
        Translog.Location location = null;
        for (int requestIndex = 0; requestIndex < request.items().length; ++requestIndex) {
            location = this.executeBulkItemRequest(metaData, primary, request, preVersions, preVersionTypes, location, requestIndex);
        }
        BulkItemResponse[] responses = new BulkItemResponse[request.items().length];
        BulkItemRequest[] items = request.items();
        for (int i = 0; i < items.length; ++i) {
            responses[i] = items[i].getPrimaryResponse();
        }
        BulkShardResponse response = new BulkShardResponse(request.shardId(), responses);
        return new TransportWriteAction.WritePrimaryResult<BulkShardRequest, BulkShardResponse>(request, response, location, null, primary, this.logger);
    }

    private Translog.Location executeBulkItemRequest(IndexMetaData metaData, IndexShard primary, BulkShardRequest request, long[] preVersions, VersionType[] preVersionTypes, Translog.Location location, int requestIndex) throws Exception {
        DocWriteRequest itemRequest = request.items()[requestIndex].request();
        preVersions[requestIndex] = itemRequest.version();
        preVersionTypes[requestIndex] = itemRequest.versionType();
        DocWriteRequest.OpType opType = itemRequest.opType();
        try {
            BulkItemRequest replicaRequest;
            Engine.Result operationResult;
            DocWriteResponse response;
            switch (itemRequest.opType()) {
                case CREATE: 
                case INDEX: {
                    IndexRequest indexRequest = (IndexRequest)itemRequest;
                    Engine.IndexResult indexResult = TransportShardBulkAction.executeIndexRequestOnPrimary(indexRequest, primary, this.mappingUpdatedAction);
                    if (indexResult.hasFailure()) {
                        response = null;
                    } else {
                        long version = indexResult.getVersion();
                        indexRequest.version(version);
                        indexRequest.versionType(indexRequest.versionType().versionTypeForReplicationAndRecovery());
                        assert (indexRequest.versionType().validateVersionForWrites(indexRequest.version()));
                        response = new IndexResponse(primary.shardId(), indexRequest.type(), indexRequest.id(), indexResult.getVersion(), indexResult.isCreated());
                    }
                    operationResult = indexResult;
                    replicaRequest = request.items()[requestIndex];
                    break;
                }
                case UPDATE: {
                    UpdateResultHolder updateResultHolder = this.executeUpdateRequest((UpdateRequest)itemRequest, primary, metaData, request, requestIndex);
                    operationResult = updateResultHolder.operationResult;
                    response = updateResultHolder.response;
                    replicaRequest = updateResultHolder.replicaRequest;
                    break;
                }
                case DELETE: {
                    DeleteRequest deleteRequest = (DeleteRequest)itemRequest;
                    Engine.DeleteResult deleteResult = TransportShardBulkAction.executeDeleteRequestOnPrimary(deleteRequest, primary);
                    if (deleteResult.hasFailure()) {
                        response = null;
                    } else {
                        deleteRequest.versionType(deleteRequest.versionType().versionTypeForReplicationAndRecovery());
                        deleteRequest.version(deleteResult.getVersion());
                        assert (deleteRequest.versionType().validateVersionForWrites(deleteRequest.version()));
                        response = new DeleteResponse(request.shardId(), deleteRequest.type(), deleteRequest.id(), deleteResult.getVersion(), deleteResult.isFound());
                    }
                    operationResult = deleteResult;
                    replicaRequest = request.items()[requestIndex];
                    break;
                }
                default: {
                    throw new IllegalStateException("unexpected opType [" + (Object)((Object)itemRequest.opType()) + "] found");
                }
            }
            request.items()[requestIndex] = replicaRequest;
            if (operationResult == null) {
                assert (response.getResult() == DocWriteResponse.Result.NOOP) : "only noop update can have null operation";
                replicaRequest.setIgnoreOnReplica();
                replicaRequest.setPrimaryResponse(new BulkItemResponse(replicaRequest.id(), opType, response));
            } else if (!operationResult.hasFailure()) {
                location = this.locationToSync(location, operationResult.getTranslogLocation());
                BulkItemResponse primaryResponse = new BulkItemResponse(replicaRequest.id(), opType, response);
                replicaRequest.setPrimaryResponse(primaryResponse);
                ((ReplicationResponse)primaryResponse.getResponse()).setShardInfo(new ReplicationResponse.ShardInfo());
            } else {
                DocWriteRequest docWriteRequest = replicaRequest.request();
                Exception failure = operationResult.getFailure();
                if (TransportShardBulkAction.isConflictException(failure)) {
                    this.logger.trace(() -> new ParameterizedMessage("{} failed to execute bulk item ({}) {}", request.shardId(), docWriteRequest.opType().getLowercase(), request), (Throwable)failure);
                } else {
                    this.logger.debug(() -> new ParameterizedMessage("{} failed to execute bulk item ({}) {}", request.shardId(), docWriteRequest.opType().getLowercase(), request), (Throwable)failure);
                }
                if (replicaRequest.getPrimaryResponse() == null || !TransportShardBulkAction.isConflictException(failure)) {
                    replicaRequest.setIgnoreOnReplica();
                    replicaRequest.setPrimaryResponse(new BulkItemResponse(replicaRequest.id(), docWriteRequest.opType(), new BulkItemResponse.Failure(request.index(), docWriteRequest.type(), docWriteRequest.id(), failure)));
                }
            }
            assert (replicaRequest.getPrimaryResponse() != null);
            assert (preVersionTypes[requestIndex] != null);
        }
        catch (Exception e) {
            if (this.retryPrimaryException(e)) {
                for (int j = 0; j < requestIndex; ++j) {
                    DocWriteRequest docWriteRequest = request.items()[j].request();
                    docWriteRequest.version(preVersions[j]);
                    docWriteRequest.versionType(preVersionTypes[j]);
                }
            }
            throw e;
        }
        return location;
    }

    private static boolean isConflictException(Exception e) {
        return ExceptionsHelper.unwrapCause(e) instanceof VersionConflictEngineException;
    }

    private UpdateResultHolder executeUpdateRequest(UpdateRequest updateRequest, IndexShard primary, IndexMetaData metaData, BulkShardRequest request, int requestIndex) throws Exception {
        Engine.Result updateOperationResult = null;
        UpdateResponse updateResponse = null;
        BulkItemRequest replicaRequest = request.items()[requestIndex];
        int maxAttempts = updateRequest.retryOnConflict();
        block11: for (int attemptCount = 0; attemptCount <= maxAttempts; ++attemptCount) {
            UpdateHelper.Result translate;
            try {
                translate = this.updateHelper.prepare(updateRequest, primary, this.threadPool::absoluteTimeInMillis);
            }
            catch (Exception failure) {
                updateOperationResult = new Engine.IndexResult(failure, updateRequest.version());
                break;
            }
            switch (translate.getResponseResult()) {
                case CREATED: 
                case UPDATED: {
                    IndexRequest indexRequest = (IndexRequest)translate.action();
                    MappingMetaData mappingMd = metaData.mappingOrDefault(indexRequest.type());
                    indexRequest.process(mappingMd, this.allowIdGeneration, request.index());
                    updateOperationResult = TransportShardBulkAction.executeIndexRequestOnPrimary(indexRequest, primary, this.mappingUpdatedAction);
                    if (updateOperationResult.hasFailure()) break;
                    long version = updateOperationResult.getVersion();
                    indexRequest.version(version);
                    indexRequest.versionType(indexRequest.versionType().versionTypeForReplicationAndRecovery());
                    assert (indexRequest.versionType().validateVersionForWrites(indexRequest.version()));
                    break;
                }
                case DELETED: {
                    DeleteRequest deleteRequest = (DeleteRequest)translate.action();
                    updateOperationResult = TransportShardBulkAction.executeDeleteRequestOnPrimary(deleteRequest, primary);
                    if (updateOperationResult.hasFailure()) break;
                    deleteRequest.versionType(deleteRequest.versionType().versionTypeForReplicationAndRecovery());
                    deleteRequest.version(updateOperationResult.getVersion());
                    assert (deleteRequest.versionType().validateVersionForWrites(deleteRequest.version()));
                    break;
                }
                case NOOP: {
                    primary.noopUpdate(updateRequest.type());
                    break;
                }
                default: {
                    throw new IllegalStateException("Illegal update operation " + translate.getResponseResult());
                }
            }
            if (updateOperationResult == null) {
                updateResponse = (UpdateResponse)translate.action();
                break;
            }
            if (!updateOperationResult.hasFailure()) {
                switch (updateOperationResult.getOperationType()) {
                    case INDEX: {
                        IndexRequest updateIndexRequest = (IndexRequest)translate.action();
                        IndexResponse indexResponse = new IndexResponse(primary.shardId(), updateIndexRequest.type(), updateIndexRequest.id(), updateOperationResult.getVersion(), ((Engine.IndexResult)updateOperationResult).isCreated());
                        BytesReference indexSourceAsBytes = updateIndexRequest.source();
                        updateResponse = new UpdateResponse(indexResponse.getShardInfo(), indexResponse.getShardId(), indexResponse.getType(), indexResponse.getId(), indexResponse.getVersion(), indexResponse.getResult());
                        if (updateRequest.fetchSource() != null && updateRequest.fetchSource().fetchSource() || updateRequest.fields() != null && updateRequest.fields().length > 0) {
                            Tuple<XContentType, Map<String, Object>> sourceAndContent = XContentHelper.convertToMap(indexSourceAsBytes, true, updateIndexRequest.getContentType());
                            updateResponse.setGetResult(this.updateHelper.extractGetResult(updateRequest, request.index(), indexResponse.getVersion(), sourceAndContent.v2(), sourceAndContent.v1(), indexSourceAsBytes));
                        }
                        replicaRequest = new BulkItemRequest(request.items()[requestIndex].id(), updateIndexRequest);
                        break block11;
                    }
                    case DELETE: {
                        DeleteRequest updateDeleteRequest = (DeleteRequest)translate.action();
                        DeleteResponse deleteResponse = new DeleteResponse(primary.shardId(), updateDeleteRequest.type(), updateDeleteRequest.id(), updateOperationResult.getVersion(), ((Engine.DeleteResult)updateOperationResult).isFound());
                        updateResponse = new UpdateResponse(deleteResponse.getShardInfo(), deleteResponse.getShardId(), deleteResponse.getType(), deleteResponse.getId(), deleteResponse.getVersion(), deleteResponse.getResult());
                        updateResponse.setGetResult(this.updateHelper.extractGetResult(updateRequest, request.index(), deleteResponse.getVersion(), translate.updatedSourceAsMap(), translate.updateSourceContentType(), null));
                        replicaRequest = new BulkItemRequest(request.items()[requestIndex].id(), updateDeleteRequest);
                        break block11;
                    }
                    default: {
                        throw new IllegalStateException("Illegal update operation " + updateOperationResult.getOperationType().getLowercase());
                    }
                }
            }
            if (!(updateOperationResult.getFailure() instanceof VersionConflictEngineException)) break;
        }
        return new UpdateResultHolder(replicaRequest, updateOperationResult, updateResponse);
    }

    @Override
    public TransportWriteAction.WriteReplicaResult<BulkShardRequest> shardOperationOnReplica(BulkShardRequest request, IndexShard replica) throws Exception {
        Translog.Location location = null;
        for (int i = 0; i < request.items().length; ++i) {
            BulkItemRequest item = request.items()[i];
            if (item.isIgnoreOnReplica()) continue;
            DocWriteRequest docWriteRequest = item.request();
            try {
                Engine.Result operationResult;
                switch (docWriteRequest.opType()) {
                    case CREATE: 
                    case INDEX: {
                        operationResult = TransportShardBulkAction.executeIndexRequestOnReplica((IndexRequest)docWriteRequest, replica);
                        break;
                    }
                    case DELETE: {
                        operationResult = TransportShardBulkAction.executeDeleteRequestOnReplica((DeleteRequest)docWriteRequest, replica);
                        break;
                    }
                    default: {
                        throw new IllegalStateException("Unexpected request operation type on replica: " + docWriteRequest.opType().getLowercase());
                    }
                }
                if (operationResult.hasFailure()) {
                    Exception failure = operationResult.getFailure();
                    assert (failure instanceof VersionConflictEngineException || failure instanceof MapperParsingException) : "expected version conflict or mapper parsing failures";
                    if (TransportActions.isShardNotAvailableException(failure)) continue;
                    throw failure;
                }
                location = this.locationToSync(location, operationResult.getTranslogLocation());
                continue;
            }
            catch (Exception e) {
                if (TransportActions.isShardNotAvailableException(e)) continue;
                throw e;
            }
        }
        return new TransportWriteAction.WriteReplicaResult<BulkShardRequest>(request, location, null, replica, this.logger);
    }

    private Translog.Location locationToSync(Translog.Location current, Translog.Location next) {
        assert (next != null) : "next operation can't be null";
        assert (current == null || current.compareTo(next) < 0) : "translog locations are not increasing";
        return next;
    }

    public static Engine.IndexResult executeIndexRequestOnReplica(IndexRequest request, IndexShard replica) throws IOException {
        Engine.Index operation;
        ShardId shardId = replica.shardId();
        SourceToParse sourceToParse = SourceToParse.source(SourceToParse.Origin.REPLICA, shardId.getIndexName(), request.type(), request.id(), request.source(), request.getContentType()).routing(request.routing()).parent(request.parent()).timestamp(request.timestamp()).ttl(request.ttl());
        try {
            operation = replica.prepareIndexOnReplica(sourceToParse, request.version(), request.versionType(), request.getAutoGeneratedTimestamp(), request.isRetry());
        }
        catch (MapperParsingException e) {
            return new Engine.IndexResult(e, request.version());
        }
        Mapping update = operation.parsedDoc().dynamicMappingsUpdate();
        if (update != null) {
            throw new TransportReplicationAction.RetryOnReplicaException(shardId, "Mappings are not available on the replica yet, triggered update: " + update);
        }
        return replica.index(operation);
    }

    static Engine.Index prepareIndexOperationOnPrimary(IndexRequest request, IndexShard primary) {
        SourceToParse sourceToParse = SourceToParse.source(SourceToParse.Origin.PRIMARY, request.index(), request.type(), request.id(), request.source(), request.getContentType()).routing(request.routing()).parent(request.parent()).timestamp(request.timestamp()).ttl(request.ttl());
        return primary.prepareIndexOnPrimary(sourceToParse, request.version(), request.versionType(), request.getAutoGeneratedTimestamp(), request.isRetry());
    }

    public static Engine.IndexResult executeIndexRequestOnPrimary(IndexRequest request, IndexShard primary, MappingUpdatedAction mappingUpdatedAction) throws Exception {
        Engine.Index operation;
        try {
            operation = TransportShardBulkAction.prepareIndexOperationOnPrimary(request, primary);
        }
        catch (IllegalArgumentException | MapperParsingException e) {
            return new Engine.IndexResult(e, request.version());
        }
        Mapping update = operation.parsedDoc().dynamicMappingsUpdate();
        ShardId shardId = primary.shardId();
        if (update != null) {
            try {
                mappingUpdatedAction.updateMappingOnMaster(shardId.getIndex(), request.type(), update);
            }
            catch (IllegalArgumentException e) {
                return new Engine.IndexResult(e, request.version());
            }
            try {
                operation = TransportShardBulkAction.prepareIndexOperationOnPrimary(request, primary);
            }
            catch (IllegalArgumentException | MapperParsingException e) {
                return new Engine.IndexResult(e, request.version());
            }
            update = operation.parsedDoc().dynamicMappingsUpdate();
            if (update != null) {
                throw new ReplicationOperation.RetryOnPrimaryException(shardId, "Dynamic mappings are not available on the node that holds the primary yet");
            }
        }
        return primary.index(operation);
    }

    public static Engine.DeleteResult executeDeleteRequestOnPrimary(DeleteRequest request, IndexShard primary) throws IOException {
        Engine.Delete delete = primary.prepareDeleteOnPrimary(request.type(), request.id(), request.version(), request.versionType());
        return primary.delete(delete);
    }

    public static Engine.DeleteResult executeDeleteRequestOnReplica(DeleteRequest request, IndexShard replica) throws IOException {
        Engine.Delete delete = replica.prepareDeleteOnReplica(request.type(), request.id(), request.version(), request.versionType());
        return replica.delete(delete);
    }

    private static class UpdateResultHolder {
        final BulkItemRequest replicaRequest;
        final Engine.Result operationResult;
        final DocWriteResponse response;

        private UpdateResultHolder(BulkItemRequest replicaRequest, Engine.Result operationResult, DocWriteResponse response) {
            this.replicaRequest = replicaRequest;
            this.operationResult = operationResult;
            this.response = response;
        }
    }
}

