/*
 * Decompiled with CFR 0.152.
 */
package org.elasticsearch.action.bulk;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.concurrent.ScheduledFuture;
import java.util.function.Predicate;
import org.elasticsearch.ExceptionsHelper;
import org.elasticsearch.action.ActionFuture;
import org.elasticsearch.action.ActionListener;
import org.elasticsearch.action.bulk.BackoffPolicy;
import org.elasticsearch.action.bulk.BulkItemResponse;
import org.elasticsearch.action.bulk.BulkRequest;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.action.support.PlainActionFuture;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.logging.Loggers;
import org.elasticsearch.common.unit.TimeValue;
import org.elasticsearch.common.util.concurrent.FutureUtils;
import org.elasticsearch.log4j.Logger;

public class Retry {
    private final Class<? extends Throwable> retryOnThrowable;
    private BackoffPolicy backoffPolicy;

    public static Retry on(Class<? extends Throwable> retryOnThrowable) {
        return new Retry(retryOnThrowable);
    }

    public Retry policy(BackoffPolicy backoffPolicy) {
        this.backoffPolicy = backoffPolicy;
        return this;
    }

    Retry(Class<? extends Throwable> retryOnThrowable) {
        this.retryOnThrowable = retryOnThrowable;
    }

    public void withAsyncBackoff(Client client, BulkRequest bulkRequest, ActionListener<BulkResponse> listener) {
        AsyncRetryHandler r = new AsyncRetryHandler(this.retryOnThrowable, this.backoffPolicy, client, listener);
        r.execute(bulkRequest);
    }

    public BulkResponse withSyncBackoff(Client client, BulkRequest bulkRequest) throws Exception {
        return SyncRetryHandler.create(this.retryOnThrowable, this.backoffPolicy, client).executeBlocking(bulkRequest).actionGet();
    }

    static class SyncRetryHandler
    extends AbstractRetryHandler {
        private final PlainActionFuture<BulkResponse> actionFuture;

        public static SyncRetryHandler create(Class<? extends Throwable> retryOnThrowable, BackoffPolicy backoffPolicy, Client client) {
            PlainActionFuture<BulkResponse> actionFuture = PlainActionFuture.newFuture();
            return new SyncRetryHandler(retryOnThrowable, backoffPolicy, client, actionFuture);
        }

        SyncRetryHandler(Class<? extends Throwable> retryOnThrowable, BackoffPolicy backoffPolicy, Client client, PlainActionFuture<BulkResponse> actionFuture) {
            super(retryOnThrowable, backoffPolicy, client, actionFuture);
            this.actionFuture = actionFuture;
        }

        public ActionFuture<BulkResponse> executeBlocking(BulkRequest bulkRequest) {
            super.execute(bulkRequest);
            return this.actionFuture;
        }
    }

    static class AsyncRetryHandler
    extends AbstractRetryHandler {
        AsyncRetryHandler(Class<? extends Throwable> retryOnThrowable, BackoffPolicy backoffPolicy, Client client, ActionListener<BulkResponse> listener) {
            super(retryOnThrowable, backoffPolicy, client, listener);
        }
    }

    static class AbstractRetryHandler
    implements ActionListener<BulkResponse> {
        private final Logger logger;
        private final Client client;
        private final ActionListener<BulkResponse> listener;
        private final Iterator<TimeValue> backoff;
        private final Class<? extends Throwable> retryOnThrowable;
        private final List<BulkItemResponse> responses = new ArrayList<BulkItemResponse>();
        private final long startTimestampNanos;
        private volatile BulkRequest currentBulkRequest;
        private volatile ScheduledFuture<?> scheduledRequestFuture;

        AbstractRetryHandler(Class<? extends Throwable> retryOnThrowable, BackoffPolicy backoffPolicy, Client client, ActionListener<BulkResponse> listener) {
            this.retryOnThrowable = retryOnThrowable;
            this.backoff = backoffPolicy.iterator();
            this.client = client;
            this.listener = listener;
            this.logger = Loggers.getLogger(this.getClass(), client.settings(), new String[0]);
            this.startTimestampNanos = System.nanoTime();
        }

        @Override
        public void onResponse(BulkResponse bulkItemResponses) {
            if (!bulkItemResponses.hasFailures()) {
                this.addResponses(bulkItemResponses, r -> true);
                this.finishHim();
            } else if (this.canRetry(bulkItemResponses)) {
                this.addResponses(bulkItemResponses, r -> !r.isFailed());
                this.retry(this.createBulkRequestForRetry(bulkItemResponses));
            } else {
                this.addResponses(bulkItemResponses, r -> true);
                this.finishHim();
            }
        }

        @Override
        public void onFailure(Exception e) {
            try {
                this.listener.onFailure(e);
            }
            finally {
                FutureUtils.cancel(this.scheduledRequestFuture);
            }
        }

        private void retry(BulkRequest bulkRequestForRetry) {
            assert (this.backoff.hasNext());
            TimeValue next = this.backoff.next();
            this.logger.trace("Retry of bulk request scheduled in {} ms.", (Object)next.millis());
            Runnable retry = () -> this.execute(bulkRequestForRetry);
            retry = this.client.threadPool().getThreadContext().preserveContext(retry);
            this.scheduledRequestFuture = this.client.threadPool().schedule(next, "same", retry);
        }

        private BulkRequest createBulkRequestForRetry(BulkResponse bulkItemResponses) {
            BulkRequest requestToReissue = new BulkRequest();
            int index = 0;
            for (BulkItemResponse bulkItemResponse : bulkItemResponses.getItems()) {
                if (bulkItemResponse.isFailed()) {
                    requestToReissue.add(this.currentBulkRequest.requests().get(index));
                }
                ++index;
            }
            return requestToReissue;
        }

        private boolean canRetry(BulkResponse bulkItemResponses) {
            if (!this.backoff.hasNext()) {
                return false;
            }
            for (BulkItemResponse bulkItemResponse : bulkItemResponses) {
                Exception cause;
                Throwable rootCause;
                if (!bulkItemResponse.isFailed() || (rootCause = ExceptionsHelper.unwrapCause(cause = bulkItemResponse.getFailure().getCause())).getClass().equals(this.retryOnThrowable)) continue;
                return false;
            }
            return true;
        }

        private void finishHim() {
            try {
                this.listener.onResponse(this.getAccumulatedResponse());
            }
            finally {
                FutureUtils.cancel(this.scheduledRequestFuture);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void addResponses(BulkResponse response, Predicate<BulkItemResponse> filter) {
            for (BulkItemResponse bulkItemResponse : response) {
                if (!filter.test(bulkItemResponse)) continue;
                List<BulkItemResponse> list = this.responses;
                synchronized (list) {
                    this.responses.add(bulkItemResponse);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private BulkResponse getAccumulatedResponse() {
            BulkItemResponse[] itemResponses;
            List<BulkItemResponse> list = this.responses;
            synchronized (list) {
                itemResponses = this.responses.toArray(new BulkItemResponse[1]);
            }
            long stopTimestamp = System.nanoTime();
            long totalLatencyMs = TimeValue.timeValueNanos(stopTimestamp - this.startTimestampNanos).millis();
            return new BulkResponse(itemResponses, totalLatencyMs);
        }

        public void execute(BulkRequest bulkRequest) {
            this.currentBulkRequest = bulkRequest;
            this.client.bulk(bulkRequest, this);
        }
    }
}

