/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Map;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.queries.function.FunctionValues;
import org.apache.lucene.queries.function.ValueSource;
import org.apache.lucene.queries.function.docvalues.BoolDocValues;
import org.apache.lucene.search.Explanation;
import org.apache.lucene.search.IndexSearcher;
import org.apache.lucene.spatial.query.SpatialOperation;
import org.locationtech.spatial4j.shape.Shape;

public class ShapePredicateValueSource
extends ValueSource {
    private final ValueSource shapeValuesource;
    private final SpatialOperation op;
    private final Shape queryShape;

    public ShapePredicateValueSource(ValueSource shapeValuesource, SpatialOperation op, Shape queryShape) {
        this.shapeValuesource = shapeValuesource;
        this.op = op;
        this.queryShape = queryShape;
    }

    @Override
    public String description() {
        return this.shapeValuesource + " " + this.op + " " + this.queryShape;
    }

    @Override
    public void createWeight(Map context, IndexSearcher searcher) throws IOException {
        this.shapeValuesource.createWeight(context, searcher);
    }

    @Override
    public FunctionValues getValues(Map context, LeafReaderContext readerContext) throws IOException {
        final FunctionValues shapeValues = this.shapeValuesource.getValues(context, readerContext);
        return new BoolDocValues(this){

            @Override
            public boolean boolVal(int doc) {
                Shape indexedShape = (Shape)shapeValues.objectVal(doc);
                if (indexedShape == null) {
                    return false;
                }
                return ShapePredicateValueSource.this.op.evaluate(indexedShape, ShapePredicateValueSource.this.queryShape);
            }

            @Override
            public Explanation explain(int doc) {
                Explanation exp = super.explain(doc);
                ArrayList<Explanation> details = new ArrayList<Explanation>(Arrays.asList(exp.getDetails()));
                details.add(shapeValues.explain(doc));
                return Explanation.match(exp.getValue(), exp.getDescription(), details);
            }
        };
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ShapePredicateValueSource that = (ShapePredicateValueSource)o;
        if (!this.shapeValuesource.equals(that.shapeValuesource)) {
            return false;
        }
        if (!this.op.equals(that.op)) {
            return false;
        }
        return this.queryShape.equals((Object)that.queryShape);
    }

    @Override
    public int hashCode() {
        int result = this.shapeValuesource.hashCode();
        result = 31 * result + this.op.hashCode();
        result = 31 * result + this.queryShape.hashCode();
        return result;
    }
}

