/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.spatial.geopoint.search;

import org.apache.lucene.geo.GeoUtils;
import org.apache.lucene.index.IndexReader;
import org.apache.lucene.search.BooleanClause;
import org.apache.lucene.search.BooleanQuery;
import org.apache.lucene.search.FieldValueQuery;
import org.apache.lucene.search.Query;
import org.apache.lucene.spatial.geopoint.document.GeoPointField;
import org.apache.lucene.spatial.geopoint.search.GeoPointInBBoxQueryImpl;

public class GeoPointInBBoxQuery
extends Query {
    protected final String field;
    protected final double minLat;
    protected final double minLon;
    protected final double maxLat;
    protected final double maxLon;
    protected final GeoPointField.TermEncoding termEncoding;

    public GeoPointInBBoxQuery(String field, double minLat, double maxLat, double minLon, double maxLon) {
        this(field, GeoPointField.TermEncoding.PREFIX, minLat, maxLat, minLon, maxLon);
    }

    public GeoPointInBBoxQuery(String field, GeoPointField.TermEncoding termEncoding, double minLat, double maxLat, double minLon, double maxLon) {
        if (field == null) {
            throw new IllegalArgumentException("field must not be null");
        }
        if (termEncoding == null) {
            throw new IllegalArgumentException("termEncoding must not be null");
        }
        GeoUtils.checkLatitude(minLat);
        GeoUtils.checkLatitude(maxLat);
        GeoUtils.checkLongitude(minLon);
        GeoUtils.checkLongitude(maxLon);
        this.field = field;
        this.minLat = minLat;
        this.maxLat = maxLat;
        this.minLon = minLon;
        this.maxLon = maxLon;
        this.termEncoding = termEncoding;
    }

    @Override
    public Query rewrite(IndexReader reader) {
        if (this.minLat == -90.0 && this.maxLat == 90.0 && this.minLon == -180.0 && this.maxLon == 180.0) {
            return new FieldValueQuery(this.field);
        }
        if (this.maxLon < this.minLon) {
            BooleanQuery.Builder bqb = new BooleanQuery.Builder();
            GeoPointInBBoxQueryImpl left = new GeoPointInBBoxQueryImpl(this.field, this.termEncoding, this.minLat, this.maxLat, -180.0, this.maxLon);
            bqb.add(new BooleanClause(left, BooleanClause.Occur.SHOULD));
            GeoPointInBBoxQueryImpl right = new GeoPointInBBoxQueryImpl(this.field, this.termEncoding, this.minLat, this.maxLat, this.minLon, 180.0);
            bqb.add(new BooleanClause(right, BooleanClause.Occur.SHOULD));
            return bqb.build();
        }
        return new GeoPointInBBoxQueryImpl(this.field, this.termEncoding, this.minLat, this.maxLat, this.minLon, this.maxLon);
    }

    @Override
    public String toString(String field) {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append(':');
        if (!this.field.equals(field)) {
            sb.append(" field=");
            sb.append(this.field);
            sb.append(':');
        }
        return sb.append(" Lower Left: [").append(this.minLat).append(',').append(this.minLon).append(']').append(" Upper Right: [").append(this.maxLat).append(',').append(this.maxLon).append("]").toString();
    }

    @Override
    public boolean equals(Object other) {
        return this.sameClassAs(other) && this.equalsTo((GeoPointInBBoxQuery)this.getClass().cast(other));
    }

    private boolean equalsTo(GeoPointInBBoxQuery other) {
        return Double.compare(other.minLat, this.minLat) == 0 && Double.compare(other.maxLat, this.maxLat) == 0 && Double.compare(other.minLon, this.minLon) == 0 && Double.compare(other.maxLon, this.maxLon) == 0 && this.field.equals(other.field);
    }

    @Override
    public int hashCode() {
        int result = this.classHash();
        result = 31 * result + this.field.hashCode();
        long temp = Double.doubleToLongBits(this.minLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLat);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.minLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.maxLon);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public final String getField() {
        return this.field;
    }

    public final double getMinLat() {
        return this.minLat;
    }

    public final double getMaxLat() {
        return this.maxLat;
    }

    public final double getMinLon() {
        return this.minLon;
    }

    public final double getMaxLon() {
        return this.maxLon;
    }
}

