/*
 * Decompiled with CFR 0.152.
 */
package org.apache.lucene.search;

import java.io.IOException;
import org.apache.lucene.index.LeafReaderContext;
import org.apache.lucene.search.Collector;
import org.apache.lucene.search.DocValuesStats;
import org.apache.lucene.search.LeafCollector;
import org.apache.lucene.search.Scorer;

public class DocValuesStatsCollector
implements Collector {
    private final DocValuesStats<?> stats;

    public DocValuesStatsCollector(DocValuesStats<?> stats) {
        this.stats = stats;
    }

    @Override
    public LeafCollector getLeafCollector(LeafReaderContext context) throws IOException {
        boolean shouldProcess = this.stats.init(context);
        if (!shouldProcess) {
            return new LeafCollector(){

                @Override
                public void setScorer(Scorer scorer) throws IOException {
                }

                @Override
                public void collect(int doc) throws IOException {
                    DocValuesStatsCollector.this.stats.addMissing();
                }
            };
        }
        return new LeafCollector(){

            @Override
            public void setScorer(Scorer scorer) throws IOException {
            }

            @Override
            public void collect(int doc) throws IOException {
                DocValuesStatsCollector.this.stats.accumulate(doc);
            }
        };
    }

    @Override
    public boolean needsScores() {
        return false;
    }
}

