/*
 * Decompiled with CFR 0.152.
 */
package com.uber.autodispose.android;

import android.os.Build;
import android.view.View;
import androidx.annotation.RestrictTo;
import com.uber.autodispose.OutsideScopeException;
import com.uber.autodispose.android.internal.AutoDisposeAndroidUtil;
import io.reactivex.CompletableObserver;
import io.reactivex.CompletableSource;
import io.reactivex.android.MainThreadDisposable;
import io.reactivex.disposables.Disposable;

@RestrictTo(value={RestrictTo.Scope.LIBRARY})
final class DetachEventCompletable
implements CompletableSource {
    private final View view;

    DetachEventCompletable(View view) {
        this.view = view;
    }

    public void subscribe(CompletableObserver observer) {
        boolean isAttached;
        Listener listener = new Listener(this.view, observer);
        observer.onSubscribe((Disposable)listener);
        if (!AutoDisposeAndroidUtil.isMainThread()) {
            observer.onError((Throwable)new IllegalStateException("Views can only be bound to on the main thread!"));
            return;
        }
        boolean bl = isAttached = Build.VERSION.SDK_INT >= 19 && this.view.isAttachedToWindow() || this.view.getWindowToken() != null;
        if (!isAttached) {
            observer.onError((Throwable)new OutsideScopeException("View is not attached!"));
            return;
        }
        this.view.addOnAttachStateChangeListener((View.OnAttachStateChangeListener)listener);
        if (listener.isDisposed()) {
            this.view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)listener);
        }
    }

    static final class Listener
    extends MainThreadDisposable
    implements View.OnAttachStateChangeListener {
        private final View view;
        private final CompletableObserver observer;

        Listener(View view, CompletableObserver observer) {
            this.view = view;
            this.observer = observer;
        }

        public void onViewAttachedToWindow(View v) {
        }

        public void onViewDetachedFromWindow(View v) {
            if (!this.isDisposed()) {
                this.observer.onComplete();
            }
        }

        protected void onDispose() {
            this.view.removeOnAttachStateChangeListener((View.OnAttachStateChangeListener)this);
        }
    }
}

