/*
 * Decompiled with CFR 0.152.
 */
package com.twolight.android.loader.transformation;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.os.Build;
import android.renderscript.RSRuntimeException;
import android.support.annotation.NonNull;
import com.bumptech.glide.Glide;
import com.bumptech.glide.load.Transformation;
import com.bumptech.glide.load.engine.Resource;
import com.bumptech.glide.load.engine.bitmap_recycle.BitmapPool;
import com.bumptech.glide.load.resource.bitmap.BitmapResource;
import com.bumptech.glide.util.Util;
import com.twolight.android.loader.blur.FastBlur;
import com.twolight.android.loader.blur.RSBlur;
import java.nio.ByteBuffer;
import java.security.MessageDigest;

public class BlurTransformation
implements Transformation<Bitmap> {
    private static int MAX_RADIUS = 25;
    private static int DEFAULT_DOWN_SAMPLING = 1;
    private static final String ID = "BlurTransformation";
    private static final byte[] ID_BYTES = "BlurTransformation".getBytes(CHARSET);
    private Context mContext;
    private BitmapPool mBitmapPool;
    private int mRadius;
    private int mSampling;

    public BlurTransformation(Context context) {
        this(context, Glide.get((Context)context).getBitmapPool(), MAX_RADIUS, DEFAULT_DOWN_SAMPLING);
    }

    public BlurTransformation(Context context, BitmapPool pool) {
        this(context, pool, MAX_RADIUS, DEFAULT_DOWN_SAMPLING);
    }

    public BlurTransformation(Context context, BitmapPool pool, int radius) {
        this(context, pool, radius, DEFAULT_DOWN_SAMPLING);
    }

    public BlurTransformation(Context context, int radius) {
        this(context, Glide.get((Context)context).getBitmapPool(), radius, DEFAULT_DOWN_SAMPLING);
    }

    public BlurTransformation(Context context, int radius, int sampling) {
        this(context, Glide.get((Context)context).getBitmapPool(), radius, sampling);
    }

    public BlurTransformation(Context context, BitmapPool pool, int radius, int sampling) {
        this.mContext = context.getApplicationContext();
        this.mBitmapPool = pool;
        this.mRadius = radius;
        this.mSampling = sampling;
    }

    @NonNull
    public Resource<Bitmap> transform(@NonNull Context context, @NonNull Resource<Bitmap> resource, int outWidth, int outHeight) {
        int height;
        int scaledHeight;
        Bitmap source = (Bitmap)resource.get();
        int width = source.getWidth();
        int scaledWidth = width / this.mSampling;
        Bitmap bitmap = this.mBitmapPool.get(scaledWidth, scaledHeight = (height = source.getHeight()) / this.mSampling, Bitmap.Config.ARGB_8888);
        if (bitmap == null) {
            bitmap = Bitmap.createBitmap((int)scaledWidth, (int)scaledHeight, (Bitmap.Config)Bitmap.Config.ARGB_8888);
        }
        Canvas canvas = new Canvas(bitmap);
        canvas.scale(1.0f / (float)this.mSampling, 1.0f / (float)this.mSampling);
        Paint paint = new Paint();
        paint.setFlags(2);
        canvas.drawBitmap(source, 0.0f, 0.0f, paint);
        if (Build.VERSION.SDK_INT >= 18) {
            try {
                bitmap = RSBlur.blur(this.mContext, bitmap, this.mRadius);
            }
            catch (RSRuntimeException e) {
                bitmap = FastBlur.blur(bitmap, this.mRadius, true);
            }
        } else {
            bitmap = FastBlur.blur(bitmap, this.mRadius, true);
        }
        return BitmapResource.obtain((Bitmap)bitmap, (BitmapPool)this.mBitmapPool);
    }

    public boolean equals(Object obj) {
        if (obj instanceof BlurTransformation) {
            BlurTransformation other = (BlurTransformation)obj;
            return this.mRadius == other.mRadius && this.mSampling == other.mSampling;
        }
        return false;
    }

    public int hashCode() {
        return Util.hashCode((int)Util.hashCode((int)ID.hashCode(), (int)Util.hashCode((int)this.mRadius)), (int)Util.hashCode((int)this.mSampling));
    }

    public void updateDiskCacheKey(@NonNull MessageDigest messageDigest) {
        messageDigest.digest(ID_BYTES);
        byte[] buffer = ByteBuffer.allocate(8).putInt(this.mRadius).putInt(this.mSampling).array();
        messageDigest.digest(buffer);
    }
}

