/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.security;

import com.twitter.util.Try;
import com.twitter.util.security.Pkcs8EncodedKeySpecFile;
import com.twitter.util.security.Pkcs8KeyManagerFactory$;
import com.twitter.util.security.X509CertificateFile;
import java.io.File;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.Seq;
import scala.runtime.ScalaRunTime$;
import scala.runtime.function.JProcedure1;

public class Pkcs8KeyManagerFactory {
    private final File certsFile;
    private final File keyFile;

    public static KeyStore createKeyStore(Seq<X509Certificate> seq, PrivateKey privateKey) {
        return Pkcs8KeyManagerFactory$.MODULE$.createKeyStore(seq, privateKey);
    }

    public static PrivateKey keySpecToPrivateKey(PKCS8EncodedKeySpec pKCS8EncodedKeySpec) {
        return Pkcs8KeyManagerFactory$.MODULE$.keySpecToPrivateKey(pKCS8EncodedKeySpec);
    }

    public static KeyManagerFactory keyStoreToKeyManagerFactory(KeyStore keyStore) {
        return Pkcs8KeyManagerFactory$.MODULE$.keyStoreToKeyManagerFactory(keyStore);
    }

    public Pkcs8KeyManagerFactory(File certsFile, File keyFile) {
        this.certsFile = certsFile;
        this.keyFile = keyFile;
    }

    private void logException(Throwable ex) {
        Pkcs8KeyManagerFactory$.com$twitter$util$security$Pkcs8KeyManagerFactory$$$log.warning("Pkcs8KeyManagerFactory (" + this.certsFile.getName() + ", " + this.keyFile.getName() + ") " + ("failed to create key manager: " + ex.getMessage() + "."), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public Try<KeyManager[]> getKeyManagers() {
        Try<Seq<X509Certificate>> tryCerts = new X509CertificateFile(this.certsFile).readX509Certificates();
        Try<PKCS8EncodedKeySpec> tryKeySpec = new Pkcs8EncodedKeySpecFile(this.keyFile).readPkcs8EncodedKeySpec();
        Try tryPrivateKey = tryKeySpec.map((Function1 & Serializable)keySpec -> Pkcs8KeyManagerFactory$.MODULE$.keySpecToPrivateKey((PKCS8EncodedKeySpec)keySpec));
        Try tryCertsKey = Pkcs8KeyManagerFactory$.MODULE$.com$twitter$util$security$Pkcs8KeyManagerFactory$$$join(tryCerts, tryPrivateKey);
        Try tryKeyStore = tryCertsKey.map(((Function2 & Serializable)(Function2 & Serializable)(certs, privateKey) -> Pkcs8KeyManagerFactory$.MODULE$.createKeyStore((Seq<X509Certificate>)certs, (PrivateKey)privateKey)).tupled());
        return tryKeyStore.map((Function1 & Serializable)_$1 -> Pkcs8KeyManagerFactory$.MODULE$.keyStoreToKeyManagerFactory((KeyStore)_$1).getKeyManagers()).onFailure((Function1)(JProcedure1 & Serializable)ex -> this.logException((Throwable)ex));
    }
}

