/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.security;

import com.twitter.util.Try;
import com.twitter.util.security.Pkcs8EncodedKeySpecFile;
import com.twitter.util.security.Pkcs8KeyManagerFactory$;
import com.twitter.util.security.X509CertificateFile;
import java.io.File;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u00055c\u0001B\b\u0011\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tS\u0001\u0011\t\u0011)A\u0005C!)!\u0006\u0001C\u0001W!1\u0001\u0007\u0001Q\u0005\nEBQa\u0011\u0001\u0005\u0002\u0011;QA\u0016\t\t\u0002]3Qa\u0004\t\t\u0002aCQAK\u0004\u0005\u0002eCqAW\u0004C\u0002\u0013%1\f\u0003\u0004c\u000f\u0001\u0006I\u0001\u0018\u0005\u0006G\u001e!I\u0001\u001a\u0005\u0006}\u001e!\ta \u0005\b\u000379A\u0011AA\u000f\u0011\u001d\tyc\u0002C\u0001\u0003c\u0011a\u0003U6dgbZU-_'b]\u0006<WM\u001d$bGR|'/\u001f\u0006\u0003#I\t\u0001b]3dkJLG/\u001f\u0006\u0003'Q\tA!\u001e;jY*\u0011QCF\u0001\bi^LG\u000f^3s\u0015\u00059\u0012aA2p[\u000e\u00011C\u0001\u0001\u001b!\tYb$D\u0001\u001d\u0015\u0005i\u0012!B:dC2\f\u0017BA\u0010\u001d\u0005\u0019\te.\u001f*fM\u0006I1-\u001a:ug\u001aKG.\u001a\t\u0003E\u001dj\u0011a\t\u0006\u0003I\u0015\n!![8\u000b\u0003\u0019\nAA[1wC&\u0011\u0001f\t\u0002\u0005\r&dW-A\u0004lKf4\u0015\u000e\\3\u0002\rqJg.\u001b;?)\racf\f\t\u0003[\u0001i\u0011\u0001\u0005\u0005\u0006A\r\u0001\r!\t\u0005\u0006S\r\u0001\r!I\u0001\rY><W\t_2faRLwN\u001c\u000b\u0003eU\u0002\"aG\u001a\n\u0005Qb\"\u0001B+oSRDQA\u000e\u0003A\u0002]\n!!\u001a=\u0011\u0005a\u0002eBA\u001d?\u001d\tQT(D\u0001<\u0015\ta\u0004$\u0001\u0004=e>|GOP\u0005\u0002;%\u0011q\bH\u0001\ba\u0006\u001c7.Y4f\u0013\t\t%IA\u0005UQJ|w/\u00192mK*\u0011q\bH\u0001\u000fO\u0016$8*Z=NC:\fw-\u001a:t)\u0005)\u0005c\u0001$H\u00136\t!#\u0003\u0002I%\t\u0019AK]=\u0011\u0007mQE*\u0003\u0002L9\t)\u0011I\u001d:bsB\u0011Q\nV\u0007\u0002\u001d*\u0011q\nU\u0001\u0004gNd'BA)S\u0003\rqW\r\u001e\u0006\u0002'\u0006)!.\u0019<bq&\u0011QK\u0014\u0002\u000b\u0017\u0016LX*\u00198bO\u0016\u0014\u0018A\u0006)lGND4*Z=NC:\fw-\u001a:GC\u000e$xN]=\u0011\u00055:1CA\u0004\u001b)\u00059\u0016a\u00017pOV\tA\f\u0005\u0002^A6\taL\u0003\u0002`)\u00059An\\4hS:<\u0017BA1_\u0005\u0019aunZ4fe\u0006!An\\4!\u0003\u0011Qw.\u001b8\u0016\u0007\u0015dg\u000fF\u0002gqn\u00042AR$h!\u0011Y\u0002N[;\n\u0005%d\"A\u0002+va2,'\u0007\u0005\u0002lY2\u0001A!B7\f\u0005\u0004q'!A!\u0012\u0005=\u0014\bCA\u000eq\u0013\t\tHDA\u0004O_RD\u0017N\\4\u0011\u0005m\u0019\u0018B\u0001;\u001d\u0005\r\te.\u001f\t\u0003WZ$Qa^\u0006C\u00029\u0014\u0011A\u0011\u0005\u0006s.\u0001\rA_\u0001\u0005iJL\u0018\tE\u0002G\u000f*DQ\u0001`\u0006A\u0002u\fA\u0001\u001e:z\u0005B\u0019aiR;\u0002'-,\u0017p\u00159fGR{\u0007K]5wCR,7*Z=\u0015\t\u0005\u0005\u00111\u0002\t\u0005\u0003\u0007\t9!\u0004\u0002\u0002\u0006)\u0011\u0011#J\u0005\u0005\u0003\u0013\t)A\u0001\u0006Qe&4\u0018\r^3LKfDq!!\u0004\r\u0001\u0004\ty!A\u0004lKf\u001c\u0006/Z2\u0011\t\u0005E\u0011qC\u0007\u0003\u0003'QA!!\u0006\u0002\u0006\u0005!1\u000f]3d\u0013\u0011\tI\"a\u0005\u0003'A[5i\u0015\u001dF]\u000e|G-\u001a3LKf\u001c\u0006/Z2\u00027-,\u0017p\u0015;pe\u0016$vnS3z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z)\u0011\ty\"!\n\u0011\u00075\u000b\t#C\u0002\u0002$9\u0013\u0011cS3z\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z\u0011\u001d\t9#\u0004a\u0001\u0003S\t\u0001b[3z'R|'/\u001a\t\u0005\u0003\u0007\tY#\u0003\u0003\u0002.\u0005\u0015!\u0001C&fsN#xN]3\u0002\u001d\r\u0014X-\u0019;f\u0017\u0016L8\u000b^8sKR1\u0011\u0011FA\u001a\u0003\u0013Bq!!\u000e\u000f\u0001\u0004\t9$A\u0003dKJ$8\u000fE\u00039\u0003s\ti$C\u0002\u0002<\t\u00131aU3r!\u0011\ty$!\u0012\u000e\u0005\u0005\u0005#\u0002BA\"\u0003\u000b\tAaY3si&!\u0011qIA!\u0005=AV\u0007M\u001dDKJ$\u0018NZ5dCR,\u0007bBA&\u001d\u0001\u0007\u0011\u0011A\u0001\u000baJLg/\u0019;f\u0017\u0016L\b")
public class Pkcs8KeyManagerFactory {
    private final File certsFile;
    private final File keyFile;

    public static KeyStore createKeyStore(Seq<X509Certificate> seq, PrivateKey privateKey) {
        return Pkcs8KeyManagerFactory$.MODULE$.createKeyStore(seq, privateKey);
    }

    public static KeyManagerFactory keyStoreToKeyManagerFactory(KeyStore keyStore) {
        return Pkcs8KeyManagerFactory$.MODULE$.keyStoreToKeyManagerFactory(keyStore);
    }

    public static PrivateKey keySpecToPrivateKey(PKCS8EncodedKeySpec pKCS8EncodedKeySpec) {
        return Pkcs8KeyManagerFactory$.MODULE$.keySpecToPrivateKey(pKCS8EncodedKeySpec);
    }

    private void logException(Throwable ex) {
        Pkcs8KeyManagerFactory$.MODULE$.com$twitter$util$security$Pkcs8KeyManagerFactory$$log().warning(new StringBuilder(0).append(new StringBuilder(28).append("Pkcs8KeyManagerFactory (").append(this.certsFile.getName()).append(", ").append(this.keyFile.getName()).append(") ").toString()).append(new StringBuilder(31).append("failed to create key manager: ").append(ex.getMessage()).append(".").toString()).toString(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    public Try<KeyManager[]> getKeyManagers() {
        Try<Seq<X509Certificate>> tryCerts = new X509CertificateFile(this.certsFile).readX509Certificates();
        Try<PKCS8EncodedKeySpec> tryKeySpec = new Pkcs8EncodedKeySpecFile(this.keyFile).readPkcs8EncodedKeySpec();
        Try tryPrivateKey = tryKeySpec.map((Function1 & Serializable)keySpec -> Pkcs8KeyManagerFactory$.MODULE$.keySpecToPrivateKey((PKCS8EncodedKeySpec)keySpec));
        Try tryCertsKey = Pkcs8KeyManagerFactory$.MODULE$.com$twitter$util$security$Pkcs8KeyManagerFactory$$join(tryCerts, tryPrivateKey);
        Try tryKeyStore = tryCertsKey.map(((Function2 & Serializable)(Function2 & Serializable)(certs, privateKey) -> Pkcs8KeyManagerFactory$.MODULE$.createKeyStore((Seq<X509Certificate>)certs, (PrivateKey)privateKey)).tupled());
        return tryKeyStore.map((Function1 & Serializable)x$1 -> Pkcs8KeyManagerFactory$.MODULE$.keyStoreToKeyManagerFactory((KeyStore)x$1).getKeyManagers()).onFailure((Function1 & Serializable)ex -> {
            this.logException(ex);
            return BoxedUnit.UNIT;
        });
    }

    public Pkcs8KeyManagerFactory(File certsFile, File keyFile) {
        this.certsFile = certsFile;
        this.keyFile = keyFile;
    }
}

