/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.security;

import com.twitter.util.Try;
import com.twitter.util.security.X509CertificateFile;
import com.twitter.util.security.X509TrustManagerFactory$;
import java.io.File;
import java.io.Serializable;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import scala.Function1;
import scala.collection.immutable.Nil$;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0015a\u0001\u0002\b\u0010\u0001aA\u0001b\b\u0001\u0003\u0002\u0003\u0006I\u0001\t\u0005\u0006Q\u0001!\t!\u000b\u0005\u0007[\u0001\u0001K\u0011\u0002\u0018\t\u000b\u0001\u0003A\u0011A!\b\u000bM{\u0001\u0012\u0001+\u0007\u000b9y\u0001\u0012A+\t\u000b!2A\u0011\u0001,\t\u000f]3!\u0019!C\u00051\"1qL\u0002Q\u0001\neCa\u0001\u0019\u0004!\n\u0013\t\u0007\"B9\u0007\t\u0003\u0011\b\"\u0002=\u0007\t\u0003I\b\"\u0002@\u0007\t\u0003y(a\u0006-6ae\"&/^:u\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z\u0015\t\u0001\u0012#\u0001\u0005tK\u000e,(/\u001b;z\u0015\t\u00112#\u0001\u0003vi&d'B\u0001\u000b\u0016\u0003\u001d!x/\u001b;uKJT\u0011AF\u0001\u0004G>l7\u0001A\n\u0003\u0001e\u0001\"AG\u000f\u000e\u0003mQ\u0011\u0001H\u0001\u0006g\u000e\fG.Y\u0005\u0003=m\u0011a!\u00118z%\u00164\u0017!C2feR\u001ch)\u001b7f!\t\tc%D\u0001#\u0015\t\u0019C%\u0001\u0002j_*\tQ%\u0001\u0003kCZ\f\u0017BA\u0014#\u0005\u00111\u0015\u000e\\3\u0002\rqJg.\u001b;?)\tQC\u0006\u0005\u0002,\u00015\tq\u0002C\u0003 \u0005\u0001\u0007\u0001%\u0001\u0007m_\u001e,\u0005pY3qi&|g\u000e\u0006\u00020eA\u0011!\u0004M\u0005\u0003cm\u0011A!\u00168ji\")1g\u0001a\u0001i\u0005\u0011Q\r\u001f\t\u0003kur!AN\u001e\u000f\u0005]RT\"\u0001\u001d\u000b\u0005e:\u0012A\u0002\u001fs_>$h(C\u0001\u001d\u0013\ta4$A\u0004qC\u000e\\\u0017mZ3\n\u0005yz$!\u0003+ie><\u0018M\u00197f\u0015\ta4$\u0001\thKR$&/^:u\u001b\u0006t\u0017mZ3sgR\t!\tE\u0002D\t\u001ak\u0011!E\u0005\u0003\u000bF\u00111\u0001\u0016:z!\rQr)S\u0005\u0003\u0011n\u0011Q!\u0011:sCf\u0004\"AS)\u000e\u0003-S!\u0001T'\u0002\u0007M\u001cHN\u0003\u0002O\u001f\u0006\u0019a.\u001a;\u000b\u0003A\u000bQA[1wCbL!AU&\u0003\u0019Q\u0013Xo\u001d;NC:\fw-\u001a:\u0002/a+\u0004'\u000f+skN$X*\u00198bO\u0016\u0014h)Y2u_JL\bCA\u0016\u0007'\t1\u0011\u0004F\u0001U\u0003\rawnZ\u000b\u00023B\u0011!,X\u0007\u00027*\u0011AlE\u0001\bY><w-\u001b8h\u0013\tq6L\u0001\u0004M_\u001e<WM]\u0001\u0005Y><\u0007%A\ntKR\u001cUM\u001d;jM&\u001c\u0017\r^3F]R\u0014\u0018\u0010\u0006\u0002cWR\u0011qf\u0019\u0005\u0006I*\u0001\r!Z\u0001\u0005G\u0016\u0014H\u000f\u0005\u0002gS6\tqM\u0003\u0002eQ*\u0011\u0001\u0003J\u0005\u0003U\u001e\u0014q\u0002W\u001b1s\r+'\u000f^5gS\u000e\fG/\u001a\u0005\u0006Y*\u0001\r!\\\u0001\u0003WN\u0004\"A\\8\u000e\u0003!L!\u0001\u001d5\u0003\u0011-+\u0017p\u0015;pe\u0016\fqbY3siN$vnS3z'R|'/\u001a\u000b\u0003[NDQ\u0001^\u0006A\u0002U\fQaY3siN\u00042!\u000e<f\u0013\t9xHA\u0002TKF\f!dY3siN$v\u000e\u0016:vgRl\u0015M\\1hKJ4\u0015m\u0019;pef$\"A_?\u0011\u0005)[\u0018B\u0001?L\u0005M!&/^:u\u001b\u0006t\u0017mZ3s\r\u0006\u001cGo\u001c:z\u0011\u0015!H\u00021\u0001v\u0003E\u0011W/\u001b7e)J,8\u000f^'b]\u0006<WM\u001d\u000b\u0004\u0005\u0006\u0005\u0001BBA\u0002\u001b\u0001\u0007Q/\u0001\tykAJ4)\u001a:uS\u001aL7-\u0019;fg\u0002")
public class X509TrustManagerFactory {
    private final File certsFile;

    public static Try<TrustManager[]> buildTrustManager(Seq<X509Certificate> x509Certificates) {
        return X509TrustManagerFactory$.MODULE$.buildTrustManager(x509Certificates);
    }

    public static TrustManagerFactory certsToTrustManagerFactory(Seq<X509Certificate> certs) {
        return X509TrustManagerFactory$.MODULE$.certsToTrustManagerFactory(certs);
    }

    public static KeyStore certsToKeyStore(Seq<X509Certificate> certs) {
        return X509TrustManagerFactory$.MODULE$.certsToKeyStore(certs);
    }

    private void logException(Throwable ex) {
        X509TrustManagerFactory$.MODULE$.com$twitter$util$security$X509TrustManagerFactory$$log().warning(new StringBuilder(0).append(new StringBuilder(27).append("X509TrustManagerFactory (").append(this.certsFile.getName()).append(") ").toString()).append(new StringBuilder(33).append("failed to create trust manager: ").append(ex.getMessage()).append(".").toString()).toString(), (Seq)Nil$.MODULE$);
    }

    public Try<TrustManager[]> getTrustManagers() {
        Try<Seq<X509Certificate>> tryCerts = new X509CertificateFile(this.certsFile).readX509Certificates();
        return tryCerts.flatMap((Function1 & Serializable)x509Certificates -> X509TrustManagerFactory$.MODULE$.buildTrustManager((Seq<X509Certificate>)x509Certificates)).onFailure((Function1 & Serializable)ex -> {
            this.logException(ex);
            return BoxedUnit.UNIT;
        });
    }

    public X509TrustManagerFactory(File certsFile) {
        this.certsFile = certsFile;
    }
}

