/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.util.security;

import com.twitter.util.Try;
import com.twitter.util.security.Pkcs8EncodedKeySpecFile;
import com.twitter.util.security.Pkcs8KeyManagerFactory$;
import com.twitter.util.security.X509CertificateFile;
import java.io.File;
import java.io.Serializable;
import java.security.KeyFactory;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.security.spec.PKCS8EncodedKeySpec;
import java.util.UUID;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import scala.Function1;
import scala.Function2;
import scala.collection.immutable.Seq;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\u001dc\u0001B\b\u0011\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\tS\u0001\u0011\t\u0011)A\u0005C!)!\u0006\u0001C\u0001W!1\u0001\u0007\u0001Q\u0005\nEBaa\u0011\u0001!\n\u0013!\u0005B\u0002*\u0001A\u0013%1\u000b\u0003\u0004e\u0001\u0001&I!\u001a\u0005\u0006k\u0002!\tA^\u0004\u0006wBAI\u0001 \u0004\u0006\u001fAAI! \u0005\u0006U)!\tA \u0005\t\u007f*\u0011\r\u0011\"\u0003\u0002\u0002!A\u0011q\u0002\u0006!\u0002\u0013\t\u0019\u0001C\u0004\u0002\u0012)!I!a\u0005\u0003-A[7m\u001d\u001dLKfl\u0015M\\1hKJ4\u0015m\u0019;pefT!!\u0005\n\u0002\u0011M,7-\u001e:jifT!a\u0005\u000b\u0002\tU$\u0018\u000e\u001c\u0006\u0003+Y\tq\u0001^<jiR,'OC\u0001\u0018\u0003\r\u0019w.\\\u0002\u0001'\t\u0001!\u0004\u0005\u0002\u001c=5\tADC\u0001\u001e\u0003\u0015\u00198-\u00197b\u0013\tyBD\u0001\u0004B]f\u0014VMZ\u0001\nG\u0016\u0014Ho\u001d$jY\u0016\u0004\"AI\u0014\u000e\u0003\rR!\u0001J\u0013\u0002\u0005%|'\"\u0001\u0014\u0002\t)\fg/Y\u0005\u0003Q\r\u0012AAR5mK\u000691.Z=GS2,\u0017A\u0002\u001fj]&$h\bF\u0002-]=\u0002\"!\f\u0001\u000e\u0003AAQ\u0001I\u0002A\u0002\u0005BQ!K\u0002A\u0002\u0005\nA\u0002\\8h\u000bb\u001cW\r\u001d;j_:$\"AM\u001b\u0011\u0005m\u0019\u0014B\u0001\u001b\u001d\u0005\u0011)f.\u001b;\t\u000bY\"\u0001\u0019A\u001c\u0002\u0005\u0015D\bC\u0001\u001dA\u001d\tIdH\u0004\u0002;{5\t1H\u0003\u0002=1\u00051AH]8pizJ\u0011!H\u0005\u0003\u007fq\tq\u0001]1dW\u0006<W-\u0003\u0002B\u0005\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003\u007fq\t1c[3z'B,7\rV8Qe&4\u0018\r^3LKf$\"!\u0012&\u0011\u0005\u0019CU\"A$\u000b\u0005E)\u0013BA%H\u0005)\u0001&/\u001b<bi\u0016\\U-\u001f\u0005\u0006\u0017\u0016\u0001\r\u0001T\u0001\bW\u0016L8\u000b]3d!\ti\u0005+D\u0001O\u0015\tyu)\u0001\u0003ta\u0016\u001c\u0017BA)O\u0005M\u00016jQ*9\u000b:\u001cw\u000eZ3e\u0017\u0016L8\u000b]3d\u00039\u0019'/Z1uK.+\u0017p\u0015;pe\u0016$2\u0001V,c!\t1U+\u0003\u0002W\u000f\nA1*Z=Ti>\u0014X\rC\u0003Y\r\u0001\u0007\u0011,A\u0003dKJ$8\u000fE\u000295rK!a\u0017\"\u0003\u0007M+\u0017\u000f\u0005\u0002^A6\taL\u0003\u0002`\u000f\u0006!1-\u001a:u\u0013\t\tgLA\bYkAJ4)\u001a:uS\u001aL7-\u0019;f\u0011\u0015\u0019g\u00011\u0001F\u0003)\u0001(/\u001b<bi\u0016\\U-_\u0001\u0016W\u0016L8\u000b^8sKR{7*Z=NC:\fw-\u001a:t)\t17\u000fE\u0002\u001cO&L!\u0001\u001b\u000f\u0003\u000b\u0005\u0013(/Y=\u0011\u0005)\fX\"A6\u000b\u00051l\u0017aA:tY*\u0011an\\\u0001\u0004]\u0016$(\"\u00019\u0002\u000b)\fg/\u0019=\n\u0005I\\'AC&fs6\u000bg.Y4fe\")Ao\u0002a\u0001)\u0006A1.Z=Ti>\u0014X-\u0001\bhKR\\U-_'b]\u0006<WM]:\u0015\u0003]\u00042\u0001_=g\u001b\u0005\u0011\u0012B\u0001>\u0013\u0005\r!&/_\u0001\u0017!.\u001c7\u000fO&fs6\u000bg.Y4fe\u001a\u000b7\r^8ssB\u0011QFC\n\u0003\u0015i!\u0012\u0001`\u0001\u0004Y><WCAA\u0002!\u0011\t)!a\u0003\u000e\u0005\u0005\u001d!bAA\u0005)\u00059An\\4hS:<\u0017\u0002BA\u0007\u0003\u000f\u0011a\u0001T8hO\u0016\u0014\u0018\u0001\u00027pO\u0002\nAA[8j]V1\u0011QCA\u0012\u0003o!b!a\u0006\u0002<\u0005\u0005\u0003\u0003\u0002=z\u00033\u0001raGA\u000e\u0003?\t)$C\u0002\u0002\u001eq\u0011a\u0001V;qY\u0016\u0014\u0004\u0003BA\u0011\u0003Ga\u0001\u0001B\u0004\u0002&9\u0011\r!a\n\u0003\u0003\u0005\u000bB!!\u000b\u00020A\u00191$a\u000b\n\u0007\u00055BDA\u0004O_RD\u0017N\\4\u0011\u0007m\t\t$C\u0002\u00024q\u00111!\u00118z!\u0011\t\t#a\u000e\u0005\u000f\u0005ebB1\u0001\u0002(\t\t!\tC\u0004\u0002>9\u0001\r!a\u0010\u0002\tQ\u0014\u00180\u0011\t\u0005qf\fy\u0002C\u0004\u0002D9\u0001\r!!\u0012\u0002\tQ\u0014\u0018P\u0011\t\u0005qf\f)\u0004")
public class Pkcs8KeyManagerFactory {
    private final File certsFile;
    private final File keyFile;

    private void logException(Throwable ex) {
        Pkcs8KeyManagerFactory$.MODULE$.com$twitter$util$security$Pkcs8KeyManagerFactory$$log().warning(new StringBuilder(0).append(new StringBuilder(28).append("Pkcs8KeyManagerFactory (").append(this.certsFile.getName()).append(", ").append(this.keyFile.getName()).append(") ").toString()).append(new StringBuilder(31).append("failed to create key manager: ").append(ex.getMessage()).append(".").toString()).toString(), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[0]));
    }

    private PrivateKey keySpecToPrivateKey(PKCS8EncodedKeySpec keySpec) {
        KeyFactory kf = KeyFactory.getInstance("RSA");
        return kf.generatePrivate(keySpec);
    }

    private KeyStore createKeyStore(Seq<X509Certificate> certs, PrivateKey privateKey) {
        String alias = UUID.randomUUID().toString();
        KeyStore ks = KeyStore.getInstance("JKS");
        ks.load(null);
        ks.setKeyEntry(alias, privateKey, "".toCharArray(), (Certificate[])certs.toArray(ClassTag$.MODULE$.apply(Certificate.class)));
        return ks;
    }

    private KeyManager[] keyStoreToKeyManagers(KeyStore keyStore) {
        KeyManagerFactory kmf = KeyManagerFactory.getInstance("SunX509");
        kmf.init(keyStore, "".toCharArray());
        return kmf.getKeyManagers();
    }

    public Try<KeyManager[]> getKeyManagers() {
        Try<Seq<X509Certificate>> tryCerts = new X509CertificateFile(this.certsFile).readX509Certificates();
        Try<PKCS8EncodedKeySpec> tryKeySpec = new Pkcs8EncodedKeySpecFile(this.keyFile).readPkcs8EncodedKeySpec();
        Try tryPrivateKey = tryKeySpec.map((Function1 & Serializable)keySpec -> this.keySpecToPrivateKey((PKCS8EncodedKeySpec)keySpec));
        Try tryCertsKey = Pkcs8KeyManagerFactory$.MODULE$.com$twitter$util$security$Pkcs8KeyManagerFactory$$join(tryCerts, tryPrivateKey);
        Try tryKeyStore = tryCertsKey.map(((Function2 & Serializable)(Function2 & Serializable)(certs, privateKey) -> this.createKeyStore((Seq<X509Certificate>)certs, (PrivateKey)privateKey)).tupled());
        return tryKeyStore.map((Function1 & Serializable)keyStore -> this.keyStoreToKeyManagers((KeyStore)keyStore)).onFailure((Function1 & Serializable)ex -> {
            this.logException(ex);
            return BoxedUnit.UNIT;
        });
    }

    public Pkcs8KeyManagerFactory(File certsFile, File keyFile) {
        this.certsFile = certsFile;
        this.keyFile = keyFile;
    }
}

