/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.logging;

import com.twitter.logging.Handler;
import com.twitter.logging.LazyLogRecordUnformatted;
import com.twitter.logging.ProxyHandler;
import com.twitter.logging.ThrottledHandler$;
import com.twitter.util.Duration;
import com.twitter.util.Time;
import com.twitter.util.Time$;
import java.io.Serializable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import scala.Function0;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.StringOps$;
import scala.collection.immutable.Seq;
import scala.jdk.CollectionConverters$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005=v!\u0002\u0012$\u0011\u0003Qc!\u0002\u0017$\u0011\u0003i\u0003\"\u0002\u001b\u0002\t\u0003)\u0004\"\u0002\u001c\u0002\t\u00039\u0004\"CAG\u0003E\u0005I\u0011AAH\u0011%\t)+AI\u0001\n\u0003\t9\u000b\u0003\u0005\u0002,\u0006\u0011\r\u0011\"\u0003G\u0011\u001d\ti+\u0001Q\u0001\n\u001d3A\u0001L\u0012\u0001y!I\u0001\t\u0003B\u0001B\u0003%\u0011\t\u0012\u0005\t\u000b\"\u0011)\u0019!C\u0001\r\"AQ\n\u0003B\u0001B\u0003%q\t\u0003\u0005O\u0011\t\u0015\r\u0011\"\u0001P\u0011!\u0019\u0006B!A!\u0002\u0013\u0001\u0006\"\u0002\u001b\t\t\u0003!f\u0001\u0002-\t\teC\u0001BW\b\u0003\u0002\u0003\u0006Ia\u0017\u0005\t=>\u0011\t\u0011)A\u0005?\"A!n\u0004B\u0001B\u0003%1\u000eC\u00035\u001f\u0011\u00051\u000f\u0003\u0004z\u001f\u0001\u0006KA\u001f\u0005\t\u0003\u0007y\u0001\u0015!\u0003\u0002\u0006!9\u0011QC\b\u0005B\u0005]\u0001bBA\r\u001f\u0011\u0015\u00111\u0004\u0005\b\u0003WyAQAA\u0017\u0011!\t\td\u0004Q\u0005\n\u0005M\u0002\"CA\u001e\u0011\t\u0007I\u0011BA\u001f\u0011!\t)\u0005\u0003Q\u0001\n\u0005}\u0002\"CA$\u0011\t\u0007I\u0011BA%\u0011!\t\u0019\u0006\u0003Q\u0001\n\u0005-\u0003bBA+\u0011\u0011\u0005\u00111\u0007\u0005\b\u0003WBA\u0011AA\u001a\u0011\u001d\ti\u0007\u0003C!\u0003_Bq!a\u001d\t\t\u0013\t)(\u0001\tUQJ|G\u000f\u001e7fI\"\u000bg\u000e\u001a7fe*\u0011A%J\u0001\bY><w-\u001b8h\u0015\t1s%A\u0004uo&$H/\u001a:\u000b\u0003!\n1aY8n\u0007\u0001\u0001\"aK\u0001\u000e\u0003\r\u0012\u0001\u0003\u00165s_R$H.\u001a3IC:$G.\u001a:\u0014\u0005\u0005q\u0003CA\u00183\u001b\u0005\u0001$\"A\u0019\u0002\u000bM\u001c\u0017\r\\1\n\u0005M\u0002$AB!osJ+g-\u0001\u0004=S:LGO\u0010\u000b\u0002U\u0005)\u0011\r\u001d9msR9\u0001(!\u001f\u0002\n\u0006-\u0005cA\u0018:w%\u0011!\b\r\u0002\n\rVt7\r^5p]B\u0002\"a\u000b\u0005\u0014\u0005!i\u0004CA\u0016?\u0013\ty4E\u0001\u0007Qe>D\u0018\u0010S1oI2,'/A\u0004iC:$G.\u001a:\u0011\u0005-\u0012\u0015BA\"$\u0005\u001dA\u0015M\u001c3mKJL!\u0001\u0011 \u0002\u0011\u0011,(/\u0019;j_:,\u0012a\u0012\t\u0003\u0011.k\u0011!\u0013\u0006\u0003\u0015\u0016\nA!\u001e;jY&\u0011A*\u0013\u0002\t\tV\u0014\u0018\r^5p]\u0006IA-\u001e:bi&|g\u000eI\u0001\r[\u0006DHk\u001c#jgBd\u0017-_\u000b\u0002!B\u0011q&U\u0005\u0003%B\u00121!\u00138u\u00035i\u0017\r\u001f+p\t&\u001c\b\u000f\\1zAQ!1(\u0016,X\u0011\u0015\u0001e\u00021\u0001B\u0011\u0015)e\u00021\u0001H\u0011\u0015qe\u00021\u0001Q\u0005!!\u0006N]8ui2,7CA\b/\u0003%\u0019H/\u0019:u)&lW\r\u0005\u0002I9&\u0011Q,\u0013\u0002\u0005)&lW-\u0001\u0003oC6,\u0007C\u00011h\u001d\t\tW\r\u0005\u0002ca5\t1M\u0003\u0002eS\u00051AH]8pizJ!A\u001a\u0019\u0002\rA\u0013X\rZ3g\u0013\tA\u0017N\u0001\u0004TiJLgn\u001a\u0006\u0003MB\nQ\u0001\\3wK2\u0004\"\u0001\\9\u000e\u00035T!\u0001\n8\u000b\u0005){'\"\u00019\u0002\t)\fg/Y\u0005\u0003e6\u0014Q\u0001T3wK2$B\u0001\u001e<xqB\u0011QoD\u0007\u0002\u0011!)!l\u0005a\u00017\")al\u0005a\u0001?\")!n\u0005a\u0001W\u00069Q\r\u001f9je\u0016$\u0007CA\u0018|\u0013\ta\bGA\u0004C_>dW-\u00198)\u0005Qq\bCA\u0018\u0000\u0013\r\t\t\u0001\r\u0002\tm>d\u0017\r^5mK\u0006)1m\\;oiB!\u0011qAA\t\u001b\t\tIA\u0003\u0003\u0002\f\u00055\u0011AB1u_6L7MC\u0002\u0002\u00109\f!bY8oGV\u0014(/\u001a8u\u0013\u0011\t\u0019\"!\u0003\u0003\u001b\u0005#x.\\5d\u0013:$XmZ3s\u0003!!xn\u0015;sS:<G#A0\u0002\u0007\u0005$G\rF\u0003{\u0003;\t9\u0003C\u0004\u0002 ]\u0001\r!!\t\u0002\rI,7m\u001c:e!\ra\u00171E\u0005\u0004\u0003Ki'!\u0003'pOJ+7m\u001c:e\u0011\u0019\tIc\u0006a\u00017\u0006\u0019an\\<\u0002\u001fI,Wn\u001c<f\u0013\u001a,\u0005\u0010]5sK\u0012$2A_A\u0018\u0011\u0019\tI\u0003\u0007a\u00017\u0006\u0001\u0002/\u001e2mSND7k^1mY><X\r\u001a\u000b\u0003\u0003k\u00012aLA\u001c\u0013\r\tI\u0004\r\u0002\u0005+:LG/\u0001\bmCN$h\t\\;tQ\u000eCWmY6\u0016\u0005\u0005}\u0002#BA\u0004\u0003\u0003Z\u0016\u0002BA\"\u0003\u0013\u0011q\"\u0011;p[&\u001c'+\u001a4fe\u0016t7-Z\u0001\u0010Y\u0006\u001cHO\u00127vg\"\u001c\u0005.Z2lA\u0005YA\u000f\u001b:piRdW-T1q+\t\tY\u0005\u0005\u0004\u0002N\u0005=s\f^\u0007\u0003\u0003\u001bIA!!\u0015\u0002\u000e\t\t2i\u001c8dkJ\u0014XM\u001c;ICNDW*\u00199\u0002\u0019QD'o\u001c;uY\u0016l\u0015\r\u001d\u0011\u0002\u000bI,7/\u001a;)\u0017y\tI&a\u0018\u0002b\u0005\u0015\u0014q\r\t\u0004_\u0005m\u0013bAA/a\tQA-\u001a9sK\u000e\fG/\u001a3\u0002\u000f5,7o]1hK\u0006\u0012\u00111M\u0001\u001d+N,\u0007E\u001a7vg\"$\u0006N]8ui2,G\rK\u0015!S:\u001cH/Z1e\u0003\u0015\u0019\u0018N\\2fC\t\tI'\u0001\u00046]Mr\u0013gM\u0001\u000fM2,8\u000f\u001b+ie>$H\u000f\\3e\u0003\u001d\u0001XO\u00197jg\"$B!!\u000e\u0002r!9\u0011q\u0004\u0011A\u0002\u0005\u0005\u0012!\u00033p!V\u0014G.[:i)\u0011\t)$a\u001e\t\u000f\u0005}\u0011\u00051\u0001\u0002\"!1\u0001i\u0001a\u0001\u0003w\u0002B!! \u0002\u0004:\u00191&a \n\u0007\u0005\u00055%A\u0004qC\u000e\\\u0017mZ3\n\t\u0005\u0015\u0015q\u0011\u0002\u000f\u0011\u0006tG\r\\3s\r\u0006\u001cGo\u001c:z\u0015\r\t\ti\t\u0005\b\u000b\u000e\u0001\n\u00111\u0001H\u0011\u001dq5\u0001%AA\u0002A\u000bq\"\u00199qYf$C-\u001a4bk2$HEM\u000b\u0003\u0003#S3aRAJW\t\t)\n\u0005\u0003\u0002\u0018\u0006\u0005VBAAM\u0015\u0011\tY*!(\u0002\u0013Ut7\r[3dW\u0016$'bAAPa\u0005Q\u0011M\u001c8pi\u0006$\u0018n\u001c8\n\t\u0005\r\u0016\u0011\u0014\u0002\u0012k:\u001c\u0007.Z2lK\u00124\u0016M]5b]\u000e,\u0017aD1qa2LH\u0005Z3gCVdG\u000fJ\u001a\u0016\u0005\u0005%&f\u0001)\u0002\u0014\u0006IqJ\\3TK\u000e|g\u000eZ\u0001\u000b\u001f:,7+Z2p]\u0012\u0004\u0003")
public class ThrottledHandler
extends ProxyHandler {
    private final Duration duration;
    private final int maxToDisplay;
    private final AtomicReference<Time> lastFlushCheck;
    private final ConcurrentHashMap<String, Throttle> throttleMap;

    public static int apply$default$3() {
        return ThrottledHandler$.MODULE$.apply$default$3();
    }

    public static Duration apply$default$2() {
        return ThrottledHandler$.MODULE$.apply$default$2();
    }

    public static Function0<ThrottledHandler> apply(Function0<Handler> handler, Duration duration, int maxToDisplay) {
        return ThrottledHandler$.MODULE$.apply(handler, duration, maxToDisplay);
    }

    public Duration duration() {
        return this.duration;
    }

    public int maxToDisplay() {
        return this.maxToDisplay;
    }

    private AtomicReference<Time> lastFlushCheck() {
        return this.lastFlushCheck;
    }

    private ConcurrentHashMap<String, Throttle> throttleMap() {
        return this.throttleMap;
    }

    public void reset() {
        this.flushThrottled();
    }

    public void flushThrottled() {
        Time now = Time$.MODULE$.now();
        CollectionConverters$.MODULE$.ConcurrentMapHasAsScala(this.throttleMap()).asScala().retain((Function2 & Serializable)(x0$1, x1$1) -> BoxesRunTime.boxToBoolean((boolean)ThrottledHandler.$anonfun$flushThrottled$1(now, x0$1, x1$1)));
    }

    @Override
    public void publish(LogRecord record) {
        String string;
        LogRecord logRecord;
        Time last;
        Time now = Time$.MODULE$.now();
        if (now.$minus(last = this.lastFlushCheck().get()).$greater((Object)ThrottledHandler$.MODULE$.com$twitter$logging$ThrottledHandler$$OneSecond()) && this.lastFlushCheck().compareAndSet(last, now)) {
            this.flushThrottled();
        }
        if ((logRecord = record) instanceof LazyLogRecordUnformatted) {
            LazyLogRecordUnformatted lazyLogRecordUnformatted = (LazyLogRecordUnformatted)logRecord;
            string = lazyLogRecordUnformatted.preformatted();
        } else {
            string = record.getMessage();
        }
        String key = string;
        this.tryPublish$1(key, now, record);
    }

    public void com$twitter$logging$ThrottledHandler$$doPublish(LogRecord record) {
        super.publish(record);
    }

    public static final /* synthetic */ boolean $anonfun$flushThrottled$1(Time now$1, String x0$1, Throttle x1$1) {
        Tuple2 tuple2 = new Tuple2((Object)x0$1, (Object)x1$1);
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        Throttle throttle = (Throttle)tuple2._2();
        boolean bl = !throttle.removeIfExpired(now$1);
        return bl;
    }

    private final void tryPublish$1(String key$1, Time now$2, LogRecord record$1) {
        Throttle throttle;
        while (!(throttle = this.throttleMap().computeIfAbsent(key$1, new Function<String, Throttle>(this, now$2, record$1){
            private final /* synthetic */ ThrottledHandler $outer;
            private final Time now$2;
            private final LogRecord record$1;

            public <V> Function<V, Throttle> compose(Function<? super V, ? extends String> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<String, V> andThen(Function<? super Throttle, ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Throttle apply(String key) {
                return new Throttle(this.$outer, this.now$2, this.record$1.getLoggerName(), this.record$1.getLevel());
            }
            {
                if ($outer == null) {
                    throw null;
                }
                this.$outer = $outer;
                this.now$2 = now$2;
                this.record$1 = record$1;
            }
        })).add(record$1, now$2)) {
        }
    }

    public ThrottledHandler(Handler handler, Duration duration, int maxToDisplay) {
        this.duration = duration;
        this.maxToDisplay = maxToDisplay;
        super(handler);
        this.lastFlushCheck = new AtomicReference<Time>(Time$.MODULE$.epoch());
        this.throttleMap = new ConcurrentHashMap();
    }

    private class Throttle {
        private final Time startTime;
        private final String name;
        private final Level level;
        private volatile boolean expired;
        private final AtomicInteger count;
        public final /* synthetic */ ThrottledHandler $outer;

        public String toString() {
            return new StringBuilder(27).append("Throttle: startTime=").append(this.startTime).append(" count=").append(this.count.get()).toString();
        }

        public final boolean add(LogRecord record, Time now) {
            boolean bl;
            if (!this.expired) {
                if (this.count.incrementAndGet() <= this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().maxToDisplay()) {
                    this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().com$twitter$logging$ThrottledHandler$$doPublish(record);
                }
                bl = true;
            } else {
                bl = false;
            }
            return bl;
        }

        /*
         * WARNING - void declaration
         */
        public final boolean removeIfExpired(Time now) {
            void var2_2;
            block0: {
                boolean didExpire;
                this.expired = didExpire = now.$minus(this.startTime).$greater$eq((Object)this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().duration());
                if (!didExpire || this.count.get() <= this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().maxToDisplay()) break block0;
                this.publishSwallowed();
            }
            return (boolean)var2_2;
        }

        private void publishSwallowed() {
            LogRecord throttledRecord = new LogRecord(this.level, StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("(swallowed %d repeating messages)"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)(this.count.get() - this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().maxToDisplay()))})));
            throttledRecord.setLoggerName(this.name);
            this.com$twitter$logging$ThrottledHandler$Throttle$$$outer().com$twitter$logging$ThrottledHandler$$doPublish(throttledRecord);
        }

        public /* synthetic */ ThrottledHandler com$twitter$logging$ThrottledHandler$Throttle$$$outer() {
            return this.$outer;
        }

        public Throttle(ThrottledHandler $outer, Time startTime, String name, Level level) {
            this.startTime = startTime;
            this.name = name;
            this.level = level;
            if ($outer == null) {
                throw null;
            }
            this.$outer = $outer;
            this.expired = false;
            this.count = new AtomicInteger(0);
        }
    }
}

