/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Poll options for a Tweet with a poll. This is mutually exclusive from Media and Quote Tweet Id.")
public class TweetCreateRequestPoll {
    public static final String SERIALIZED_NAME_DURATION_MINUTES = "duration_minutes";
    @SerializedName(value="duration_minutes")
    private Integer durationMinutes;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private List<String> options = new ArrayList<String>();
    public static final String SERIALIZED_NAME_REPLY_SETTINGS = "reply_settings";
    @SerializedName(value="reply_settings")
    private ReplySettingsEnum replySettings;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public TweetCreateRequestPoll durationMinutes(Integer durationMinutes) {
        this.durationMinutes = durationMinutes;
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="Duration of the poll in minutes.")
    public Integer getDurationMinutes() {
        return this.durationMinutes;
    }

    public void setDurationMinutes(Integer durationMinutes) {
        this.durationMinutes = durationMinutes;
    }

    public TweetCreateRequestPoll options(List<String> options) {
        this.options = options;
        return this;
    }

    public TweetCreateRequestPoll addOptionsItem(String optionsItem) {
        this.options.add(optionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public List<String> getOptions() {
        return this.options;
    }

    public void setOptions(List<String> options) {
        this.options = options;
    }

    public TweetCreateRequestPoll replySettings(ReplySettingsEnum replySettings) {
        this.replySettings = replySettings;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="Settings to indicate who can reply to the Tweet.")
    public ReplySettingsEnum getReplySettings() {
        return this.replySettings;
    }

    public void setReplySettings(ReplySettingsEnum replySettings) {
        this.replySettings = replySettings;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TweetCreateRequestPoll tweetCreateRequestPoll = (TweetCreateRequestPoll)o;
        return Objects.equals(this.durationMinutes, tweetCreateRequestPoll.durationMinutes) && Objects.equals(this.options, tweetCreateRequestPoll.options) && Objects.equals((Object)this.replySettings, (Object)tweetCreateRequestPoll.replySettings);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.durationMinutes, this.options, this.replySettings});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class TweetCreateRequestPoll {\n");
        sb.append("    durationMinutes: ").append(this.toIndentedString(this.durationMinutes)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    replySettings: ").append(this.toIndentedString((Object)this.replySettings)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_OPTIONS) != null && !jsonObj.get(SERIALIZED_NAME_OPTIONS).isJsonArray()) {
            throw new IllegalArgumentException(String.format("Expected the field `options` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPTIONS).toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_REPLY_SETTINGS) != null && !jsonObj.get(SERIALIZED_NAME_REPLY_SETTINGS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `reply_settings` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_REPLY_SETTINGS).toString()));
        }
    }

    public static TweetCreateRequestPoll fromJson(String jsonString) throws IOException {
        return (TweetCreateRequestPoll)JSON.getGson().fromJson(jsonString, TweetCreateRequestPoll.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DURATION_MINUTES);
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_REPLY_SETTINGS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_DURATION_MINUTES);
        openapiRequiredFields.add(SERIALIZED_NAME_OPTIONS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!TweetCreateRequestPoll.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(TweetCreateRequestPoll.class));
            return new TypeAdapter<TweetCreateRequestPoll>(){

                public void write(JsonWriter out, TweetCreateRequestPoll value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public TweetCreateRequestPoll read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    TweetCreateRequestPoll.validateJsonObject(jsonObj);
                    return (TweetCreateRequestPoll)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum ReplySettingsEnum {
        FOLLOWING("following"),
        MENTIONEDUSERS("mentionedUsers");

        private String value;

        private ReplySettingsEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static ReplySettingsEnum fromValue(String value) {
            for (ReplySettingsEnum b : ReplySettingsEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<ReplySettingsEnum> {
            public void write(JsonWriter jsonWriter, ReplySettingsEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public ReplySettingsEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return ReplySettingsEnum.fromValue(value);
            }
        }
    }
}

