/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.clientlib.model;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.TypeAdapter;
import com.google.gson.TypeAdapterFactory;
import com.google.gson.annotations.JsonAdapter;
import com.google.gson.annotations.SerializedName;
import com.google.gson.reflect.TypeToken;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import com.twitter.clientlib.JSON;
import com.twitter.clientlib.model.PollOption;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.IOException;
import java.time.OffsetDateTime;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

@ApiModel(description="Represent a Poll attached to a Tweet.")
public class Poll {
    public static final String SERIALIZED_NAME_DURATION_MINUTES = "duration_minutes";
    @SerializedName(value="duration_minutes")
    private Integer durationMinutes;
    public static final String SERIALIZED_NAME_END_DATETIME = "end_datetime";
    @SerializedName(value="end_datetime")
    private OffsetDateTime endDatetime;
    public static final String SERIALIZED_NAME_ID = "id";
    @SerializedName(value="id")
    private String id;
    public static final String SERIALIZED_NAME_OPTIONS = "options";
    @SerializedName(value="options")
    private List<PollOption> options = new ArrayList<PollOption>();
    public static final String SERIALIZED_NAME_VOTING_STATUS = "voting_status";
    @SerializedName(value="voting_status")
    private VotingStatusEnum votingStatus;
    public static HashSet<String> openapiFields = new HashSet();
    public static HashSet<String> openapiRequiredFields;

    public Poll durationMinutes(Integer durationMinutes) {
        this.durationMinutes = durationMinutes;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public Integer getDurationMinutes() {
        return this.durationMinutes;
    }

    public void setDurationMinutes(Integer durationMinutes) {
        this.durationMinutes = durationMinutes;
    }

    public Poll endDatetime(OffsetDateTime endDatetime) {
        this.endDatetime = endDatetime;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public OffsetDateTime getEndDatetime() {
        return this.endDatetime;
    }

    public void setEndDatetime(OffsetDateTime endDatetime) {
        this.endDatetime = endDatetime;
    }

    public Poll id(String id) {
        this.id = id;
        return this;
    }

    @Nonnull
    @ApiModelProperty(example="1365059861688410112", required=true, value="Unique identifier of this poll.")
    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public Poll options(List<PollOption> options) {
        this.options = options;
        return this;
    }

    public Poll addOptionsItem(PollOption optionsItem) {
        this.options.add(optionsItem);
        return this;
    }

    @Nonnull
    @ApiModelProperty(required=true, value="")
    public List<PollOption> getOptions() {
        return this.options;
    }

    public void setOptions(List<PollOption> options) {
        this.options = options;
    }

    public Poll votingStatus(VotingStatusEnum votingStatus) {
        this.votingStatus = votingStatus;
        return this;
    }

    @Nullable
    @ApiModelProperty(value="")
    public VotingStatusEnum getVotingStatus() {
        return this.votingStatus;
    }

    public void setVotingStatus(VotingStatusEnum votingStatus) {
        this.votingStatus = votingStatus;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Poll poll = (Poll)o;
        return Objects.equals(this.durationMinutes, poll.durationMinutes) && Objects.equals(this.endDatetime, poll.endDatetime) && Objects.equals(this.id, poll.id) && Objects.equals(this.options, poll.options) && Objects.equals((Object)this.votingStatus, (Object)poll.votingStatus);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.durationMinutes, this.endDatetime, this.id, this.options, this.votingStatus});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class Poll {\n");
        sb.append("    durationMinutes: ").append(this.toIndentedString(this.durationMinutes)).append("\n");
        sb.append("    endDatetime: ").append(this.toIndentedString(this.endDatetime)).append("\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    options: ").append(this.toIndentedString(this.options)).append("\n");
        sb.append("    votingStatus: ").append(this.toIndentedString((Object)this.votingStatus)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static void validateJsonObject(JsonObject jsonObj) throws IOException {
        for (String requiredField : openapiRequiredFields) {
            if (jsonObj.get(requiredField) != null) continue;
            throw new IllegalArgumentException(String.format("The required field `%s` is not found in the JSON string: %s", requiredField, jsonObj.toString()));
        }
        if (jsonObj.get(SERIALIZED_NAME_ID) != null && !jsonObj.get(SERIALIZED_NAME_ID).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `id` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_ID).toString()));
        }
        JsonArray jsonArrayoptions = jsonObj.getAsJsonArray(SERIALIZED_NAME_OPTIONS);
        if (jsonArrayoptions != null) {
            if (!jsonObj.get(SERIALIZED_NAME_OPTIONS).isJsonArray()) {
                throw new IllegalArgumentException(String.format("Expected the field `options` to be an array in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_OPTIONS).toString()));
            }
            for (int i = 0; i < jsonArrayoptions.size(); ++i) {
                PollOption.validateJsonObject(jsonArrayoptions.get(i).getAsJsonObject());
            }
        }
        if (jsonObj.get(SERIALIZED_NAME_VOTING_STATUS) != null && !jsonObj.get(SERIALIZED_NAME_VOTING_STATUS).isJsonPrimitive()) {
            throw new IllegalArgumentException(String.format("Expected the field `voting_status` to be a primitive type in the JSON string but got `%s`", jsonObj.get(SERIALIZED_NAME_VOTING_STATUS).toString()));
        }
    }

    public static Poll fromJson(String jsonString) throws IOException {
        return (Poll)JSON.getGson().fromJson(jsonString, Poll.class);
    }

    public String toJson() {
        return JSON.getGson().toJson((Object)this);
    }

    static {
        openapiFields.add(SERIALIZED_NAME_DURATION_MINUTES);
        openapiFields.add(SERIALIZED_NAME_END_DATETIME);
        openapiFields.add(SERIALIZED_NAME_ID);
        openapiFields.add(SERIALIZED_NAME_OPTIONS);
        openapiFields.add(SERIALIZED_NAME_VOTING_STATUS);
        openapiRequiredFields = new HashSet();
        openapiRequiredFields.add(SERIALIZED_NAME_ID);
        openapiRequiredFields.add(SERIALIZED_NAME_OPTIONS);
    }

    public static class CustomTypeAdapterFactory
    implements TypeAdapterFactory {
        public <T> TypeAdapter<T> create(Gson gson, TypeToken<T> type) {
            if (!Poll.class.isAssignableFrom(type.getRawType())) {
                return null;
            }
            final TypeAdapter elementAdapter = gson.getAdapter(JsonElement.class);
            final TypeAdapter thisAdapter = gson.getDelegateAdapter((TypeAdapterFactory)this, TypeToken.get(Poll.class));
            return new TypeAdapter<Poll>(){

                public void write(JsonWriter out, Poll value) throws IOException {
                    JsonObject obj = thisAdapter.toJsonTree((Object)value).getAsJsonObject();
                    elementAdapter.write(out, (Object)obj);
                }

                public Poll read(JsonReader in) throws IOException {
                    JsonObject jsonObj = ((JsonElement)elementAdapter.read(in)).getAsJsonObject();
                    Poll.validateJsonObject(jsonObj);
                    return (Poll)thisAdapter.fromJsonTree((JsonElement)jsonObj);
                }
            }.nullSafe();
        }
    }

    @JsonAdapter(value=Adapter.class)
    public static enum VotingStatusEnum {
        OPEN("open"),
        CLOSED("closed");

        private String value;

        private VotingStatusEnum(String value) {
            this.value = value;
        }

        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        public static VotingStatusEnum fromValue(String value) {
            for (VotingStatusEnum b : VotingStatusEnum.values()) {
                if (!b.value.equals(value)) continue;
                return b;
            }
            throw new IllegalArgumentException("Unexpected value '" + value + "'");
        }

        public static class Adapter
        extends TypeAdapter<VotingStatusEnum> {
            public void write(JsonWriter jsonWriter, VotingStatusEnum enumeration) throws IOException {
                jsonWriter.value(enumeration.getValue());
            }

            public VotingStatusEnum read(JsonReader jsonReader) throws IOException {
                String value = jsonReader.nextString();
                return VotingStatusEnum.fromValue(value);
            }
        }
    }
}

