/*
 * Decompiled with CFR 0.152.
 */
package com.twitter.chill.config;

import com.esotericsoftware.kryo.Kryo;
import com.esotericsoftware.kryo.io.Input;
import com.esotericsoftware.kryo.io.Output;
import com.twitter.chill.Base64;
import com.twitter.chill.KryoInstantiator;
import com.twitter.chill.config.Config;
import com.twitter.chill.config.ConfigurationException;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;

public class ConfiguredInstantiator
extends KryoInstantiator {
    protected final KryoInstantiator delegate;
    public static final String KEY = "com.twitter.chill.config.configuredinstantiator";

    public ConfiguredInstantiator(Config config) throws ConfigurationException {
        String string = config.get(KEY);
        if (null == string) {
            this.delegate = new KryoInstantiator();
        } else {
            String[] stringArray = string.split(":");
            if (stringArray.length != 1 && stringArray.length != 2) {
                throw new ConfigurationException("Invalid Config Key: " + config.get(KEY));
            }
            KryoInstantiator kryoInstantiator = null;
            try {
                kryoInstantiator = ConfiguredInstantiator.reflect(Class.forName(stringArray[0]), config);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new ConfigurationException("Could not find class for: " + stringArray[0], classNotFoundException);
            }
            if (stringArray.length == 2) {
                this.delegate = ConfiguredInstantiator.deserialize(kryoInstantiator.newKryo(), stringArray[1]);
                if (null == this.delegate) {
                    throw new ConfigurationException("Null delegate from: " + stringArray[1]);
                }
            } else {
                this.delegate = kryoInstantiator;
            }
        }
    }

    @Override
    public Kryo newKryo() {
        return this.delegate.newKryo();
    }

    public KryoInstantiator getDelegate() {
        return this.delegate;
    }

    public static void setReflect(Config config, Class<? extends KryoInstantiator> clazz) {
        config.set(KEY, clazz.getName());
    }

    static KryoInstantiator reflect(Class<? extends KryoInstantiator> clazz, Config config) throws ConfigurationException {
        try {
            try {
                return clazz.getConstructor(Config.class).newInstance(config);
            }
            catch (NoSuchMethodException noSuchMethodException) {
                return clazz.newInstance();
            }
        }
        catch (InstantiationException instantiationException) {
            throw new ConfigurationException(instantiationException);
        }
        catch (IllegalAccessException illegalAccessException) {
            throw new ConfigurationException(illegalAccessException);
        }
        catch (InvocationTargetException invocationTargetException) {
            throw new ConfigurationException(invocationTargetException);
        }
    }

    public static void setSerialized(Config config, KryoInstantiator kryoInstantiator) throws ConfigurationException {
        ConfiguredInstantiator.setSerialized(config, KryoInstantiator.class, kryoInstantiator);
    }

    public static void setSerialized(Config config, Class<? extends KryoInstantiator> clazz, KryoInstantiator kryoInstantiator) throws ConfigurationException {
        KryoInstantiator kryoInstantiator2 = ConfiguredInstantiator.reflect(clazz, config);
        String string = ConfiguredInstantiator.serialize(kryoInstantiator2.newKryo(), kryoInstantiator);
        ConfiguredInstantiator.deserialize(kryoInstantiator2.newKryo(), string);
        config.set(KEY, clazz.getName() + ":" + string);
    }

    protected static KryoInstantiator deserialize(Kryo kryo, String string) throws ConfigurationException {
        try {
            return (KryoInstantiator)kryo.readClassAndObject(new Input(Base64.decode(string)));
        }
        catch (IOException iOException) {
            throw new ConfigurationException("could not deserialize: " + string, iOException);
        }
    }

    protected static String serialize(Kryo kryo, KryoInstantiator kryoInstantiator) {
        Output output = new Output(1024, 524288);
        kryo.writeClassAndObject(output, (Object)kryoInstantiator);
        return Base64.encodeBytes(output.toBytes());
    }
}

