/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.os.Handler;
import android.util.Pair;
import com.twilio.video.Logger;
import com.twilio.video.RtcStatsListener;
import com.twilio.video.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import tvi.webrtc.RTCStatsCollectorCallback;
import tvi.webrtc.RTCStatsReport;

public class RtcStatsAdapter
implements RTCStatsCollectorCallback {
    private static final Logger logger = Logger.getLogger(RtcStatsAdapter.class);
    private List<RTCStatsReport> rtcStatsReports = new ArrayList<RTCStatsReport>();
    private Queue<Pair<Handler, RtcStatsListener>> rtcStatsListenersQueue = new ConcurrentLinkedQueue<Pair<Handler, RtcStatsListener>>();

    public synchronized void onStatsDelivered(RTCStatsReport statsReport) {
        this.rtcStatsReports.add(statsReport);
    }

    public synchronized void raiseOnRtcStats() {
        Pair<Handler, RtcStatsListener> statsPair;
        logger.d("Calling onRtcStats on all RtcStatsListeners");
        while ((statsPair = this.rtcStatsListenersQueue.poll()) != null) {
            ArrayList<RTCStatsReport> rtcStatsReportsCopy = new ArrayList<RTCStatsReport>(this.rtcStatsReports);
            ((Handler)statsPair.first).post(() -> ((RtcStatsListener)statsPair.second).onRtcStats(rtcStatsReportsCopy));
        }
        this.rtcStatsReports.clear();
    }

    public synchronized void addRtcStatsListener(RtcStatsListener rtcStatsListener) {
        this.rtcStatsListenersQueue.offer((Pair<Handler, RtcStatsListener>)new Pair((Object)Util.createCallbackHandler(), (Object)rtcStatsListener));
    }

    public synchronized void cleanup() {
        for (Pair pair : this.rtcStatsListenersQueue) {
            logger.d("cleanup: Calling onRtcStats with an empty RTC stats report.");
            ((Handler)pair.first).post(() -> ((RtcStatsListener)listenerPair.second).onRtcStats(new ArrayList<RTCStatsReport>()));
        }
        this.rtcStatsListenersQueue.clear();
        this.rtcStatsReports.clear();
    }
}

