/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.ClientTrackSwitchOffControl;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.SinkHints;
import com.twilio.video.TrackPriority;
import com.twilio.video.VideoBandwidthProfileOptions;
import com.twilio.video.VideoContentPreferences;
import com.twilio.video.VideoContentPreferencesMode;
import com.twilio.video.VideoSinkHintsConsumer;
import com.twilio.video.VideoTextureView;
import com.twilio.video.VideoTrack;
import com.twilio.video.VideoView;
import tvi.webrtc.VideoSink;

public class RemoteVideoTrack
extends VideoTrack {
    private static final Logger logger = Logger.getLogger(RemoteVideoTrack.class);
    private static final String SWITCH_ON_SWITCH_OFF_ERROR = "RemoteVideoTrack.switchOn() and RemoteVideoTrack.switchOff() can only be called after setting ClientTrackSwitchOffControl.MANUAL and not setting maxTracks in VideoBandwidthProfileOptions.\";";
    private static final String SET_CONTENT_PREFERENCES_ERROR = "RemoteVideoTrack.setContentPreferences() can only be called after setting VideoContentPreferencesMode.MANUAL and not setting renderDimensions in VideoBandwidthProfileOptions.\";";
    private final String sid;
    private boolean isSwitchedOff;
    @Nullable
    private TrackPriority priority;
    private long nativeRemoteVideoTrackContext;
    @Nullable
    private final VideoBandwidthProfileOptions videoBandwidthProfileOptions;
    @VisibleForTesting
    @Nullable
    final VideoSinkHintsConsumer videoSinkHintsConsumer;
    private SinkHints cachedSinkHints = new SinkHints(-1L, null, null);

    RemoteVideoTrack(@NonNull tvi.webrtc.VideoTrack webRtcVideoTrack, @NonNull String sid, @NonNull String name, boolean enabled, boolean isSwitchedOff, @Nullable TrackPriority priority, @Nullable VideoBandwidthProfileOptions videoBandwidthProfileOptions, long nativeRemoteVideoTrackContext) {
        super(webRtcVideoTrack, enabled, name);
        this.sid = sid;
        this.isSwitchedOff = isSwitchedOff;
        this.priority = priority;
        this.nativeRemoteVideoTrackContext = nativeRemoteVideoTrackContext;
        this.videoBandwidthProfileOptions = videoBandwidthProfileOptions;
        this.videoSinkHintsConsumer = videoBandwidthProfileOptions != null ? new VideoSinkHintsConsumer(this.isInVideoContentPreferencesAutoMode() && this.isRenderDimensionsNotSet(), this.isInClientTrackSwitchOffAutoMode() && this.isMaxTracksNotSet(), this::addSinkHints) : null;
    }

    @NonNull
    public String getSid() {
        return this.sid;
    }

    @Override
    public synchronized void addSink(@NonNull VideoSink videoSink) {
        super.addSink(videoSink);
        if (!this.isReleased() && (this.isInClientTrackSwitchOffAutoMode() && this.isMaxTracksNotSet() || this.isInVideoContentPreferencesAutoMode() && this.isRenderDimensionsNotSet())) {
            long sinkHintsId = this.videoSinkHintsConsumer.getNextSinkHintsId();
            if (videoSink instanceof VideoTextureView) {
                ((VideoTextureView)videoSink).setupVideoSinkHintsProducer(this.videoSinkHintsConsumer, sinkHintsId);
            } else if (videoSink instanceof VideoView) {
                ((VideoView)videoSink).setupVideoSinkHintsProducer(this.videoSinkHintsConsumer, sinkHintsId);
            } else {
                Boolean isEnabled = true;
                if (!this.isMaxTracksNotSet()) {
                    isEnabled = null;
                }
                this.addSinkHints(new SinkHints(1L, isEnabled, null));
            }
            logger.d("Add a new VideoSink using the auto switch off policy with id = " + sinkHintsId);
        }
    }

    @Override
    public synchronized void removeSink(@NonNull VideoSink videoSink) {
        super.removeSink(videoSink);
        if (!this.isReleased() && (this.isInClientTrackSwitchOffAutoMode() && this.isMaxTracksNotSet() || this.isInVideoContentPreferencesAutoMode() && this.isRenderDimensionsNotSet())) {
            this.checkSinkAttachments();
            logger.d("Removing VideoSinkHintsProducer");
            if (videoSink instanceof VideoTextureView) {
                VideoTextureView view = (VideoTextureView)videoSink;
                this.removeSinkHints(view.getSinkHintsId());
                view.removeVideoSinkHintsProducer();
            } else if (videoSink instanceof VideoView) {
                VideoView view = (VideoView)videoSink;
                this.removeSinkHints(view.getSinkHintsId());
                view.removeVideoSinkHintsProducer();
            } else if (this.getSinks().isEmpty()) {
                this.removeSinkHints(1L);
            }
        }
    }

    public void switchOn() {
        SinkHints sinkHints;
        this.checkClientTrackSwitchOffParameters();
        logger.d("Manually switching on track");
        this.cachedSinkHints = sinkHints = new SinkHints(-1L, true, this.cachedSinkHints.getVideoContentPreferences());
        this.addSinkHints(sinkHints);
    }

    public void switchOff() {
        SinkHints sinkHints;
        this.checkClientTrackSwitchOffParameters();
        logger.d("Manually switching off track");
        this.cachedSinkHints = sinkHints = new SinkHints(-1L, false, this.cachedSinkHints.getVideoContentPreferences());
        this.addSinkHints(sinkHints);
    }

    public void setContentPreferences(VideoContentPreferences videoContentPreferences) {
        SinkHints sinkHints;
        this.checkSetContentPreferencesParameters();
        this.cachedSinkHints = sinkHints = new SinkHints(-1L, this.cachedSinkHints.isEnabled(), videoContentPreferences);
        this.addSinkHints(sinkHints);
    }

    public boolean isSwitchedOff() {
        return this.isSwitchedOff;
    }

    @Nullable
    public TrackPriority getPriority() {
        return this.priority;
    }

    public void setPriority(@Nullable TrackPriority priority) {
        this.priority = priority;
        if (!this.isReleased()) {
            this.nativeSetPriority(this.nativeRemoteVideoTrackContext, priority);
        }
    }

    void setSwitchedOff(boolean isSwitchedOff) {
        this.isSwitchedOff = isSwitchedOff;
    }

    @Override
    synchronized void release() {
        if (!this.isReleased()) {
            this.removeVideoSinkHintsProducers();
            super.release();
            this.nativeRelease(this.nativeRemoteVideoTrackContext);
            this.nativeRemoteVideoTrackContext = 0L;
        }
    }

    @Override
    synchronized boolean isReleased() {
        return this.nativeRemoteVideoTrackContext == 0L && super.isReleased();
    }

    void checkSinkAttachments() {
        if (this.isInClientTrackSwitchOffAutoMode() && this.isMaxTracksNotSet()) {
            if (this.getSinks().isEmpty()) {
                SinkHints sinkHints = new SinkHints(0L, false, null);
                this.addSinkHints(sinkHints);
            } else {
                this.removeSinkHints(0L);
            }
        }
    }

    private void removeVideoSinkHintsProducers() {
        for (VideoSink videoSink : this.getVideoSinks()) {
            if (videoSink instanceof VideoTextureView) {
                ((VideoTextureView)videoSink).removeVideoSinkHintsProducer();
            }
            if (!(videoSink instanceof VideoView)) continue;
            ((VideoView)videoSink).removeVideoSinkHintsProducer();
        }
    }

    private boolean isInVideoContentPreferencesAutoMode() {
        return this.videoBandwidthProfileOptions != null && (this.videoBandwidthProfileOptions.getVideoContentPreferencesMode() == VideoContentPreferencesMode.AUTO || this.videoBandwidthProfileOptions.getVideoContentPreferencesMode() == null);
    }

    private boolean isInClientTrackSwitchOffAutoMode() {
        return this.videoBandwidthProfileOptions != null && (this.videoBandwidthProfileOptions.getClientTrackSwitchOffControl() == ClientTrackSwitchOffControl.AUTO || this.videoBandwidthProfileOptions.getClientTrackSwitchOffControl() == null);
    }

    private void addSinkHints(SinkHints sinkHints) {
        if (!this.isReleased()) {
            logger.d("Add SinkHints = " + sinkHints);
            this.nativeAddSinkHints(this.nativeRemoteVideoTrackContext, sinkHints);
        }
    }

    private void removeSinkHints(long sinkId) {
        logger.d("Removing SinkHints for sink id: " + sinkId);
        this.nativeRemoveSinkHints(this.nativeRemoteVideoTrackContext, sinkId);
    }

    private void checkClientTrackSwitchOffParameters() {
        Preconditions.checkState(this.videoBandwidthProfileOptions != null && this.isMaxTracksNotSet() && this.videoBandwidthProfileOptions.getClientTrackSwitchOffControl() == ClientTrackSwitchOffControl.MANUAL, SWITCH_ON_SWITCH_OFF_ERROR);
    }

    private void checkSetContentPreferencesParameters() {
        Preconditions.checkState(this.videoBandwidthProfileOptions != null && this.videoBandwidthProfileOptions.getVideoContentPreferencesMode() == VideoContentPreferencesMode.MANUAL && this.isRenderDimensionsNotSet(), SET_CONTENT_PREFERENCES_ERROR);
    }

    private boolean isMaxTracksNotSet() {
        return this.videoBandwidthProfileOptions != null && this.videoBandwidthProfileOptions.getMaxTracks() == null;
    }

    private boolean isRenderDimensionsNotSet() {
        return this.videoBandwidthProfileOptions != null && this.videoBandwidthProfileOptions.getRenderDimensions().isEmpty();
    }

    private native void nativeSetPriority(long var1, TrackPriority var3);

    @VisibleForTesting
    native void nativeRelease(long var1);

    @VisibleForTesting
    native void nativeAddSinkHints(long var1, SinkHints var3);

    @VisibleForTesting
    native void nativeRemoveSinkHints(long var1, long var3);
}

