/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.content.Intent;
import android.media.projection.MediaProjection;
import android.os.Handler;
import android.util.DisplayMetrics;
import android.view.WindowManager;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.Logger;
import com.twilio.video.Preconditions;
import com.twilio.video.Util;
import com.twilio.video.VideoCapturer;
import com.twilio.video.VideoDimensions;
import com.twilio.video.VideoFormat;
import tvi.webrtc.CapturerObserver;
import tvi.webrtc.ScreenCapturerAndroid;
import tvi.webrtc.SurfaceTextureHelper;
import tvi.webrtc.TimestampAligner;
import tvi.webrtc.VideoFrame;

public class ScreenCapturer
implements VideoCapturer {
    private static final Logger logger = Logger.getLogger(ScreenCapturer.class);
    private static final int DEFAULT_SCREENCAPTURE_FRAME_RATE = 7;
    private boolean firstFrameReported;
    private int orientation;
    private final Context context;
    private final Intent screenCaptureIntentData;
    private final Listener screenCapturerListener;
    private final int screenCaptureIntentResult;
    private final Handler listenerHandler;
    private CapturerObserver capturerObserver;
    private ScreenCapturerAndroid webRtcScreenCapturer;
    private SurfaceTextureHelper surfaceTextureHelper;
    private VideoDimensions videoDimensions;
    private long lastFrameTimeStamp;
    private final long frameDelayMS;
    private final MediaProjection.Callback mediaProjectionCallback = new MediaProjection.Callback(){

        public void onStop() {
            super.onStop();
            logger.d("media projection stopped");
        }
    };
    private final CapturerObserver observerAdapter = new CapturerObserver(){

        public void onCapturerStarted(boolean success) {
            logger.d("screen capturer started");
            if (!success && ScreenCapturer.this.screenCapturerListener != null) {
                ScreenCapturer.this.listenerHandler.post(() -> ScreenCapturer.this.screenCapturerListener.onScreenCaptureError("Failed to start screen capturer"));
            }
            ScreenCapturer.this.capturerObserver.onCapturerStarted(success);
        }

        public void onCapturerStopped() {
            logger.d("screen capturer stopped");
        }

        public void onFrameCaptured(VideoFrame videoFrame) {
            if (!ScreenCapturer.this.firstFrameReported) {
                if (ScreenCapturer.this.screenCapturerListener != null) {
                    ScreenCapturer.this.listenerHandler.post(ScreenCapturer.this.screenCapturerListener::onFirstFrameAvailable);
                }
                ScreenCapturer.this.firstFrameReported = true;
            }
            VideoFrame.Buffer buffer = videoFrame.getBuffer();
            ScreenCapturer.this.videoDimensions = new VideoDimensions(buffer.getWidth(), buffer.getHeight());
            int currentOrientation = ScreenCapturer.this.getDeviceOrientation();
            if (ScreenCapturer.this.updateCaptureDimensions(ScreenCapturer.this.orientation, currentOrientation)) {
                logger.d("Swapping width and height of frame due to orientation");
                ScreenCapturer.this.orientation = currentOrientation;
                ScreenCapturer.this.webRtcScreenCapturer.changeCaptureFormat(buffer.getHeight(), buffer.getWidth(), (int)(1000L / ScreenCapturer.this.frameDelayMS));
            }
            int frameRotation = videoFrame.getRotation();
            ScreenCapturer.this.lastFrameTimeStamp = TimestampAligner.getRtcTimeNanos();
            ScreenCapturer.this.capturerObserver.onFrameCaptured(new VideoFrame(buffer, frameRotation, ScreenCapturer.this.lastFrameTimeStamp));
        }
    };

    public ScreenCapturer(@NonNull Context context, int screenCaptureIntentResult, @NonNull Intent screenCaptureIntentData, @Nullable Listener screenCapturerListener, int framesPerSecond) {
        Preconditions.checkNotNull(context, "context must not be null");
        Preconditions.checkNotNull(screenCaptureIntentData, "intent must not be null");
        this.context = context;
        this.screenCaptureIntentData = screenCaptureIntentData;
        this.screenCaptureIntentResult = screenCaptureIntentResult;
        this.screenCapturerListener = screenCapturerListener;
        this.listenerHandler = Util.createCallbackHandler();
        this.orientation = this.getDeviceOrientation();
        this.frameDelayMS = framesPerSecond > 0 ? (long)(1000 / framesPerSecond) : 7L;
    }

    public ScreenCapturer(@NonNull Context context, int screenCaptureIntentResult, @NonNull Intent screenCaptureIntentData, @Nullable Listener screenCapturerListener) {
        this(context, screenCaptureIntentResult, screenCaptureIntentData, screenCapturerListener, 7);
    }

    @Override
    public VideoFormat getCaptureFormat() {
        DisplayMetrics displayMetrics = new DisplayMetrics();
        WindowManager windowManager = (WindowManager)this.context.getSystemService("window");
        windowManager.getDefaultDisplay().getRealMetrics(displayMetrics);
        VideoDimensions screenDimensions = new VideoDimensions(displayMetrics.widthPixels, displayMetrics.heightPixels);
        return new VideoFormat(screenDimensions, (int)(1000L / this.frameDelayMS));
    }

    public boolean isScreencast() {
        return true;
    }

    public void initialize(@NonNull SurfaceTextureHelper surfaceTextureHelper, @NonNull Context context, @NonNull CapturerObserver capturerObserver) {
        this.capturerObserver = capturerObserver;
        this.surfaceTextureHelper = surfaceTextureHelper;
        this.webRtcScreenCapturer = new ScreenCapturerAndroid(this.screenCaptureIntentData, this.mediaProjectionCallback);
        this.webRtcScreenCapturer.initialize(surfaceTextureHelper, context, this.observerAdapter);
    }

    public void startCapture(int width, int height, int framerate) {
        this.firstFrameReported = false;
        this.lastFrameTimeStamp = 0L;
        if (this.screenCaptureIntentResult != -1) {
            if (this.screenCapturerListener != null) {
                this.listenerHandler.post(() -> this.screenCapturerListener.onScreenCaptureError("MediaProjection permissions must be granted to start ScreenCapturer"));
            }
            this.observerAdapter.onCapturerStarted(false);
            return;
        }
        this.webRtcScreenCapturer.startCapture(width, height, framerate);
        this.surfaceTextureHelper.getHandler().postDelayed(this::invokeDuplicateFrame, this.frameDelayMS);
    }

    public void stopCapture() {
        logger.d("stopCapture");
        this.lastFrameTimeStamp = 0L;
        if (this.webRtcScreenCapturer != null) {
            this.webRtcScreenCapturer.stopCapture();
        }
        logger.d("stopCapture done");
    }

    @Override
    public void dispose() {
        if (this.webRtcScreenCapturer != null) {
            this.webRtcScreenCapturer.dispose();
            this.webRtcScreenCapturer = null;
        }
    }

    private int getDeviceOrientation() {
        int orientation = 0;
        WindowManager wm = (WindowManager)this.context.getSystemService("window");
        switch (wm.getDefaultDisplay().getRotation()) {
            case 1: {
                orientation = 90;
                break;
            }
            case 2: {
                orientation = 180;
                break;
            }
            case 3: {
                orientation = 270;
                break;
            }
        }
        return orientation;
    }

    private boolean updateCaptureDimensions(int currentOrientation, int orientation) {
        if (currentOrientation == orientation || Math.abs(currentOrientation - orientation) == 180) {
            logger.d("No orientation change detected");
            return false;
        }
        logger.d("Orientation change detected");
        return true;
    }

    private void invokeDuplicateFrame() {
        if (0L != this.lastFrameTimeStamp) {
            long frameDeltaMS = (TimestampAligner.getRtcTimeNanos() - this.lastFrameTimeStamp) / 1000000L;
            if (this.frameDelayMS < frameDeltaMS) {
                this.surfaceTextureHelper.forceFrame();
            }
            this.surfaceTextureHelper.getHandler().postDelayed(this::invokeDuplicateFrame, this.frameDelayMS);
        }
    }

    @VisibleForTesting(otherwise=5)
    VideoDimensions getVideoDimensions() {
        return this.videoDimensions;
    }

    public static interface Listener {
        public void onScreenCaptureError(@NonNull String var1);

        public void onFirstFrameAvailable();
    }
}

