/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.annotation.VisibleForTesting;
import com.twilio.video.AudioCodec;
import com.twilio.video.BandwidthProfileOptions;
import com.twilio.video.EncodingParameters;
import com.twilio.video.G722Codec;
import com.twilio.video.H264Codec;
import com.twilio.video.IceOptions;
import com.twilio.video.IsacCodec;
import com.twilio.video.LocalAudioTrack;
import com.twilio.video.LocalDataTrack;
import com.twilio.video.LocalVideoTrack;
import com.twilio.video.MediaFactory;
import com.twilio.video.NetworkQualityConfiguration;
import com.twilio.video.OpusCodec;
import com.twilio.video.PcmaCodec;
import com.twilio.video.PcmuCodec;
import com.twilio.video.PlatformInfo;
import com.twilio.video.Preconditions;
import com.twilio.video.Util;
import com.twilio.video.VideoCodec;
import com.twilio.video.VideoEncodingMode;
import com.twilio.video.Vp8Codec;
import com.twilio.video.Vp9Codec;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class ConnectOptions {
    private static final Set<Class> SUPPORTED_CODECS = new HashSet<Class>(Arrays.asList(IsacCodec.class, OpusCodec.class, PcmuCodec.class, PcmaCodec.class, G722Codec.class, Vp8Codec.class, H264Codec.class, Vp9Codec.class));
    private final String accessToken;
    private final String roomName;
    private final String region;
    private final List<LocalAudioTrack> audioTracks;
    private final List<LocalVideoTrack> videoTracks;
    private final List<LocalDataTrack> dataTracks;
    private final IceOptions iceOptions;
    private final boolean enableIceGatheringOnAnyAddressPorts;
    private final boolean enableInsights;
    private final boolean enableAutomaticSubscription;
    private final boolean enableDominantSpeaker;
    private final boolean enableNetworkQuality;
    private final NetworkQualityConfiguration networkQualityConfiguration;
    private final List<AudioCodec> preferredAudioCodecs;
    private final List<VideoCodec> preferredVideoCodecs;
    private final EncodingParameters encodingParameters;
    private final BandwidthProfileOptions bandwidthProfile;
    private final VideoEncodingMode videoEncodingMode;
    private final MediaFactory mediaFactory;

    static void checkAudioCodecs(@Nullable List<AudioCodec> audioCodecs) {
        if (audioCodecs != null) {
            for (AudioCodec audioCodec : audioCodecs) {
                Preconditions.checkNotNull(audioCodec);
                Preconditions.checkArgument(SUPPORTED_CODECS.contains(audioCodec.getClass()), String.format("Unsupported audio codec %s", audioCodec.getName()));
            }
        }
    }

    static void checkVideoCodecs(@Nullable List<VideoCodec> videoCodecs) {
        if (videoCodecs != null) {
            for (VideoCodec videoCodec : videoCodecs) {
                Preconditions.checkNotNull(videoCodec);
                Preconditions.checkArgument(SUPPORTED_CODECS.contains(videoCodec.getClass()), String.format("Unsupported video codec %s", videoCodec.getName()));
            }
        }
    }

    static void checkAudioTracksReleased(@Nullable List<LocalAudioTrack> audioTracks) {
        if (audioTracks != null) {
            for (LocalAudioTrack localAudioTrack : audioTracks) {
                Preconditions.checkState(!localAudioTrack.isReleased(), "LocalAudioTrack cannot be released");
            }
        }
    }

    static void checkVideoTracksReleased(@Nullable List<LocalVideoTrack> videoTracks) {
        if (videoTracks != null) {
            for (LocalVideoTrack localVideoTrack : videoTracks) {
                Preconditions.checkState(!localVideoTrack.isReleased(), "LocalVideoTrack cannot be released");
            }
        }
    }

    static void checkVideoEncodingModeExclusivity(@Nullable VideoEncodingMode videoEncodingMode, @Nullable List<VideoCodec> videoCodecs, @Nullable EncodingParameters encodingParameters) {
        if (videoEncodingMode == VideoEncodingMode.AUTO) {
            Preconditions.checkArgument(videoCodecs == null, "Cannot set preferredVideoCodecs when videoEncodingMode is set to AUTO.");
            if (encodingParameters != null) {
                Preconditions.checkArgument(encodingParameters.maxVideoBitrate == 0, "Cannot set maxVideoBitrate when videoEncodingMode is set to AUTO.");
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ConnectOptions that = (ConnectOptions)o;
        if (this.enableIceGatheringOnAnyAddressPorts != that.enableIceGatheringOnAnyAddressPorts) {
            return false;
        }
        if (this.enableInsights != that.enableInsights) {
            return false;
        }
        if (this.enableAutomaticSubscription != that.enableAutomaticSubscription) {
            return false;
        }
        if (this.enableDominantSpeaker != that.enableDominantSpeaker) {
            return false;
        }
        if (this.enableNetworkQuality != that.enableNetworkQuality) {
            return false;
        }
        if (!this.accessToken.equals(that.accessToken)) {
            return false;
        }
        if (!Util.equals(this.roomName, that.roomName)) {
            return false;
        }
        if (!Util.equals(this.region, that.region)) {
            return false;
        }
        if (!Util.equals(this.audioTracks, that.audioTracks)) {
            return false;
        }
        if (!Util.equals(this.videoTracks, that.videoTracks)) {
            return false;
        }
        if (!Util.equals(this.dataTracks, that.dataTracks)) {
            return false;
        }
        if (!Util.equals(this.iceOptions, that.iceOptions)) {
            return false;
        }
        if (!Util.equals(this.networkQualityConfiguration, that.networkQualityConfiguration)) {
            return false;
        }
        if (!Util.equals(this.preferredAudioCodecs, that.preferredAudioCodecs)) {
            return false;
        }
        if (!Util.equals(this.preferredVideoCodecs, that.preferredVideoCodecs)) {
            return false;
        }
        if (!Util.equals(this.encodingParameters, that.encodingParameters)) {
            return false;
        }
        if (!Util.equals(this.bandwidthProfile, that.bandwidthProfile)) {
            return false;
        }
        if (!Util.equals((Object)this.videoEncodingMode, (Object)that.videoEncodingMode)) {
            return false;
        }
        return Util.equals(this.mediaFactory, that.mediaFactory);
    }

    public int hashCode() {
        int result = this.accessToken.hashCode();
        result = 31 * result + (this.roomName != null ? this.roomName.hashCode() : 0);
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        result = 31 * result + (this.audioTracks != null ? this.audioTracks.hashCode() : 0);
        result = 31 * result + (this.videoTracks != null ? this.videoTracks.hashCode() : 0);
        result = 31 * result + (this.dataTracks != null ? this.dataTracks.hashCode() : 0);
        result = 31 * result + (this.iceOptions != null ? this.iceOptions.hashCode() : 0);
        result = 31 * result + (this.enableIceGatheringOnAnyAddressPorts ? 1 : 0);
        result = 31 * result + (this.enableInsights ? 1 : 0);
        result = 31 * result + (this.enableAutomaticSubscription ? 1 : 0);
        result = 31 * result + (this.enableDominantSpeaker ? 1 : 0);
        result = 31 * result + (this.enableNetworkQuality ? 1 : 0);
        result = 31 * result + (this.networkQualityConfiguration != null ? this.networkQualityConfiguration.hashCode() : 0);
        result = 31 * result + (this.preferredAudioCodecs != null ? this.preferredAudioCodecs.hashCode() : 0);
        result = 31 * result + (this.preferredVideoCodecs != null ? this.preferredVideoCodecs.hashCode() : 0);
        result = 31 * result + (this.encodingParameters != null ? this.encodingParameters.hashCode() : 0);
        result = 31 * result + (this.bandwidthProfile != null ? this.bandwidthProfile.hashCode() : 0);
        result = 31 * result + (this.videoEncodingMode != null ? this.videoEncodingMode.hashCode() : 0);
        result = 31 * result + (this.mediaFactory != null ? this.mediaFactory.hashCode() : 0);
        return result;
    }

    private ConnectOptions(Builder builder) {
        this.accessToken = builder.accessToken;
        this.roomName = builder.roomName;
        this.audioTracks = builder.audioTracks;
        this.videoTracks = builder.videoTracks;
        this.dataTracks = builder.dataTracks;
        this.iceOptions = builder.iceOptions;
        this.enableIceGatheringOnAnyAddressPorts = builder.enableIceGatheringOnAnyAddressPorts;
        this.enableInsights = builder.enableInsights;
        this.enableAutomaticSubscription = builder.enableAutomaticSubscription;
        this.enableDominantSpeaker = builder.enableDominantSpeaker;
        this.enableNetworkQuality = builder.enableNetworkQuality;
        this.networkQualityConfiguration = builder.networkQualityConfiguration;
        this.preferredAudioCodecs = builder.preferredAudioCodecs;
        this.preferredVideoCodecs = builder.preferredVideoCodecs;
        this.region = builder.region;
        this.encodingParameters = builder.encodingParameters;
        this.mediaFactory = builder.mediaFactory;
        this.bandwidthProfile = builder.bandwidthProfile;
        this.videoEncodingMode = builder.videoEncodingMode;
    }

    String getAccessToken() {
        return this.accessToken;
    }

    String getRoomName() {
        return this.roomName;
    }

    List<LocalAudioTrack> getAudioTracks() {
        return this.audioTracks;
    }

    List<LocalVideoTrack> getVideoTracks() {
        return this.videoTracks;
    }

    List<LocalDataTrack> getDataTracks() {
        return this.dataTracks;
    }

    String getRegion() {
        return this.region;
    }

    IceOptions getIceOptions() {
        return this.iceOptions;
    }

    boolean isIceGatheringOnAnyAddressPortsEnabled() {
        return this.enableIceGatheringOnAnyAddressPorts;
    }

    boolean isInsightsEnabled() {
        return this.enableInsights;
    }

    boolean isNetworkQualityEnabled() {
        return this.enableNetworkQuality;
    }

    NetworkQualityConfiguration getNetworkQualityConfiguration() {
        return this.networkQualityConfiguration;
    }

    private LocalAudioTrack[] getLocalAudioTracksArray() {
        LocalAudioTrack[] audioTracksArray = new LocalAudioTrack[]{};
        if (this.audioTracks != null && this.audioTracks.size() > 0) {
            audioTracksArray = new LocalAudioTrack[this.audioTracks.size()];
            audioTracksArray = this.audioTracks.toArray(audioTracksArray);
        }
        return audioTracksArray;
    }

    private LocalVideoTrack[] getLocalVideoTracksArray() {
        LocalVideoTrack[] videoTracksArray = new LocalVideoTrack[]{};
        if (this.videoTracks != null && this.videoTracks.size() > 0) {
            videoTracksArray = new LocalVideoTrack[this.videoTracks.size()];
            videoTracksArray = this.videoTracks.toArray(videoTracksArray);
        }
        return videoTracksArray;
    }

    private LocalDataTrack[] getLocalDataTracksArray() {
        LocalDataTrack[] dataTracksArray = new LocalDataTrack[]{};
        if (this.dataTracks != null && this.dataTracks.size() > 0) {
            dataTracksArray = new LocalDataTrack[this.dataTracks.size()];
            dataTracksArray = this.dataTracks.toArray(dataTracksArray);
        }
        return dataTracksArray;
    }

    private AudioCodec[] getAudioCodecsArray() {
        AudioCodec[] audioCodecsArray = new AudioCodec[]{};
        if (this.preferredAudioCodecs != null && !this.preferredAudioCodecs.isEmpty()) {
            audioCodecsArray = new AudioCodec[this.preferredAudioCodecs.size()];
            audioCodecsArray = this.preferredAudioCodecs.toArray(audioCodecsArray);
        }
        return audioCodecsArray;
    }

    private VideoCodec[] getVideoCodecsArray() {
        VideoCodec[] videoCodecsArray = new VideoCodec[]{};
        if (this.preferredVideoCodecs != null && !this.preferredVideoCodecs.isEmpty()) {
            videoCodecsArray = new VideoCodec[this.preferredVideoCodecs.size()];
            videoCodecsArray = this.preferredVideoCodecs.toArray(videoCodecsArray);
        }
        return videoCodecsArray;
    }

    EncodingParameters getEncodingParameters() {
        return this.encodingParameters;
    }

    BandwidthProfileOptions getBandwidthProfile() {
        return this.bandwidthProfile;
    }

    VideoEncodingMode getVideoEncodingMode() {
        return this.videoEncodingMode;
    }

    @VisibleForTesting(otherwise=5)
    @Nullable
    MediaFactory getMediaFactory() {
        return this.mediaFactory;
    }

    private long createNativeConnectOptionsBuilder() {
        ConnectOptions.checkAudioTracksReleased(this.audioTracks);
        ConnectOptions.checkVideoTracksReleased(this.videoTracks);
        return this.nativeCreate(this.accessToken, this.roomName, this.getLocalAudioTracksArray(), this.getLocalVideoTracksArray(), this.getLocalDataTracksArray(), this.iceOptions, this.enableIceGatheringOnAnyAddressPorts, this.enableInsights, this.enableAutomaticSubscription, this.enableDominantSpeaker, this.enableNetworkQuality, this.networkQualityConfiguration, PlatformInfo.getNativeHandle(), this.getAudioCodecsArray(), this.getVideoCodecsArray(), this.region, this.encodingParameters, this.bandwidthProfile, this.videoEncodingMode);
    }

    private native long nativeCreate(String var1, String var2, LocalAudioTrack[] var3, LocalVideoTrack[] var4, LocalDataTrack[] var5, IceOptions var6, boolean var7, boolean var8, boolean var9, boolean var10, boolean var11, NetworkQualityConfiguration var12, long var13, AudioCodec[] var15, VideoCodec[] var16, String var17, EncodingParameters var18, BandwidthProfileOptions var19, VideoEncodingMode var20);

    public static class Builder {
        private String accessToken = "";
        private String roomName = "";
        private IceOptions iceOptions;
        private List<LocalAudioTrack> audioTracks;
        private List<LocalVideoTrack> videoTracks;
        private List<LocalDataTrack> dataTracks;
        private boolean enableIceGatheringOnAnyAddressPorts = false;
        private boolean enableInsights = true;
        private boolean enableAutomaticSubscription = true;
        private boolean enableDominantSpeaker = false;
        private boolean enableNetworkQuality = false;
        private NetworkQualityConfiguration networkQualityConfiguration;
        private List<AudioCodec> preferredAudioCodecs;
        private List<VideoCodec> preferredVideoCodecs;
        private String region = "gll";
        private EncodingParameters encodingParameters;
        private MediaFactory mediaFactory;
        private BandwidthProfileOptions bandwidthProfile;
        private VideoEncodingMode videoEncodingMode;

        public Builder(@NonNull String accessToken) {
            Preconditions.checkNotNull(accessToken);
            this.accessToken = accessToken;
        }

        @NonNull
        public Builder roomName(@NonNull String roomName) {
            Preconditions.checkNotNull(roomName);
            this.roomName = roomName;
            return this;
        }

        @NonNull
        public Builder audioTracks(@NonNull List<LocalAudioTrack> audioTracks) {
            Preconditions.checkNotNull(audioTracks, "LocalAudioTrack List must not be null");
            this.audioTracks = new ArrayList<LocalAudioTrack>(audioTracks);
            return this;
        }

        @NonNull
        public Builder videoTracks(@NonNull List<LocalVideoTrack> videoTracks) {
            Preconditions.checkNotNull(videoTracks, "LocalVideoTrack List must not be null");
            this.videoTracks = new ArrayList<LocalVideoTrack>(videoTracks);
            return this;
        }

        @NonNull
        public Builder dataTracks(@NonNull List<LocalDataTrack> dataTracks) {
            Preconditions.checkNotNull(dataTracks);
            this.dataTracks = dataTracks;
            return this;
        }

        @NonNull
        public Builder iceOptions(@NonNull IceOptions iceOptions) {
            Preconditions.checkNotNull(iceOptions);
            this.iceOptions = iceOptions;
            return this;
        }

        @NonNull
        public Builder enableIceGatheringOnAnyAddressPorts(boolean enable) {
            this.enableIceGatheringOnAnyAddressPorts = enable;
            return this;
        }

        @NonNull
        public Builder enableInsights(boolean enable) {
            this.enableInsights = enable;
            return this;
        }

        @NonNull
        public Builder enableAutomaticSubscription(boolean enableAutomaticSubscription) {
            this.enableAutomaticSubscription = enableAutomaticSubscription;
            return this;
        }

        @NonNull
        public Builder enableDominantSpeaker(boolean enableDominantSpeaker) {
            this.enableDominantSpeaker = enableDominantSpeaker;
            return this;
        }

        @NonNull
        public Builder enableNetworkQuality(boolean enableNetworkQuality) {
            this.enableNetworkQuality = enableNetworkQuality;
            return this;
        }

        @NonNull
        public Builder networkQualityConfiguration(@NonNull NetworkQualityConfiguration networkQualityConfiguration) {
            Preconditions.checkNotNull(networkQualityConfiguration);
            this.networkQualityConfiguration = networkQualityConfiguration;
            return this;
        }

        @NonNull
        public Builder preferAudioCodecs(@NonNull List<AudioCodec> preferredAudioCodecs) {
            Preconditions.checkNotNull(preferredAudioCodecs);
            this.preferredAudioCodecs = new ArrayList<AudioCodec>(preferredAudioCodecs);
            return this;
        }

        @NonNull
        public Builder preferVideoCodecs(@NonNull List<VideoCodec> preferredVideoCodecs) {
            Preconditions.checkNotNull(preferredVideoCodecs);
            this.preferredVideoCodecs = new ArrayList<VideoCodec>(preferredVideoCodecs);
            return this;
        }

        @NonNull
        public Builder region(@NonNull String region) {
            this.region = region;
            return this;
        }

        @NonNull
        public Builder encodingParameters(@NonNull EncodingParameters encodingParameters) {
            Preconditions.checkNotNull(encodingParameters);
            this.encodingParameters = encodingParameters;
            return this;
        }

        @NonNull
        public Builder bandwidthProfile(@Nullable BandwidthProfileOptions bandwidthProfile) {
            this.bandwidthProfile = bandwidthProfile;
            return this;
        }

        @NonNull
        public Builder videoEncodingMode(@Nullable VideoEncodingMode videoEncodingMode) {
            this.videoEncodingMode = videoEncodingMode;
            return this;
        }

        @VisibleForTesting(otherwise=5)
        Builder mediaFactory(@Nullable MediaFactory mediaFactory) {
            this.mediaFactory = mediaFactory;
            return this;
        }

        @NonNull
        public ConnectOptions build() {
            Preconditions.checkNotNull(this.accessToken, "Token must not be null.");
            Preconditions.checkArgument(!this.accessToken.equals(""), "Token must not be empty.");
            ConnectOptions.checkAudioTracksReleased(this.audioTracks);
            ConnectOptions.checkVideoTracksReleased(this.videoTracks);
            ConnectOptions.checkAudioCodecs(this.preferredAudioCodecs);
            ConnectOptions.checkVideoCodecs(this.preferredVideoCodecs);
            ConnectOptions.checkVideoEncodingModeExclusivity(this.videoEncodingMode, this.preferredVideoCodecs, this.encodingParameters);
            return new ConnectOptions(this);
        }
    }
}

