/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import com.twilio.video.Logger;
import com.twilio.video.SinkHints;

class VideoSinkHintsConsumer {
    private static final Logger logger = Logger.getLogger(VideoSinkHintsConsumer.class);
    static final long MANUAL_SINK_HINTS_ID = -1L;
    static final long NO_ATTACHED_SINK_HINTS_ID = 0L;
    static final long CUSTOM_SINK_HINTS_ID = 1L;
    private long sinkHintsIdCount = 2L;
    private final boolean videoContentPreferencesAutoModeEnabled;
    private final boolean clientTrackSwitchAutoModeEnabled;
    final ConsumeSinkHintsListener consumeSinkHintsListener;

    VideoSinkHintsConsumer(boolean videoContentPreferencesAutoModeEnabled, boolean clientTrackSwitchAutoModeEnabled, ConsumeSinkHintsListener consumeSinkHintsListener) {
        this.videoContentPreferencesAutoModeEnabled = videoContentPreferencesAutoModeEnabled;
        this.clientTrackSwitchAutoModeEnabled = clientTrackSwitchAutoModeEnabled;
        this.consumeSinkHintsListener = consumeSinkHintsListener;
    }

    void consumeSinkHints(SinkHints sinkHints) {
        logger.d("Consuming SinkHints = " + sinkHints);
        this.consumeSinkHintsListener.consumeSinkHints(sinkHints);
    }

    Long getNextSinkHintsId() {
        return this.sinkHintsIdCount++;
    }

    boolean isVideoContentPreferencesAutoModeEnabled() {
        return this.videoContentPreferencesAutoModeEnabled;
    }

    boolean isClientTrackSwitchAutoModeEnabled() {
        return this.clientTrackSwitchAutoModeEnabled;
    }

    static interface ConsumeSinkHintsListener {
        public void consumeSinkHints(SinkHints var1);
    }
}

