/*
 * Decompiled with CFR 0.152.
 */
package com.twilio.video;

import android.content.Context;
import android.content.res.TypedArray;
import android.os.Handler;
import android.os.Looper;
import android.support.annotation.NonNull;
import android.support.annotation.Nullable;
import android.util.AttributeSet;
import android.view.ViewGroup;
import com.twilio.video.EglBaseProvider;
import com.twilio.video.I420Frame;
import com.twilio.video.Logger;
import com.twilio.video.R;
import com.twilio.video.VideoRenderer;
import com.twilio.video.VideoScaleType;
import tvi.webrtc.RendererCommon;
import tvi.webrtc.SurfaceViewRenderer;

public class VideoView
extends SurfaceViewRenderer
implements VideoRenderer {
    private static final Logger logger = Logger.getLogger(VideoView.class);
    private final Handler uiThreadHandler = new Handler(Looper.getMainLooper());
    private final RendererCommon.RendererEvents internalEventListener = new RendererCommon.RendererEvents(){

        public void onFirstFrameRendered() {
            VideoView.this.refreshRenderer();
            if (VideoView.this.listener != null) {
                VideoView.this.listener.onFirstFrame();
            }
        }

        public void onFrameResolutionChanged(int videoWidth, int videoHeight, int rotation) {
            VideoView.this.refreshRenderer();
            if (VideoView.this.listener != null) {
                VideoView.this.listener.onFrameDimensionsChanged(videoWidth, videoHeight, rotation);
            }
        }
    };
    private boolean mirror = false;
    private boolean overlaySurface = false;
    private VideoScaleType videoScaleType = VideoScaleType.ASPECT_FIT;
    private VideoRenderer.Listener listener;
    private EglBaseProvider eglBaseProvider;

    public VideoView(@NonNull Context context) {
        this(context, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VideoView(@NonNull Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.VideoView, 0, 0);
        try {
            this.mirror = a.getBoolean(R.styleable.VideoView_mirror, false);
            this.videoScaleType = VideoScaleType.fromInt(a.getInteger(R.styleable.VideoView_scaleType, 0));
            this.overlaySurface = a.getBoolean(R.styleable.VideoView_overlaySurface, false);
        }
        finally {
            a.recycle();
        }
    }

    protected void onAttachedToWindow() {
        super.onAttachedToWindow();
        if (!this.isInEditMode()) {
            this.eglBaseProvider = EglBaseProvider.instance(this);
            this.setupRenderer();
        }
    }

    protected void onDetachedFromWindow() {
        super.release();
        this.eglBaseProvider.release(this);
        super.onDetachedFromWindow();
    }

    public boolean getMirror() {
        return this.mirror;
    }

    public void setMirror(boolean mirror) {
        this.mirror = mirror;
        super.setMirror(mirror);
        this.refreshRenderer();
    }

    @NonNull
    public VideoScaleType getVideoScaleType() {
        return this.videoScaleType;
    }

    public void setVideoScaleType(@NonNull VideoScaleType videoScaleType) {
        ViewGroup.LayoutParams layoutParams = this.getLayoutParams();
        if (layoutParams != null && (layoutParams.width == -1 || layoutParams.height == -1)) {
            VideoScaleType widthScaleType = layoutParams.width == -1 ? VideoScaleType.ASPECT_FILL : videoScaleType;
            VideoScaleType heightScaleType = layoutParams.height == -1 ? VideoScaleType.ASPECT_FILL : videoScaleType;
            logger.w(String.format("Scale type may not be applied as expected because video view uses MATCH_PARENT. Scaling will be applied as follows: width=%s, height=%s", widthScaleType.name(), heightScaleType.name()));
        }
        this.videoScaleType = videoScaleType;
        this.setScalingType(this.convertToWebRtcScaleType(videoScaleType));
        this.refreshRenderer();
    }

    public void setListener(@Nullable VideoRenderer.Listener listener) {
        this.listener = listener;
    }

    @Override
    public void renderFrame(@NonNull I420Frame frame) {
        super.renderFrame(frame.webRtcI420Frame);
    }

    public void applyZOrder(boolean overlaySurface) {
        this.overlaySurface = overlaySurface;
        this.setZOrderMediaOverlay(overlaySurface);
    }

    private void setupRenderer() {
        this.init(this.eglBaseProvider.getRootEglBase().getEglBaseContext(), this.internalEventListener);
        this.setMirror(this.mirror);
        this.setScalingType(this.convertToWebRtcScaleType(this.videoScaleType));
        this.setZOrderMediaOverlay(this.overlaySurface);
    }

    private void refreshRenderer() {
        this.uiThreadHandler.post(() -> ((VideoView)this).requestLayout());
    }

    private RendererCommon.ScalingType convertToWebRtcScaleType(VideoScaleType videoScaleType) {
        switch (videoScaleType) {
            case ASPECT_FIT: {
                return RendererCommon.ScalingType.SCALE_ASPECT_FIT;
            }
            case ASPECT_FILL: {
                return RendererCommon.ScalingType.SCALE_ASPECT_FILL;
            }
            case ASPECT_BALANCED: {
                return RendererCommon.ScalingType.SCALE_ASPECT_BALANCED;
            }
        }
        return RendererCommon.ScalingType.SCALE_ASPECT_FIT;
    }
}

